package com.dtyunxi.finance.api;

import com.dtyunxi.finance.api.dto.request.CarrierCorrectionConfigSaveReqDto;
import com.dtyunxi.rest.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 承运方式修正配置表服务接口
 *
 * @author jiaye
 * @since 2025-08-20
 */
@Api(tags = {"承运方式修正配置表服务"})
@FeignClient(
        contextId = "com-dtyunxi-finance-api-ICarrierCorrectionConfigApi",
        name = "${com.dtyunxi.finance.api.name:yundt-cube-center-finance}",
        path = "/v1/carrier",
        url = "${com.dtyunxi.finance.api:}"
)
public interface ICarrierCorrectionConfigApi {


    @PostMapping("/saveConfig")
    @ApiOperation(value = "保存承运方式修正配置", notes = "保存承运方式修正配置")
    RestResponse<Void> saveConfig(@RequestBody CarrierCorrectionConfigSaveReqDto addReqDto);

    /**
     * 删除承运方式修正配置表
     *
     * @param ids        承运方式修正配置表删除数据ID
     * @param instanceId 实例ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除承运方式修正配置表", notes = "删除承运方式修正配置表")
    RestResponse<Void> removeCarrierCorrectionConfig(@PathVariable("ids") String ids, @RequestParam("instanceId") Long instanceId);

}
