package com.dtyunxi.finance.api.query;

import com.dtyunxi.finance.api.dto.request.CarrierCorrectionConfigExtReqDto;
import com.dtyunxi.finance.api.dto.request.CarrierCorrectionConfigReqDto;
import com.dtyunxi.finance.api.dto.response.CarrierCorrectionConfigExtRespDto;
import com.dtyunxi.finance.api.dto.response.CarrierCorrectionConfigRespDto;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 承运方式修正配置表服务接口
 *
 * @author jiaye
 * @since 2025-08-20
 */
@Api(tags = {"承运方式修正配置表服务"})
@FeignClient(
        contextId = "com-dtyunxi-finance-api-query-ICarrierCorrectionConfigQueryApi",
        name = "${com.dtyunxi.finance.api.name:yundt-cube-center-finance}",
        path = "/v1/carrier",
        url = "${com.dtyunxi.finance.api:}"
)
public interface ICarrierCorrectionConfigQueryApi {

    /**
     * 根据id查询承运方式修正配置表
     *
     * @param id 承运方式修正配置表id
     * @return 承运方式修正配置表数据
     */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询承运方式修正配置表", notes = "根据id查询承运方式修正配置表")
    RestResponse<CarrierCorrectionConfigRespDto> queryById(@PathVariable("id") Long id);

    /**
     * 承运方式修正配置表分页数据
     *
     * @param reqDto   承运方式修正配置表查询条件
     * @param pageNum  当前页
     * @param pageSize 页大小
     * @return 承运方式修正配置表分页数据
     */
    @PostMapping("/page")
    @ApiOperation(value = "承运方式修正配置表分页数据", notes = "根据查询条件查询承运方式修正配置表数据")
    RestResponse<PageInfo<CarrierCorrectionConfigExtRespDto>> queryByPage(@RequestBody CarrierCorrectionConfigExtReqDto reqDto,
                                                                       @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                                       @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

    @PostMapping("/queryListByParams")
    @ApiOperation(value = "批量获取承运方式修正配置", notes = "批量获取承运方式修正配置")
    RestResponse<List<CarrierCorrectionConfigExtRespDto>> queryListByParams(@RequestBody CarrierCorrectionConfigExtReqDto reqDto);

    @PostMapping("/queryByParams")
    @ApiOperation(value = "根据条件获取承运方式修正配置", notes = "根据条件获取承运方式修正配置")
    RestResponse<CarrierCorrectionConfigExtRespDto> queryByParams(@RequestBody CarrierCorrectionConfigReqDto reqDto);

}
