package com.dtyunxi.finance.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.finance.api.dto.request.LogisticsSetttingsReqDto;
import com.dtyunxi.finance.api.dto.response.LogisticsSetttingsRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
* 物流公司关联设置服务接口
*
* @author longde
* @since 2022-07-15
*/
@Api(tags = {"物流公司关联设置服务"})
@FeignClient(
    contextId = "com-dtyunxi-finance-api-ILogisticsSetttingsApi",
    name = "${com.dtyunxi.finance.api.name:yundt-cube-center-finance}",
    path = "/v1/logistics/settings",
    url = "${com.dtyunxi.finance.api:}"
)
public interface ILogisticsSettingsApi {

/**
* 新增物流公司关联设置
*
* @param addReqDto 物流公司关联设置请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增物流公司关联设置", notes = "新增物流公司关联设置")
RestResponse<Long> addLogisticsSetttings(@RequestBody LogisticsSetttingsReqDto addReqDto);

    /**
    * 修改物流公司关联设置
    *
    * @param modifyReqDto 物流公司关联设置请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改物流公司关联设置", notes = "修改物流公司关联设置")
    RestResponse<Void> modifyLogisticsSetttings(@RequestBody LogisticsSetttingsReqDto modifyReqDto);

    /**
    * 删除物流公司关联设置
    *
    *
    * @param id 实例ID
    * @return 处理结果
    */
    @PostMapping("/delete/{id}")
    @ApiOperation(value = "删除物流公司关联设置", notes = "删除物流公司关联设置")
    RestResponse<Void> removeLogisticsSetttings(@RequestParam("id") Long id);

    /**
     * 物流公司关联设置作废
     *
     *
     * @param id 实例ID
     * @return 处理结果
     */
    @PostMapping("/tovoid/{id}")
    @ApiOperation(value = "物流公司关联设置作废", notes = "物流公司关联设置作废")
    RestResponse<Void> tovoidLogisticsSetttings(@RequestParam("id") Long id);
}
