package com.dtyunxi.finance.api.dto.request.logistic;

import com.dtyunxi.finance.api.dto.entity.BasePageDto;
import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Map;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "AppointAreaReqDto", description = "指定区域Dto")
public class AppointAreaReqDto extends BaseVo {

    @ApiModelProperty(name = "id", value = "ID")
    private Long id;

    @ApiModelProperty(name = "templateId", value = "物流费设置模板id")
    private String templateId;//'物流费设置模板id',

    @ApiModelProperty(name = "chargeType", value = "计费类型")
    private Integer chargeType;

    @ApiModelProperty(name = "type", value = "幅度类型 0：统一月份 1：淡旺季")
    private Integer type;//'幅度类型 0：统一月份 1：淡旺季',

    @ApiModelProperty(name = "province", value = "省份")
    private String province;// '省份',

    @ApiModelProperty(name = "city", value = "城市")
    private String city;//'城市',

    @ApiModelProperty(name = "area", value = "区/县")
    private String area;//'区/县',

    @ApiModelProperty(name = "day", value = "预计到达天数")
    private Integer day;//'预计到达天数',

    @ApiModelProperty(name = "params", value = "json参数")
    private String params;//'json参数',
}
