package com.dtyunxi.finance.api.dto.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 快递费合同导入模板
 *
 * @author 天泽
 */
@Data
@ApiModel(value = "TemplateCommonDto", description = "指定区域公用Dto")
public class ExpressCostCommonDto implements Serializable {

    @ApiModelProperty(name = "contractId", value = "快递合同id")
    private String contractId;

    @ApiModelProperty(name = "province", value = "省份")
    private String province;

    @ApiModelProperty(name = "city", value = "市")
    private String city;

    @ApiModelProperty(name = "area", value = "区/县")
    private String area;

    @ApiModelProperty(name = "day", value = "预计到达天数")
    private String day;

    public String getUniqueKey() {
        return String.format("%s-%s-%s", this.getProvince(), this.getCity(), this.getArea());
    }
}
