package com.dtyunxi.finance.api.query;

import com.dtyunxi.finance.api.dto.request.*;
import com.dtyunxi.finance.api.dto.response.SortingContractReportDetailRespDto;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import java.util.List;
import java.util.Set;

@Api(tags = {"分拣合同功能模块：分拣合同管理"})
@FeignClient(
        name = "${com.dtyunxi.finance.api.name:yundt-cube-center-finance}",
        path = "/v1/finance",
        url = "${com.dtyunxi.finance.api:}"
)
public interface SortingContractReportApi {
    @ApiOperation(
        tags = { "financeCenter/sortingReport/sortingContractReport" },
        value = "分拣合同新增",
        nickname = "getSortingContractReportAdd",
        notes = ""
    )
    @ApiResponses({
        @ApiResponse(code = 200, message = "成功")
    })
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/sortingContractReport/add",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    RestResponse<List<SortingContractReportDetailRespDto>> getSortingContractReportAdd(
            @ApiParam(value = "") @Valid @RequestBody(required = false) SortingContractReportAddReqDto sortingContractReportAddReqDto
    );

    @ApiOperation(
        tags = { "financeCenter/sortingReport/sortingContractReport" },
        value = "分拣合同复制",
        nickname = "getSortingContractReportCopy",
        notes = ""
    )
    @ApiResponses({
        @ApiResponse(code = 200, message = "成功")
    })
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/sortingContractReport/copy",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    RestResponse<PageInfo<Object>> getSortingContractReportCopy(
            @ApiParam(value = "") @Valid @RequestBody(required = false) SortingContractReportCopyReqDto sortingContractReportCopyReqDto
    );

    @ApiOperation(
        tags = { "financeCenter/sortingReport/sortingContractReport" },
        value = "分拣合同删除",
        nickname = "getSortingContractReportDelete",
        notes = ""
    )
    @ApiResponses({
        @ApiResponse(code = 200, message = "成功")
    })
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/sortingContractReport/delete",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    RestResponse<PageInfo<Object>> getSortingContractReportDelete(
            @ApiParam(value = "") @Valid @RequestBody(required = false) SortingContractReportDeleteReqDto sortingContractReportDeleteReqDto
    );

    @ApiOperation(
        tags = { "financeCenter/sortingReport/sortingContractReport" },
        value = "分拣合同详情",
        nickname = "getSortingContractReportDetail",
        notes = ""
    )
    @ApiResponses({
        @ApiResponse(code = 200, message = "成功")
    })
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/sortingContractReport/detail",
            produces = { "application/json" }
    )
    RestResponse<SortingContractReportDetailRespDto> getSortingContractReportDetail(
            @ApiParam(value = "") @Valid @RequestBody(required = false) SortingContractReportDetailQueryReqDto sortingContractReportDetailQueryReqDto
    );

    @ApiOperation(
        tags = { "financeCenter/sortingReport/sortingContractReport" },
        value = "分拣合同编辑",
        nickname = "getSortingContractReportEdit",
        notes = ""
    )
    @ApiResponses({
        @ApiResponse(code = 200, message = "成功")
    })
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/sortingContractReport/edit",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    RestResponse<Set<SortingContractReportDetailRespDto>> getSortingContractReportEdit(
            @ApiParam(value = "") @Valid @RequestBody(required = false) SortingContractReportEditReqDto sortingContractReportEditReqDto
    );

    @ApiOperation(
        tags = { "financeCenter/sortingReport/sortingContractReport" },
        value = "分拣合同列表",
        nickname = "getSortingContractReportListPage",
        notes = ""
    )
    @ApiResponses({
        @ApiResponse(code = 200, message = "成功")
    })
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/sortingContractReport/list",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    RestResponse<PageInfo<SortingContractReportDetailRespDto>> getSortingContractReportListPage(
            @ApiParam(value = "") @Valid @RequestBody(required = false) SortingContractListQueryReqDto sortingContractListQueryReqDto
    );

    @ApiOperation(
        tags = { "financeCenter/sortingReport/sortingContractReport" },
        value = "分拣合同作废",
        nickname = "getSortingContractReportTovoid",
        notes = ""
    )
    @ApiResponses({
        @ApiResponse(code = 200, message = "成功")
    })
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/sortingContractReport/tovoid",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    RestResponse<PageInfo<Object>> getSortingContractReportTovoid(
            @ApiParam(value = "") @Valid @RequestBody(required = false) SortingContractReportToVoidReqDto sortingContractReportToVoidReqDto
    );
}
