package com.dtyunxi.finance.api.dto.response.logistic;

import com.dtyunxi.finance.api.dto.request.logistic.VolumeLadderInfoDto;
import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;
import java.util.Map;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "AppointAreaQueryRespDto", description = "物流设置记录表Dto")
public class AppointAreaQueryRespDto extends BaseVo {

    @ApiModelProperty(name = "id", value = "ID")
    private Long id;

    @ApiModelProperty(name = "templateId", value = "物流费设置模板id")
    private Long templateId;//'物流费设置模板id',

    @ApiModelProperty(name = "chargeType", value = "计费类型")
    private Integer chargeType;

    @ApiModelProperty(name = "type", value = "幅度类型 0：统一月份 1：淡旺季")
    private Integer type;//'幅度类型 0：统一月份 1：淡旺季',

    @ApiModelProperty(name = "province", value = "省份")
    private String province;// '省份',

    @ApiModelProperty(name = "city", value = "城市")
    private String city;//'城市',

    @ApiModelProperty(name = "area", value = "区/县")
    private String area;//'区/县',

    @ApiModelProperty(name = "day", value = "预计到达天数")
    private Integer day;//'预计到达天数',

    @ApiModelProperty(name = "params", value = "json参数")
    private String params;//'json参数',

    @ApiModelProperty(name = "VolumeLadder", value = "json参数")
    private String VolumeLadder;;//'json参数',

    @ApiModelProperty(name = "bizParams", value = "json参数")
    private Map<String, Object> bizParams;//'json参数',

    @ApiModelProperty(name = "details", value = "体积阶梯值详情")
    private List<VolumeLadderInfoDto> details;

    @ApiModelProperty(name = "price", value = "计费方式为运费单价统一设置时运费单价")
    private String price;
}
