package com.dtyunxi.finance.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.finance.api.dto.request.InsuranceSettingsReqDto;
import com.dtyunxi.finance.api.dto.response.InsuranceSettingsRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
* 保险公司投保设置服务接口
*
* @author longde
* @since 2022-07-15
*/
@Api(tags = {"保险公司投保设置服务"})
@FeignClient(
    contextId = "com-dtyunxi-finance-api-query-IInsuranceSettingsQueryApi",
    name = "${com.dtyunxi.finance.api.name:yundt-cube-center-finance}",
    path = "/v1/insurance/settings",
    url = "${com.dtyunxi.finance.api:}"
)
public interface IInsuranceSettingsQueryApi {

    /**
    * 根据id查询保险公司投保设置
    *
    * @param id 保险公司投保设置id
    * @return   保险公司投保设置数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询保险公司投保设置", notes = "根据id查询保险公司投保设置")
    RestResponse<InsuranceSettingsRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 保险公司投保设置分页数据
    *
    * @param filter   保险公司投保设置查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 保险公司投保设置分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "保险公司投保设置分页数据", notes = "根据filter查询条件查询保险公司投保设置数据，filter=InsuranceSettingsReqDto")
    RestResponse<PageInfo<InsuranceSettingsRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);


    /**
     * 查询所有保险公司
     *
     */
    @GetMapping("/queryall")
    @ApiOperation(value = "查询所有保险公司", notes = "查询所有保险公司")
    RestResponse<List<InsuranceSettingsRespDto>> queryAllInsurance();
}
