package com.dtyunxi.finance.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.finance.api.dto.request.InsuranceSettingsLogReqDto;
import com.dtyunxi.finance.api.dto.response.InsuranceSettingsLogRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.GetMapping;
import com.github.pagehelper.PageInfo;

/**
* 保险公司投保设置修改记录表服务接口
*
* @author longde
* @since 2022-07-25
*/
@Api(tags = {"保险公司投保设置修改记录表服务"})
@FeignClient(
    contextId = "com-dtyunxi-finance-api-query-IInsuranceSettingsLogQueryApi",
    name = "${com.dtyunxi.finance.api.name:yundt-cube-center-finance}",
    path = "/v1/insuranceSettingsLog",
    url = "${com.dtyunxi.finance.api:}"
)
public interface IInsuranceSettingsLogQueryApi {

    /**
    * 根据id查询保险公司投保设置修改记录表
    *
    * @param id 保险公司投保设置修改记录表id
    * @return   保险公司投保设置修改记录表数据
    */
    @GetMapping("/{id}")
    @ApiOperation(value = "根据id查询保险公司投保设置修改记录表", notes = "根据id查询保险公司投保设置修改记录表")
    RestResponse<InsuranceSettingsLogRespDto> queryById(@PathVariable("id") Long id);

    /**
    * 保险公司投保设置修改记录表分页数据
    *
    * @param filter   保险公司投保设置修改记录表查询条件
    * @param pageNum  当前页
    * @param pageSize 页大小
    * @return 保险公司投保设置修改记录表分页数据
    */
    @GetMapping("/page")
    @ApiOperation(value = "保险公司投保设置修改记录表分页数据", notes = "根据filter查询条件查询保险公司投保设置修改记录表数据，filter=InsuranceSettingsLogReqDto")
    RestResponse<PageInfo<InsuranceSettingsLogRespDto>> queryByPage(@RequestParam("filter") String filter,
                                                           @RequestParam(name = "pageNum", required = false, defaultValue = "1") Integer pageNum,
                                                           @RequestParam(name = "pageSize", required = false, defaultValue = "10") Integer pageSize);

}
