package com.dtyunxi.finance.api.dto.response.logistic;

import com.dtyunxi.vo.BaseVo;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "OilLinkRespDto", description = "油价联动配置Dto")
public class OilLinkRespDto extends BaseVo {

    @ApiModelProperty(value = "ID")
    private Long id;

    @ApiModelProperty(value = "仓库ID")
    private String warehouseId;

    @ApiModelProperty(value = "仓库名称")
    private String warehouseName;

    @ApiModelProperty(value = "请求地址")
    private String postUrl;

    @ApiModelProperty(value = "记账时间")
    private Date lastTime;

    @ApiModelProperty(value = "调整时间")
    private Date adjustDate;

    @ApiModelProperty(value = "单价（元/升）")
    private BigDecimal amount;

    @ApiModelProperty(name="createTime", value = "创建时间")
    @JsonProperty("createTime")
    private Date createTime;


    @ApiModelProperty(name="updateTime", value = "更新时间")
    @JsonProperty("updateTime")
    private Date updateTime;


    @ApiModelProperty(name="createPerson", value = "创建人")
    @JsonProperty("createPerson")
    private String createPerson;


    @ApiModelProperty(name="updatePerson", value = "更新人")
    @JsonProperty("updatePerson")
    private String updatePerson;
}
