
package com.dtyunxi.finance.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * TODO 该类及类中的方法仅做示例，测试及上线阶段请自行删除，请勿在该类中编写真实的业务代码。
 *
 * 中心请求Dto实体（示例）
 * <p>
 * 规范要求：
 * 请求、相应的Dto分开，分别放到request、response包下；
 * 请求实体以[ReqDto]为后缀，如用户查询Dto，可以命名为 UserReqDto；
 * 响应实体以[RespDto]为后缀，如用户响应Dto，可以命名为 UserRespDto；
 *
 * @author 书生
 * @since 1.0.0
 */
@ApiModel(value = "ExampleDto", description = "示例Dto")
public class ExampleReqDto extends BaseVo {

    private static final long serialVersionUID = -5324816712440464348L;

    private Long id;
    /**
     * 用户名/登录名
     */
    @ApiModelProperty(value = "用户名/登录名")
    private String userName;

    /**
     * 密码
     */
    @ApiModelProperty(value = "密码")
    private String password;

    /**
     * 1启用2禁用
     */
    @ApiModelProperty(value = "1启用2禁用")
    private Integer status;

    /**
     * 有效起始时间
     */
    @ApiModelProperty(value = "有效起始时间")
    private Date validStartDate;

    /**
     * 有效结束时间
     */
    @ApiModelProperty(value = "有效结束时间")
    private Date validEndDate;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Date getValidStartDate() {
        return validStartDate;
    }

    public void setValidStartDate(Date validStartDate) {
        this.validStartDate = validStartDate;
    }

    public Date getValidEndDate() {
        return validEndDate;
    }

    public void setValidEndDate(Date validEndDate) {
        this.validEndDate = validEndDate;
    }
}
