package com.dtyunxi.finance.api;

import com.dtyunxi.finance.api.dto.request.ExpressCostAreaReqDto;
import com.dtyunxi.finance.api.dto.request.ExpressCostContractReqDto;
import com.dtyunxi.finance.api.dto.response.ExpressCostAreaRespDto;
import com.dtyunxi.finance.api.dto.response.ExpressCostContractRespDto;
import com.dtyunxi.finance.api.dto.response.ExpressCostContractSaveRespDto;
import com.dtyunxi.rest.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 快递费用合同服务接口
 *
 * @author 天泽
 * @since 2022-11-10
 */
@Api(tags = {"快递费用合同服务"})
@FeignClient(
        contextId = "com-dtyunxi-tcbj-api-IExpressCostContractApi",
        name = "${com.dtyunxi.finance.api.name:yundt-cube-center-finance}",
        path = "/v1/express/cost/contract",
        url = "${com.dtyunxi.finance.api:}"
)
public interface IExpressCostContractApi {

    /**
     * 新增快递费用合同
     *
     * @param addReqDto 快递费用合同请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增快递费用合同", notes = "新增快递费用合同")
    RestResponse<Long> addExpressCostContract(@RequestBody ExpressCostContractReqDto addReqDto);

    /**
     * 修改快递费用合同
     *
     * @param modifyReqDto 快递费用合同请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改快递费用合同", notes = "修改快递费用合同")
    RestResponse<Void> modifyExpressCostContract(@RequestBody ExpressCostContractReqDto modifyReqDto);

    /**
     * 删除快递费用合同
     *
     * @param ids        快递费用合同删除数据ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除快递费用合同", notes = "删除快递费用合同")
    RestResponse<Void> removeExpressCostContract(@PathVariable("ids") String ids);

    /**
     * 保存快递费用合同
     *
     * @param reqDto 保存快递费用合同
     * @return 有时间冲突的合同列表
     */
    @PostMapping("/save")
    @ApiOperation(value = "保存快递费用合同", notes = "保存快递费用合同")
    RestResponse<ExpressCostContractSaveRespDto> save(@RequestBody ExpressCostContractReqDto reqDto);

    /**
     * 保存快递费用合同-区域
     *
     * @param reqDtoList 保存快递费用合同-区域
     * @return void
     */
    @PostMapping("/area/save")
    @ApiOperation(value = "保存快递费用合同-区域", notes = "保存快递费用合同-区域")
    RestResponse<Void> areaSave(@RequestBody List<ExpressCostAreaReqDto> reqDtoList);

    /**
     * 快递费用合同-编辑
     *
     * @param reqDto 保存快递费用合同-区域
     * @return void
     */
    @PostMapping("/area/edit")
    @ApiOperation(value = "快递费用合同-编辑", notes = "快递费用合同-编辑")
    RestResponse<Void> areaEdit(@RequestBody ExpressCostAreaReqDto reqDto);

    /**
     * 作废快递费用合同
     *
     * @param ids        需要作废的合同Id
     * @return 处理结果
     */
    @DeleteMapping("/nullify/{ids}")
    @ApiOperation(value = "作废快递费用合同", notes = "作废快递费用合同")
    RestResponse<Void> nullify(@PathVariable("ids") String ids);

    /**
     * 清空物快递合同-区域
     *
     * @param contractId        快递费用合同删除数据ID
     * @return 处理结果
     */
    @DeleteMapping("/area/removeAll/{contractId}")
    @ApiOperation(value = "清空物流运费合同-区域", notes = "清空物流运费合同-区域")
    RestResponse<Void> areaRemoveAll(@PathVariable("contractId") Long contractId);


    /**
     * 快递合同-区域删除
     *
     * @param id        快递费用合同区域删除
     * @return 处理结果
     */
    @DeleteMapping("/area/del/{id}")
    @ApiOperation(value = "快递合同-区域删除", notes = "快递合同-区域删除")
    RestResponse<Void> areaDel(@PathVariable("id") Long id);

    /**
     * 快递合同-区域新增
     *
     * @param reqDto        快递费用合同区域新增
     * @return 处理结果
     */
    @PostMapping("/area/add")
    @ApiOperation(value = "快递费用合同区域新增", notes = "快递费用合同区域新增")
    RestResponse<Void> areaAdd(@RequestBody ExpressCostAreaReqDto reqDto);

}
