package com.dtyunxi.finance.api;

import com.dtyunxi.finance.api.dto.request.logistic.*;
import com.dtyunxi.finance.api.dto.response.logistic.OilChangeRespDto;
import com.dtyunxi.finance.api.dto.response.logistic.OilLinkRespDto;
import com.dtyunxi.rest.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags = {"物流费用功能模块：操作服务"})
@FeignClient(
        name = "${com.dtyunxi.finance.api.name:yundt-cube-center-finance}",
        path = "/v1/logistic",
        url = "${com.dtyunxi.finance.api:}"
)
public interface ILogisticApi {

    /**
     * 新增油价浮动配置方法
     *
     * @param dto 新增实体
     * @return Long 数据保存后的ID
     */
    @PostMapping("/oilChange/save")
    @ApiOperation(value = "新增油价浮动配置方法", notes = "新增油价浮动配置方法")
    RestResponse<OilChangeRespDto> saveOilChange(@RequestBody OilChangeReqDto dto);

    /**
     * 删除模板
     * @param id
     * @return
     */
    @RequestMapping(method = RequestMethod.DELETE, value = "/oilChange/remove/{id}", produces = { "application/json" })
    @ApiOperation(value = "删除油价浮动方法", notes = "删除油价浮动方法")
    RestResponse<Long> removeOilChange(@PathVariable("id") String id);

    /**
     * 新增油价联动设置方法
     *
     * @param dto 新增实体
     * @return Long 数据保存后的ID
     */
    @PostMapping("/oilLink/save")
    @ApiOperation(value = "新增油价联动设置方法", notes = "新增油价联动设置方法")
    RestResponse<OilLinkRespDto> saveOilLink(@RequestBody OilLinkReqDto dto);

    /**
     * 删除油价联动设置方法
     *
     * @param id id
     * @return Long 数据保存后的ID
     */
    @PostMapping("/oilLink/remove/{id}")
    @ApiOperation(value = "新增油价联动设置方法", notes = "新增油价联动设置方法")
    RestResponse<Void> removeOilLink(@PathVariable("id") Long id);

    /**
     * 新增物流模板方法
     *
     * @param dto 新增实体
     * @return Long 数据保存后的ID
     */
    @PostMapping("/logisticRecord/save")
    @ApiOperation(value = "新增物流模板方法", notes = "新增物流模板方法")
    RestResponse<Long> saveLogisticRecord(@RequestBody LogisticRecordReqDto dto);

    /**
     * 删除模板
     * @param id
     * @return
     */
    @RequestMapping(method = RequestMethod.DELETE, value = "/logisticRecord/remove/{id}", produces = { "application/json" })
    @ApiOperation(value = "删除物流模板方法", notes = "删除物流模板方法")
    RestResponse<Long> removeLogisticRecord(@PathVariable("id") String id);

    /**
     * 复制模板
     * @param id
     * @return
     */
    @RequestMapping(method = RequestMethod.PUT, value = "/logisticRecord/add/{id}", produces = { "application/json" })
    @ApiOperation(value = "复制物流模板方法", notes = "复制物流模板方法")
    RestResponse<Long> copyLogisticRecord(@PathVariable("id") String id);

    /**
     * 废除模板
     * @param id
     * @return
     */
    @RequestMapping(method = RequestMethod.PUT, value = "/logisticRecord/abolish/{id}", produces = { "application/json" })
    @ApiOperation(value = "废除物流模板方法", notes = "废除物流模板方法")
    RestResponse<Long> abolishLogisticRecord(@PathVariable("id") String id);

    /**
     * 保存指定区域数据
     * @param reqDto
     * @return
     */
    @PostMapping("/appointArea/save")
    @ApiOperation(value = "保存指定区域数据", notes = "保存指定区域数据")
    RestResponse<String> saveAppointArea(@RequestBody List<AppointAreaReqDto> reqDto);

    /**
     * 删除指定区域
     * @param id
     * @return
     */
    @RequestMapping(method = RequestMethod.DELETE, value = "/appointArea/remove/{id}", produces = { "application/json" })
    @ApiOperation(value = "删除指定区域方法", notes = "删除指定区域方法")
    RestResponse<Long> removeAppointArea(@PathVariable("id") String id);

    /**
     * 清空指定区域
     * @param templateId
     * @return
     */
    @RequestMapping(method = RequestMethod.DELETE, value = "/appointArea/removeAll/{templateId}", produces = { "application/json" })
    @ApiOperation(value = "清空指定区域方法", notes = "清空指定区域方法")
    RestResponse<String> removeAllAppointArea(@PathVariable("templateId") String templateId);

    /**
     * 编辑指定区域
     * @param reqDto
     * @return
     */
    @PostMapping("/appointArea/update")
    @ApiOperation(value = "更新指定区域数据", notes = "更新指定区域数据")
    RestResponse<Long> updateAppointAreaById(@RequestBody AppointAreaReqDto reqDto);

    /**
     *合同区域 按运费单价区域阶梯设置
     *
     * @param volumeLadderDto  阶梯值
     * @return void
     */
    @PostMapping("/volume/ladder/save")
    @ApiOperation(value = "按运费单价区域阶梯设置", notes = "按运费单价区域阶梯设置")
    RestResponse<Void> volumeLadderSave(@RequestBody @Validated VolumeLadderDto volumeLadderDto);


    /**
     * 新增指定区域
     * @param reqDto
     * @return
     */
    @PostMapping("/appointArea/add")
    @ApiOperation(value = "新增指定区域", notes = "新增指定区域")
    RestResponse<Long> addAppointArea(@RequestBody AppointAreaReqDto reqDto);
}
