package com.dtyunxi.finance.api.dto.request.logistic;

import com.dtyunxi.finance.api.dto.entity.BasePageDto;
import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.validation.constraints.NotEmpty;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "LogisticRecordReqDto", description = "油价联动配置Dto")
public class LogisticRecordReqDto extends BaseVo {

    @ApiModelProperty(name = "id", value = "ID")
    private String id;

    @ApiModelProperty(name = "contractName", value = "合同名称")
    @NotEmpty(message = "合同名称参数不能为空")
    private String contractName;//'合同名称',

    @ApiModelProperty(name = "warehouseId", value = "合同名称")
    @NotEmpty(message = "仓库ID参数不能为空")
    private String warehouseId;

    @ApiModelProperty(name = "warehouseName", value = "仓库名称")
    @NotEmpty(message = "仓库名称参数不能为空")
    private String warehouseName;//'仓库',

    @ApiModelProperty(name = "logisticId", value = "物流公司")
    @NotEmpty(message = "物流公司ID参数不能为空")
    private String logisticId;

    @ApiModelProperty(name = "logisticCompany", value = "物流公司")
    @NotEmpty(message = "物流公司参数不能为空")
    private String logisticCompany;//'物流公司',

    @ApiModelProperty(name = "transportType", value = "承运方式")
    @NotEmpty(message = "承运方式参数不能为空")
    private String transportType;//'承运方式',

    @ApiModelProperty(name = "chargeMode", value = "计算方式")
    @NotEmpty(message = "计算方式参数不能为空")
    private Integer chargeMode;//'计算方式',

    @ApiModelProperty(name = "params", value = "计算方式json参数")
    private String params;//'计算方式json参数',

    @ApiModelProperty(name = "startTime", value = "有效开始时间")
    @NotEmpty(message = "有效开始时间参数不能为空")
    private Date startTime;//'有效开始时间',

    @ApiModelProperty(name = "endTime", value = "有效结束时间")
    @NotEmpty(message = "有效结束时间参数不能为空")
    private Date endTime;//'有效结束时间',

    @ApiModelProperty(name = "deliveryPrice", value = "送货费用")
    private BigDecimal deliveryPrice;//'送货费用',

    @ApiModelProperty(name = "unloadPrice", value = "卸货费单价")
    private BigDecimal unloadPrice;//'卸货费单价',

    @ApiModelProperty(name = "contractOilPrice", value = "合同基准油价")
    private BigDecimal contractOilPrice;//'合同基准油价',

    @ApiModelProperty(name = "address", value = "发改委地址")
    private String address;//'发改委地址',

    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;//'备注',

    @ApiModelProperty(name = "seasonType", value = "季节类型")
    @NotEmpty(message = "季节类型参数不能为空")
    private Integer seasonType;//季节类型

    @ApiModelProperty(name = "offSeason", value = "淡季")
    private String offSeason;//淡季

    @ApiModelProperty(name = "peakSeason", value = "旺季")
    private String peakSeason;//旺季

    @ApiModelProperty(name = "copyFlag  ", value = "复制标识 true 复制，false 非复制")
    private Boolean copyFlag = Boolean.FALSE ;

    @ApiModelProperty(name = "sourceId  ", value = "被复制的合同ID")
    private Long sourceId ;


}
