/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.finance.biz.util;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class CodeGenerateUtil {
    @Resource
    private ICacheService cacheService;

    public static String getIdPrefix(LocalDateTime now) {
        return now.format(DateTimeFormatter.ofPattern("yyMMddHHmmss"));
    }

    public static String getIdPrefixDay(LocalDateTime now) {
        return now.format(DateTimeFormatter.ofPattern("yyMMddHH"));
    }

    private long generate(String key, Date expireTime) {
        Long expire = this.cacheService.getToLiveTime(key);
        if (expire == -1L) {
            this.cacheService.expireAt(key, expireTime.getTime());
        }
        return this.cacheService.incrBy(key, 1L);
    }

    public String generateNo(String prefix, int weiShu) {
        LocalDateTime now = LocalDateTime.now();
        String idPrefix = CodeGenerateUtil.getIdPrefix(now);
        String id = prefix + idPrefix + String.format("%1$0" + weiShu + "d", this.generate(prefix + idPrefix, this.getExpireAtTime(now)));
        return id;
    }

    public String generateNoDay(String prefix, int suffixSize) {
        LocalDateTime now = LocalDateTime.now();
        String idPrefix = CodeGenerateUtil.getIdPrefixDay(now);
        String id = prefix + idPrefix + String.format("%1$0" + (suffixSize - 2) + "d", this.generate(prefix + idPrefix, this.getExpireAtTime(now)));
        return id;
    }

    private Date getExpireAtTime(LocalDateTime now) {
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDateTime localDateTime = now.plusDays(1L);
        ZonedDateTime zdt = localDateTime.atZone(zoneId);
        Date date = Date.from(zdt.toInstant());
        return date;
    }
}

