/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.finance.biz.scheduler.task;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.finance.biz.bulelakespider.BlueLakeWhMappingEnum;
import com.dtyunxi.finance.dao.das.OilLinkDas;
import com.dtyunxi.finance.dao.eo.OilLinkEo;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class BlueLakeTask
extends SingleTupleScheduleEvent {
    private static final Logger log = LoggerFactory.getLogger(BlueLakeTask.class);
    @Resource
    public OilLinkDas oilLinkDas;

    public void before(TaskMsg taskMsg) {
        log.info("\u6cb9\u4ef7\u722c\u866b\u722c\u53d6\u5f00\u59cb");
    }

    public boolean execute(TaskMsg taskMsg) {
        Arrays.stream(BlueLakeWhMappingEnum.values()).forEach(en -> {
            OilLinkEo oilLinkEo = new OilLinkEo();
            oilLinkEo.setLastTime(new Date());
            oilLinkEo.setWarehouseId(en.getWarehouseCode());
            oilLinkEo.setWarehouseName(en.getWarehouseName());
            oilLinkEo.setPostUrl(en.getTargetUrl());
            oilLinkEo.setCreatePerson("\u7cfb\u7edf");
            Optional.ofNullable(en.getProcessClass().get().process()).filter(r -> StringUtils.isNotBlank((CharSequence)r.getLiter())).ifPresent(r -> {
                try {
                    oilLinkEo.setUpdatePerson("\u7cfb\u7edf");
                    oilLinkEo.setPostUrl(r.getUrl());
                    oilLinkEo.setAmount(new BigDecimal(r.getLiter().trim()));
                    oilLinkEo.setAdjustDate(r.getAdjustTime());
                }
                catch (Exception e) {
                    log.info("\u6cb9\u4ef7\u722c\u53d6\u5f02\u5e38:{}:{}", (Object)e.getMessage(), r);
                    e.printStackTrace();
                }
            });
            this.oilLinkDas.insert((BaseEo)oilLinkEo);
        });
        return false;
    }

    public void after(TaskMsg taskMsg) {
        log.info("\u6cb9\u4ef7\u722c\u866b\u722c\u53d6\u7ed3\u675f");
    }
}

