/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.share.biz.adapter;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IChannelWarehouseApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ChannelWarehouseAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ChannelWarehouseQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ChannelWarehouseUpdateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.WarehouseRelationReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ChannelWarehousePageRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ChannelWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.WarehouseRelationRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.service.IChannelWarehouseService;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.share.domain.entity.IChannelWarehouseDomain;
import com.yunxi.dg.base.center.share.eo.ChannelWarehouseEo;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class ChannelWarehouseApiImpl
implements IChannelWarehouseApi {
    private static final Logger log = LoggerFactory.getLogger(ChannelWarehouseApiImpl.class);
    @Autowired
    IChannelWarehouseService channelWarehouseService;
    @Autowired
    IChannelWarehouseDomain channelWarehouseDomain;

    public RestResponse<Long> add(ChannelWarehouseAddReqDto addReqDto) {
        return new RestResponse((Object)this.channelWarehouseService.add(addReqDto));
    }

    public RestResponse<Void> update(Long id, ChannelWarehouseUpdateReqDto updateReqDto) {
        return RestResponse.VOID;
    }

    public RestResponse<Void> updateByWarehouseCode(String warehouseCode, ChannelWarehouseUpdateReqDto updateReqDto) {
        this.channelWarehouseService.updateByWarehouseCode(warehouseCode, updateReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> delete(Long id) {
        this.channelWarehouseService.delete(id);
        return RestResponse.VOID;
    }

    public RestResponse<Void> rebuildShareInventory(String warehouseCode) {
        this.channelWarehouseService.rebuildShareInventory(warehouseCode);
        return RestResponse.VOID;
    }

    public RestResponse<ChannelWarehouseRespDto> queryByPrimaryKey(Long id) {
        return new RestResponse((Object)this.channelWarehouseService.selectByPrimaryKey(id));
    }

    public RestResponse<ChannelWarehouseRespDto> queryByChannelCode(String channelCode) {
        return new RestResponse((Object)this.channelWarehouseService.queryByChannelCode(channelCode));
    }

    public RestResponse<ChannelWarehouseRespDto> queryByWarehouseCode(String warehouseCode) {
        return new RestResponse((Object)this.channelWarehouseService.queryByWarehouseCode(warehouseCode));
    }

    public RestResponse<Boolean> checkWarehouseCode(String warehouseCode) {
        ChannelWarehouseEo eo = new ChannelWarehouseEo();
        eo.setWarehouseCode(warehouseCode);
        List result = this.channelWarehouseDomain.selectList((BaseEo)eo);
        return CollectionUtils.isNotEmpty((Collection)result) ? new RestResponse((Object)false) : new RestResponse((Object)true);
    }

    public RestResponse<Boolean> checkChannelWarehouseOverall(Long groupId) {
        return new RestResponse((Object)this.channelWarehouseService.checkChannelWarehouseOverall(groupId));
    }

    public RestResponse<PageInfo<ChannelWarehousePageRespDto>> queryByPage(ChannelWarehouseQueryDto queryDto) {
        return new RestResponse(this.channelWarehouseService.queryByPage(queryDto));
    }

    public RestResponse<List<ChannelWarehouseRespDto>> queryByCodes(Set<String> channelWarehouseCodes) {
        return new RestResponse(this.channelWarehouseService.queryByCodes(channelWarehouseCodes));
    }

    public RestResponse<Map<String, List<ChannelWarehouseRespDto>>> queryByLogicWarehouseCodes(Set<String> logicWarehouseCodes) {
        return new RestResponse(this.channelWarehouseService.queryByLogicWarehouseCodes(logicWarehouseCodes));
    }

    public RestResponse<PageInfo<WarehouseRelationRespDto>> queryWarehouseRelation(WarehouseRelationReqDto queryDto) {
        return new RestResponse(this.channelWarehouseService.queryWarehouseRelation(queryDto));
    }
}

