/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.share.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsLogicInventoryTotalRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.VirtualInventoryRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.service.IVirtualInventoryService;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.domain.CsInventoryLogRespDto;
import com.yunxi.dg.base.center.share.domain.entity.IVirtualInventoryDomain;
import com.yunxi.dg.base.center.share.dto.InventoryQueryReqDto;
import com.yunxi.dg.base.center.share.dto.InventorySummaryRespDto;
import com.yunxi.dg.base.center.share.eo.VirtualInventoryEo;
import com.yunxi.dg.base.center.share.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bizVirtualInventoryService")
public class VirtualInventoryServiceImpl
implements IVirtualInventoryService {
    private static final Logger log = LoggerFactory.getLogger(VirtualInventoryServiceImpl.class);
    @Autowired
    IVirtualInventoryDomain virtualInventoryDomain;
    @Autowired
    ICalcInventoryService calcInventoryService;

    @Override
    public VirtualInventoryRespDto queryById(Long id) {
        VirtualInventoryEo virtualInventoryEo = (VirtualInventoryEo)this.virtualInventoryDomain.selectByPrimaryKey(id);
        VirtualInventoryRespDto virtualInventoryRespDto = new VirtualInventoryRespDto();
        DtoHelper.eo2Dto((BaseEo)virtualInventoryEo, (BaseVo)virtualInventoryRespDto);
        return virtualInventoryRespDto;
    }

    @Override
    public VirtualInventoryRespDto queryByCargoCode(String cargoCode, String warehouseCode) {
        AssertUtils.notNull((Object)cargoCode, (String)"\u8d27\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)warehouseCode, (String)"\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List virtualInventoryEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.virtualInventoryDomain.filter().eq((Object)"sku_code", (Object)cargoCode)).eq((Object)"warehouse_code", (Object)warehouseCode)).list();
        VirtualInventoryRespDto virtualInventoryRespDto = new VirtualInventoryRespDto();
        if (CollectionUtils.isEmpty((Collection)virtualInventoryEos)) {
            return null;
        }
        VirtualInventoryEo virtualInventoryEo = (VirtualInventoryEo)virtualInventoryEos.get(0);
        BeanUtils.copyProperties((Object)virtualInventoryEo, (Object)virtualInventoryRespDto);
        virtualInventoryRespDto.setLongCode(virtualInventoryEo.getSkuCode());
        virtualInventoryRespDto.setCargoCode(virtualInventoryEo.getSkuCode());
        virtualInventoryRespDto.setCargoName(virtualInventoryEo.getSkuName());
        return virtualInventoryRespDto;
    }

    @Override
    public List<VirtualInventoryRespDto> queryByCargoCodes(List<String> cargoCodes, String warehouseCode) {
        List virtualInventoryEos;
        log.info("\u67e5\u8be2\u865a\u4ed3\u5165\u53c2cargoCodes\uff1a{}\uff0cwarehouseCode\uff1a{}", cargoCodes, (Object)warehouseCode);
        ExtQueryChainWrapper filter = this.virtualInventoryDomain.filter();
        if (CollectionUtils.isNotEmpty(cargoCodes)) {
            filter.in((Object)"sku_code", cargoCodes);
        }
        if (StringUtils.isNotEmpty((CharSequence)warehouseCode)) {
            filter.eq((Object)"warehouse_code", (Object)warehouseCode);
        }
        if (CollectionUtils.isEmpty((Collection)(virtualInventoryEos = filter.list()))) {
            return Lists.newArrayList();
        }
        log.info("\u67e5\u8be2\u865a\u4ed3\u5e93\u5b58\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)virtualInventoryEos));
        ArrayList<VirtualInventoryRespDto> virtualInventoryRespDtos = new ArrayList<VirtualInventoryRespDto>();
        for (VirtualInventoryEo virtualInventoryEo : virtualInventoryEos) {
            VirtualInventoryRespDto respDto = new VirtualInventoryRespDto();
            BeanUtils.copyProperties((Object)virtualInventoryEo, (Object)respDto);
            respDto.setLongCode(virtualInventoryEo.getSkuCode());
            respDto.setCargoCode(virtualInventoryEo.getSkuCode());
            respDto.setCargoName(virtualInventoryEo.getSkuName());
            virtualInventoryRespDtos.add(respDto);
        }
        return virtualInventoryRespDtos;
    }

    @Override
    public PageInfo<VirtualInventoryRespDto> queryByPage(InventoryQueryReqDto queryReqDto) {
        ExtQueryChainWrapper filter = (ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.virtualInventoryDomain.filter().eq(StringUtils.isNotEmpty((CharSequence)queryReqDto.getWarehouseCodeEq()), (Object)"warehouse_code", (Object)queryReqDto.getWarehouseCodeEq())).like(StringUtils.isNotEmpty((CharSequence)queryReqDto.getCargoCode()), (Object)"sku_code", (Object)queryReqDto.getCargoCode())).like(StringUtils.isNotEmpty((CharSequence)queryReqDto.getCargoName()), (Object)"sku_name", (Object)queryReqDto.getCargoName())).like(StringUtils.isNotEmpty((CharSequence)queryReqDto.getWarehouseCode()), (Object)"warehouse_code", (Object)queryReqDto.getWarehouseCode())).like(StringUtils.isNotEmpty((CharSequence)queryReqDto.getWarehouseName()), (Object)"warehouse_name", (Object)queryReqDto.getWarehouseName())).in(CollectionUtils.isNotEmpty((Collection)queryReqDto.getCargoCodes()), (Object)"sku_code", (Collection)queryReqDto.getCargoCodes())).in(CollectionUtils.isNotEmpty((Collection)queryReqDto.getWarehouseCodes()), (Object)"warehouse_code", (Collection)queryReqDto.getWarehouseCodes());
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getIsExceedZero()) && queryReqDto.getIsExceedZero().equals("1")) {
            filter.gt((Object)"balance", (Object)0);
        }
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getSearchDimension())) {
            AssertUtils.isTrue((queryReqDto.getMinQuantity() != null || queryReqDto.getMaxQuantity() != null ? 1 : 0) != 0, (String)"\u533a\u95f4\u6570\u636e\u9519\u8bef");
            if (queryReqDto.getMinQuantity() != null) {
                filter.ge((Object)queryReqDto.getSearchDimension(), (Object)queryReqDto.getMinQuantity());
            }
            if (queryReqDto.getMaxQuantity() != null) {
                filter.le((Object)queryReqDto.getSearchDimension(), (Object)queryReqDto.getMaxQuantity());
            }
        }
        PageInfo eoPageInfo = filter.page(queryReqDto.getPageNum(), queryReqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List eoList = eoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)eoList)) {
            return dtoPageInfo;
        }
        ArrayList<VirtualInventoryRespDto> dtoList = new ArrayList<VirtualInventoryRespDto>();
        for (VirtualInventoryEo virtualInventoryEo : eoList) {
            VirtualInventoryRespDto dto = new VirtualInventoryRespDto();
            BeanUtils.copyProperties((Object)virtualInventoryEo, (Object)dto);
            dto.setCargoCode(virtualInventoryEo.getSkuCode());
            dto.setCargoName(virtualInventoryEo.getSkuName());
            dto.setLongCode(virtualInventoryEo.getSkuCode());
            dtoList.add(dto);
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<VirtualInventoryRespDto> queryByList(InventoryQueryReqDto queryReqDto) {
        ExtQueryChainWrapper<VirtualInventoryEo> filter = this.getVirtualInventoryEoExtQueryChainWrapper(queryReqDto);
        List list = filter.list();
        ArrayList<VirtualInventoryRespDto> dtoList = new ArrayList<VirtualInventoryRespDto>();
        for (VirtualInventoryEo virtualInventoryEo : list) {
            VirtualInventoryRespDto respDto = new VirtualInventoryRespDto();
            BeanUtils.copyProperties((Object)virtualInventoryEo, (Object)respDto);
            respDto.setLongCode(virtualInventoryEo.getSkuCode());
            respDto.setCargoCode(virtualInventoryEo.getSkuCode());
            respDto.setCargoName(virtualInventoryEo.getSkuName());
            dtoList.add(respDto);
        }
        return dtoList;
    }

    private ExtQueryChainWrapper<VirtualInventoryEo> getVirtualInventoryEoExtQueryChainWrapper(InventoryQueryReqDto queryReqDto) {
        ExtQueryChainWrapper filter = this.virtualInventoryDomain.filter();
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getCargoCode())) {
            filter.like((Object)"sku_code", (Object)queryReqDto.getCargoCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getCargoName())) {
            filter.like((Object)"sku_name", (Object)queryReqDto.getCargoName());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getWarehouseCode())) {
            filter.like((Object)"warehouse_code", (Object)queryReqDto.getWarehouseCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getWarehouseName())) {
            filter.like((Object)"warehouse_name", (Object)queryReqDto.getWarehouseName());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getSearchDimension())) {
            AssertUtils.isTrue((queryReqDto.getMinQuantity() != null || queryReqDto.getMaxQuantity() != null ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            if (queryReqDto.getMinQuantity() != null) {
                filter.ge((Object)queryReqDto.getSearchDimension(), (Object)queryReqDto.getMinQuantity());
            }
            if (queryReqDto.getMaxQuantity() != null) {
                filter.ge((Object)queryReqDto.getSearchDimension(), (Object)queryReqDto.getMaxQuantity());
            }
        }
        return filter;
    }

    @Override
    public InventorySummaryRespDto querySummary(InventoryQueryReqDto reqDto) {
        return this.virtualInventoryDomain.querySummary(reqDto);
    }

    @Override
    public void initByLogicInventory(List<CsLogicInventoryTotalRespDto> logicInventoryRespDtoList) {
        for (CsLogicInventoryTotalRespDto logicInventory : logicInventoryRespDtoList) {
            CsInventoryLogRespDto logInventory = new CsInventoryLogRespDto();
            BeanUtils.copyProperties((Object)logicInventory, (Object)logInventory);
            logInventory.setId(null);
            logInventory.setBeforeActivityAllocate(BigDecimal.ZERO);
            logInventory.setAfterActivityAllocate(logicInventory.getActivityAllocate());
            logInventory.setChangeActivityAllocate(logicInventory.getActivityAllocate());
            logInventory.setBeforeAllocate(BigDecimal.ZERO);
            logInventory.setAfterAllocate(logicInventory.getAllocate());
            logInventory.setChangeAllocate(logicInventory.getAllocate());
            logInventory.setBeforeAvailable(BigDecimal.ZERO);
            logInventory.setAfterAvailable(logicInventory.getAvailable());
            logInventory.setChangeAvailable(logicInventory.getAvailable());
            logInventory.setBeforeBalance(BigDecimal.ZERO);
            logInventory.setAfterBalance(logicInventory.getBalance());
            logInventory.setChangeBalance(logicInventory.getBalance());
            logInventory.setBeforePreempt(BigDecimal.ZERO);
            logInventory.setAfterPreempt(logicInventory.getPreempt());
            logInventory.setChangePreempt(logicInventory.getPreempt());
            logInventory.setBeforeIntransit(BigDecimal.ZERO);
            logInventory.setAfterIntransit(logicInventory.getIntransit());
            logInventory.setChangeIntransit(logicInventory.getIntransit());
            logInventory.setBeforeTransfer(BigDecimal.ZERO);
            logInventory.setAfterTransfer(logicInventory.getTransfer());
            logInventory.setChangeTransfer(logicInventory.getTransfer());
            logInventory.setBeforeLockInventory(BigDecimal.ZERO);
            logInventory.setAfterLockInventory(logicInventory.getLockInventory());
            logInventory.setChangeLockInventory(logicInventory.getLockInventory());
            this.calcInventoryService.supplyByLogicLogs((List)Lists.newArrayList((Object[])new CsInventoryLogRespDto[]{logInventory}));
        }
    }
}

