/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.share.biz.adapter;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IShareGoodsOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ShareGoodsAutoAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ShareGoodsOrderAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ShareGoodsOrderQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ShareGoodsOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ShareGoodsOrderCountRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ShareGoodsOrderRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.service.IShareGoodsOrderService;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.share.eo.ShareGoodsOrderEo;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class ShareGoodsOrderApiImpl
implements IShareGoodsOrderApi {
    private static final Logger log = LoggerFactory.getLogger(ShareGoodsOrderApiImpl.class);
    @Autowired
    IShareGoodsOrderService shareGoodsOrderService;

    public RestResponse<Long> generateShareGoodsOrder(ShareGoodsOrderReqDto addReqDto) {
        log.info("\u65b0\u589e\u5206\u8d27\u5355\u53c2\u6570\uff1a[{}]", (Object)JSON.toJSONString((Object)addReqDto));
        return new RestResponse((Object)this.shareGoodsOrderService.generateShareGoodsOrder(addReqDto));
    }

    public RestResponse<Void> editShareGoodsOrder(String orderNo, ShareGoodsOrderReqDto updateReqDto) {
        log.info("\u7f16\u8f91\u5206\u8d27\u5355\u53c2\u6570\uff1a[orderNo:{}, {}]", (Object)orderNo, (Object)JSON.toJSONString((Object)updateReqDto));
        AssertUtils.isTrue((StringUtils.isNotBlank((CharSequence)orderNo) && Objects.nonNull(updateReqDto) ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        this.shareGoodsOrderService.editShareGoodsOrder(orderNo, updateReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> cancelShareGoodsOrder(String orderNo) {
        log.info("\u5173\u95ed\u5206\u8d27\u5355\u53c2\u6570\uff1a[orderNo:{}]", (Object)orderNo);
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)orderNo), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        this.shareGoodsOrderService.cancelShareGoodsOrder(orderNo);
        return RestResponse.VOID;
    }

    public RestResponse<List<String>> batchAuditShareGoodsOrder(List<ShareGoodsOrderAuditReqDto> auditReqDtos) {
        log.info("\u6279\u91cf\u5ba1\u6838\u5206\u8d27\u5355\u53c2\u6570\uff1a[{}]", (Object)JSON.toJSONString(auditReqDtos));
        return new RestResponse(this.shareGoodsOrderService.batchAuditShareGoodsOrder(auditReqDtos));
    }

    public RestResponse<Void> createAndAuditShareGoodsOrder(ShareGoodsAutoAuditReqDto auditReqDtos) {
        log.info("\u81ea\u52a8\u521b\u5efa\u5e76\u5ba1\u6838\u63a5\u53e3\uff1a[{}]", (Object)JSON.toJSONString((Object)auditReqDtos));
        this.shareGoodsOrderService.createAndAuditShareGoodsOrder(auditReqDtos);
        return RestResponse.VOID;
    }

    public RestResponse<ShareGoodsOrderRespDto> queryByPrimaryKey(Long id) {
        log.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtils.isTrue((id != null && id > 0L ? 1 : 0) != 0, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        ShareGoodsOrderEo eo = this.shareGoodsOrderService.selectByPrimaryKey(id);
        AssertUtils.isTrue((eo != null ? 1 : 0) != 0, (String)"\u8bb0\u5f55\u4e0d\u5b58\u5728");
        ShareGoodsOrderRespDto dto = new ShareGoodsOrderRespDto();
        CubeBeanUtils.copyProperties((Object)dto, (Object)eo, (String[])new String[0]);
        return new RestResponse((Object)dto);
    }

    public RestResponse<PageInfo<ShareGoodsOrderRespDto>> queryByPage(ShareGoodsOrderQueryDto queryDto) {
        log.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)JSON.toJSONString((Object)queryDto));
        PageInfo<ShareGoodsOrderRespDto> page = this.shareGoodsOrderService.queryByPage(queryDto);
        return new RestResponse(page);
    }

    public RestResponse<ShareGoodsOrderCountRespDto> shareGoodsOrderCount(ShareGoodsOrderQueryDto queryDto) {
        return new RestResponse((Object)this.shareGoodsOrderService.shareGoodsOrderCount(queryDto));
    }

    public RestResponse<List<ShareGoodsOrderRespDto>> queryByParam(ShareGoodsOrderQueryDto queryDto) {
        log.info("\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)JSON.toJSONString((Object)queryDto));
        List<ShareGoodsOrderRespDto> list = this.shareGoodsOrderService.queryByParam(queryDto);
        return new RestResponse(list);
    }

    public RestResponse<ShareGoodsOrderRespDto> queryByOrderNo(String orderNo) {
        log.info("\u6839\u636e\u5206\u8d27\u5355\u53f7\u67e5\u8be2\u8be6\u60c5\uff1a[{}]", (Object)orderNo);
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)orderNo), (String)"\u5206\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        ShareGoodsOrderRespDto dto = this.shareGoodsOrderService.queryByOrderNo(orderNo);
        return new RestResponse((Object)dto);
    }
}

