/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.share.biz.generate;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsGenerateCodeStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.generate.IGenerateCodeService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractGenerateCodeService
implements IGenerateCodeService {
    private Logger logger = LoggerFactory.getLogger(AbstractGenerateCodeService.class);
    protected final Integer DEFAULT_AUTO_INCREASE_NUM = 1;
    protected final Long DEFAULT_MAX_LIMIT_NUM = 999999999L;
    protected final Integer DEFAULT_RANDOM_NUM = 0;
    protected final Integer DEFAULT_DIGIT_NUM = 6;
    protected final Integer DEFAULT_MAX_DIGIT_NUM = 12;
    private static final Integer LOCK_TIME_OUT = 30;
    public static final String DEFAULT_PREFIX = "Cs";
    @Autowired
    private ILockService lockService;
    @Autowired
    private ICacheService cacheService;

    @Override
    public String getGenerateCodeStrategy() {
        return CsGenerateCodeStrategyEnum.COMMON.getCode();
    }

    protected abstract String lockKey();

    @Override
    public String generateCode(String tableName, String lockKey) {
        return this.generateCode(tableName, lockKey, this.DEFAULT_DIGIT_NUM);
    }

    @Override
    public String generateCode(String tableName, String lockKey, Integer digitNum) {
        AssertUtils.isTrue((digitNum > 0 ? 1 : 0) != 0, (String)"\u7f16\u7801\u957f\u5ea6\u5fc5\u987b\u5927\u4e8e0");
        digitNum = digitNum > this.DEFAULT_MAX_DIGIT_NUM ? this.DEFAULT_MAX_DIGIT_NUM : digitNum;
        return this.getGenerateCode(tableName, lockKey, this.DEFAULT_AUTO_INCREASE_NUM, this.DEFAULT_MAX_LIMIT_NUM, digitNum);
    }

    private String getGenerateCode(String tableName, String lockKey, Integer autoIncreaseNum, Long maxLimitNum, Integer digitNum) {
        String string;
        block6: {
            this.logger.info("generateCode==>\u751f\u6210\u7f16\u7801,tableName:{},lockKey:{},autoIncreaseNum:{},maxLimitNum:{},digitNum:{}", new Object[]{tableName, lockKey, autoIncreaseNum, maxLimitNum, digitNum});
            Mutex mutex = null;
            try {
                mutex = this.lockService.lock(tableName, lockKey, LOCK_TIME_OUT.intValue(), LOCK_TIME_OUT.intValue(), TimeUnit.SECONDS);
                if (null == mutex) {
                    throw new BizException("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25");
                }
                string = this.doGenerateCode(tableName, lockKey, autoIncreaseNum, maxLimitNum, digitNum);
                if (null == mutex) break block6;
            }
            catch (Exception e) {
                try {
                    this.logger.info("\u751f\u6210\u5546\u54c1\u7f16\u7801\u5f02\u5e38\uff1a[tableName:{},lockKey:{}],eMessage:{},e:{}", new Object[]{tableName, lockKey, e.getMessage(), e});
                    throw e;
                }
                catch (Throwable throwable) {
                    if (null != mutex) {
                        this.lockService.unlock(mutex);
                    }
                    throw throwable;
                }
            }
            this.lockService.unlock(mutex);
        }
        return string;
    }

    private String getGenerateCodeKey(String tableName, String lokcKey) {
        return "generateCode:" + tableName + "_" + lokcKey;
    }

    private String doGenerateCode(String tableName, String lockKey, Integer autoIncreaseNum, Long maxLimitNum, Integer digitNum) {
        String generateCodeKey = this.getGenerateCodeKey(tableName, lockKey);
        this.logger.info("doGenerateCode==>\u5b9e\u9645\u6267\u884c\u751f\u6210\u7f16\u7801\u7684,generateCodeKey:{}", (Object)JSON.toJSONString((Object)generateCodeKey));
        Long maxCode = (Long)this.cacheService.getCache(generateCodeKey, Long.class);
        if (null == maxCode) {
            maxCode = this.queryMaxCode();
        }
        this.logger.info("\u67e5\u8be2\u6700\u5927\u7f16\u7801\uff1a[tableName:{},lockKey:{},maxCode:{}]", new Object[]{tableName, lockKey, maxCode});
        Long generateCode = maxCode + (long)autoIncreaseNum.intValue();
        AssertUtils.isTrue((generateCode < maxLimitNum ? 1 : 0) != 0, (String)"\u8d85\u51fa\u6700\u5927\u503c");
        this.cacheService.setPersistCache(generateCodeKey, (Object)generateCode);
        return this.doGenerateFinalCode(generateCode, digitNum);
    }

    protected abstract Long queryMaxCode();

    protected String getCodePrefix() {
        return DEFAULT_PREFIX;
    }

    protected String doGenerateFinalCode(Long generateCode, Integer digitNum) {
        String codePrefix = this.getCodePrefix();
        String dateStr = DateUtils.formatDate((Date)new Date(), (String)"yyyyMMdd");
        if (StringUtils.isBlank((CharSequence)codePrefix)) {
            return dateStr + String.format("%" + digitNum + "d", generateCode).replace(" ", "0");
        }
        return codePrefix + dateStr + String.format("%" + digitNum + "d", generateCode).replace(" ", "0");
    }

    @Override
    public String getCode() {
        return "";
    }
}

