/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.share.biz.mq;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.inventory.exception.CsInventoryException;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.mq.vo.DisplacePreemptVo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.share.domain.entity.IInventoryPreemptionDomain;
import com.yunxi.dg.base.center.share.dto.calc.DisplacePreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.base.OperationDto;
import com.yunxi.dg.base.commons.enums.EnableDisableEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.LogUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@MQDesc(topic="INVENTORY_SHARE_DISPLACE_PREEMPT_TOPIC", tag="DISPLACE_PREEMPT_ASYNC_PROCESS")
public class DisplacePreemptAsyncProcess
implements IMessageProcessor<DisplacePreemptDto> {
    private static final Logger logger = LoggerFactory.getLogger(DisplacePreemptAsyncProcess.class);
    protected static final String EXCEPTION_CODE = "09527";
    @Resource
    ICacheService cacheService;
    @Resource
    ICommonsMqService commonsMqService;
    @Autowired
    IInventoryPreemptionDomain inventoryPreemptionDomain;

    @Transactional(rollbackFor={Exception.class})
    public MessageResponse process(DisplacePreemptDto message) {
        logger.info("[\u63a5\u6536\u5230\u8425\u517b\u5bb6\u7f6e\u6362\u8ba2\u5355MQ\u8bf7\u6c42]\u6d88\u606f\uff1a{}", (Object)message.getDisplaceSourceNo());
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", requestId);
        try {
            String group = "DISPLACE_PREEMPT_ASYNC" + message.getDisplaceSourceNo();
            String setStr = (String)this.cacheService.getCache("DISPLACE_PREEMPT_ASYNC", message.getDisplaceSourceNo(), String.class);
            AssertUtils.notBlank((String)setStr, (String)"\u83b7\u53d6\u4e0d\u5230\u7236\u5355\u5bf9\u7528\u7684\u5b50\u5355\u6570\u636e");
            Set subOrderNo = (Set)JSON.parseObject((String)setStr, Set.class);
            logger.info("warehouse able displacePreempt ==> subOrderNo:{}", (Object)LogUtils.buildLogContent((Collection)subOrderNo));
            AssertUtils.notEmpty((Collection)subOrderNo, (String)"\u83b7\u53d6\u5b50\u5355\u5355\u53f7\u4e3a\u7a7a");
            Map preemptParams = this.cacheService.hmget(group, message.getDisplaceSourceNo(), subOrderNo.toArray(new String[subOrderNo.size()]), PreemptDto.class);
            AssertUtils.notEmpty((Object)preemptParams, (String)"\u83b7\u53d6\u5b50\u5355\u6570\u636e\u4e3a\u7a7a");
            logger.info("warehouse able displacePreempt ==> preemptParams:{}", (Object)LogUtils.buildLogContent((Object)preemptParams));
            AssertUtils.isTrue((boolean)preemptParams.values().stream().allMatch(a -> StringUtils.isNotEmpty((CharSequence)a.getSourceNo())), (String)"\u5b50\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            this.checkExistPreempt(subOrderNo);
            preemptParams.entrySet().forEach(entry -> this.checkDetails((OperationDto)entry.getValue()));
            List shPreemptParams = Lists.partition((List)Lists.newArrayList(preemptParams.values()), (int)200);
            logger.info("warehouse able displacePreempt ==> shPreemptParams:{}", (Object)LogUtils.buildLogContent((Collection)shPreemptParams));
            int i = 0;
            for (List shPreemptParam : shPreemptParams) {
                ArrayList displacePreemptVos = new ArrayList();
                shPreemptParam.stream().forEach(a -> {
                    DisplacePreemptVo displacePreemptVo = new DisplacePreemptVo();
                    displacePreemptVo.setDisplaceSourceNo(a.getDisplacePreemptParam().getDisplaceSourceNo());
                    displacePreemptVo.setSourceType(a.getDisplacePreemptParam().getSourceType());
                    displacePreemptVo.setSourceNo(a.getSourceNo());
                    displacePreemptVos.add(displacePreemptVo);
                });
                this.commonsMqService.publishDelayMessageAsync("INVENTORY_SHARE_DISPLACE_PREEMPT_TOPIC", "DISPLACE_PREEMPT_ASYNC", displacePreemptVos, Long.valueOf(++i * 2));
            }
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return MessageResponse.ERROR;
        }
    }

    private void checkExistPreempt(Collection<String> sourceNos) {
        int preemptionEoCount = this.inventoryPreemptionDomain.getMapper().selectCount((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"source_no", sourceNos)).eq((Object)"valid", (Object)EnableDisableEnum.ENABLE.getCode())).eq((Object)"dr", (Object)YesNoHelper.NO));
        if (preemptionEoCount > 0) {
            throw new CsInventoryException(EXCEPTION_CODE, "\u8be5\u5355\u636e[%s]\u5df2\u5b58\u5728\u6709\u6548\u9884\u5360\u8bb0\u5f55", new Object[]{sourceNos.toString()});
        }
    }

    private void checkDetails(OperationDto shOperationParam) {
        List details = shOperationParam.getDetails();
        AssertUtils.notEmpty((Collection)details, (String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        if (!shOperationParam.getZeroError().booleanValue()) {
            details.removeIf(o -> BigDecimalUtils.eqZero((BigDecimal)o.getNum()));
        }
        details.forEach(d -> {
            AssertUtils.notBlank((String)d.getSkuCode(), (String)"\u660e\u7ec6\u8d27\u54c1Code\u5b58\u5728\u7a7a\u503c");
            AssertUtils.notBlank((String)d.getWarehouseCode(), (String)"\u660e\u7ec6\u4ed3\u5e93Code\u5b58\u5728\u7a7a\u503c");
            if (BigDecimalUtils.eqZero((BigDecimal)d.getNum()).booleanValue()) {
                throw new BizException(String.format("warehouseCode: %s, cargoCode: %s, \u4ed3\u5e93\u53d8\u5316\u91cf\u4e0d\u5b58\u5728\u6216\u8005\u4e3a0", d.getWarehouseCode(), d.getSkuCode()));
            }
        });
    }
}

