/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.share.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.CsInventoryOperateCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.mq.vo.DisplacePreemptVo;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.service.IChannelInventoryExposedService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.share.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.base.OperationDetailDto;
import com.yunxi.dg.base.center.share.exception.WarehouseAbleException;
import com.yunxi.dg.base.center.share.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.center.share.service.transcation.TransactionCallBackService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bizChannelInventoryExposedService")
public class ChannelInventoryExposedServiceImpl
implements IChannelInventoryExposedService {
    private static final Logger log = LoggerFactory.getLogger(ChannelInventoryExposedServiceImpl.class);
    @Autowired
    ICalcInventoryService calcInventoryService;
    @Autowired
    ICacheService cacheService;
    @Autowired
    ICommonsMqService commonsMqService;
    @Autowired
    TransactionCallBackService transactionCallBackService;
    @Autowired
    @Qualifier(value="bizChannelInventoryExposedService")
    IChannelInventoryExposedService self;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchInventoryByPreemption(List<CsInventoryOperateReqDto> inventoryOperateReqDtos) {
        AssertUtils.notEmpty(inventoryOperateReqDtos, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList preemptParamList = Lists.newArrayList();
        inventoryOperateReqDtos.forEach(inventoryOperateReqDto -> {
            PreemptDto preemptParam = new PreemptDto();
            preemptParam.setSourceNo(inventoryOperateReqDto.getSourceNo());
            preemptParam.setSourceType(inventoryOperateReqDto.getSourceType());
            preemptParam.setExternalOrderNo(inventoryOperateReqDto.getPlatformOrderNo());
            preemptParam.setRemark("");
            ArrayList details = Lists.newArrayList();
            for (CsInventoryOperateCargoReqDto operateCargoReqDto : inventoryOperateReqDto.getOperateCargoReqDtoList()) {
                OperationDetailDto detail = new OperationDetailDto();
                detail.setSkuCode(operateCargoReqDto.getSkuCode());
                detail.setWarehouseCode(operateCargoReqDto.getWarehouseCode());
                detail.setNum(operateCargoReqDto.getChangeInventory());
                details.add(detail);
            }
            preemptParam.setDetails((List)details);
            preemptParamList.add(preemptParam);
        });
        this.calcInventoryService.updatePreempt((List)Lists.newArrayList(), (List)preemptParamList);
    }

    @Override
    @Retryable(value={WarehouseAbleException.class}, maxAttempts=10, backoff=@Backoff(random=true, delay=500L, maxDelay=6000L, multiplier=1.2))
    public void doDisplacePreemptProcess(List<DisplacePreemptVo> message) {
        this.self.displacePreemptProcess(message);
        String parentNo = message.get(0).getDisplaceSourceNo();
        String parentSourceType = message.get(0).getSourceType();
        String group = "DISPLACE_PREEMPT_ASYNC" + parentNo;
        String setStr = (String)this.cacheService.getCache("DISPLACE_PREEMPT_ASYNC", parentNo, String.class);
        if (StringUtils.isEmpty((CharSequence)setStr)) {
            log.info("[\u63a5\u6536\u5230\u8425\u517b\u5bb6\u7f6e\u6362\u8ba2\u5355MQ\u8bf7\u6c42]\u6d88\u606f\uff1a\u7236\u5355\u5df2\u91ca\u653e");
            return;
        }
        List<String> subOrderNo = JSON.parseArray((String)setStr, String.class);
        if (CollectionUtils.isEmpty((Collection)subOrderNo)) {
            log.info("[\u63a5\u6536\u5230\u8425\u517b\u5bb6\u7f6e\u6362\u8ba2\u5355MQ\u8bf7\u6c42]\u6d88\u606f\uff1a\u83b7\u53d6\u5b50\u5355\u5355\u53f7\u4e3a\u7a7a");
            return;
        }
        subOrderNo = subOrderNo.stream().distinct().collect(Collectors.toList());
        Map preemptParams = this.cacheService.hmget(group, parentNo, subOrderNo.toArray(new String[0]), PreemptDto.class);
        List shPreemptParams = preemptParams.values().stream().filter(ObjectUtils::isNotEmpty).collect(Collectors.toList());
        log.info("\u6821\u9a8c\u5b50\u5355\u7f13\u5b58\u662f\u5426\u4e3a\u7a7a\uff1a{}", (Object)JSON.toJSONString(shPreemptParams));
        if (ObjectUtils.isEmpty(shPreemptParams) && StringUtils.isNotEmpty((CharSequence)parentNo)) {
            ReleasePreemptDto shReleasePreemptParam = new ReleasePreemptDto();
            shReleasePreemptParam.setSourceNo(parentNo);
            shReleasePreemptParam.setSourceType(parentSourceType);
            this.calcInventoryService.releasePreempt(shReleasePreemptParam);
            HashSet subOrderNoSet = Sets.newHashSet(subOrderNo);
            this.commonsMqService.publishMessageAsync("SINGLE_TOPIC", "DISPLACE_PREEMPT_COMPLITE", (Object)subOrderNoSet);
            log.info("\u8ba2\u5355\u6d88\u606f\u53d1\u9001\u6210\u529f\uff1a{}", (Object)parentNo);
            this.cacheService.delCache("DISPLACE_PREEMPT_ASYNC", parentNo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void displacePreemptProcess(List<DisplacePreemptVo> message) {
        List<String> keys;
        String parentNo = message.get(0).getDisplaceSourceNo();
        String group = "DISPLACE_PREEMPT_ASYNC" + parentNo;
        Map preemptParam = this.cacheService.hmget(group, parentNo, (keys = message.stream().map(DisplacePreemptVo::getSourceNo).collect(Collectors.toList())).toArray(new String[message.size()]), PreemptDto.class);
        List preemptParamList = preemptParam.values().stream().filter(ObjectUtils::isNotEmpty).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(preemptParamList)) {
            log.info("\u83b7\u53d6\u5230\u7684\u8ba2\u5355\u7f13\u5b58\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)preemptParam));
            this.calcInventoryService.updatePreempt((List)Lists.newArrayList(), preemptParamList);
            this.transactionCallBackService.execute(() -> {
                log.info("\u5b50\u5355\u9884\u5360\u6210\u529f\uff0c\u5220\u9664\u5b50\u5355\u7f13\u5b58 keys: {}", (Object)keys);
                this.cacheService.hdel(group, parentNo, keys.toArray(new String[0]));
            });
        }
    }
}

