/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.share.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.InventorySharedReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.InventorySharedRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.InventorySharedWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.service.IInventorySharedService;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.share.domain.entity.IInventorySharedDomain;
import com.yunxi.dg.base.center.share.domain.entity.IInventorySharedWarehouseDomain;
import com.yunxi.dg.base.center.share.eo.InventorySharedEo;
import com.yunxi.dg.base.center.share.eo.InventorySharedWarehouseEo;
import com.yunxi.dg.base.commons.enums.EnableDisableEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bizInventorySharedService")
public class InventorySharedServiceImpl
implements IInventorySharedService {
    private static final Logger log = LoggerFactory.getLogger(InventorySharedServiceImpl.class);
    @Resource
    IInventorySharedDomain inventorySharedDomain;
    @Resource
    IContext context;
    @Autowired
    IInventorySharedWarehouseDomain inventorySharedWarehouseDomain;

    @Override
    public Long addInventoryShared(InventorySharedReqDto addReqDto) {
        InventorySharedEo inventorySharedEo = new InventorySharedEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)inventorySharedEo);
        inventorySharedEo.setCreatePerson(null == this.context.userName() ? "-1" : this.context.userName());
        inventorySharedEo.setTenantId(Long.valueOf(null == this.context.tenantId() ? -1L : this.context.tenantId()));
        inventorySharedEo.setInstanceId(Long.valueOf(null == this.context.instanceId() ? -1L : this.context.instanceId()));
        inventorySharedEo.setCreateTime(new Date());
        this.inventorySharedDomain.insert((BaseEo)inventorySharedEo);
        return inventorySharedEo.getId();
    }

    @Override
    public void modifyInventoryShared(InventorySharedReqDto modifyReqDto) {
        InventorySharedEo inventorySharedEo = new InventorySharedEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)inventorySharedEo);
        inventorySharedEo.setUpdatePerson(null == this.context.userName() ? "-1" : this.context.userName());
        inventorySharedEo.setUpdateTime(new Date());
        this.inventorySharedDomain.updateSelective((BaseEo)inventorySharedEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeInventoryShared(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.inventorySharedDomain.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public InventorySharedRespDto queryById(Long id) {
        InventorySharedEo inventorySharedEo = (InventorySharedEo)this.inventorySharedDomain.selectByPrimaryKey(id);
        InventorySharedRespDto inventorySharedRespDto = new InventorySharedRespDto();
        DtoHelper.eo2Dto((BaseEo)inventorySharedEo, (BaseVo)inventorySharedRespDto);
        return inventorySharedRespDto;
    }

    @Override
    public PageInfo<InventorySharedRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        InventorySharedReqDto inventorySharedReqDto = (InventorySharedReqDto)JSON.parseObject((String)filter, InventorySharedReqDto.class);
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)inventorySharedReqDto.getWarehouseName())) {
            List inventorySharedWarehouseEos = this.inventorySharedWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventorySharedWarehouseEo.class).like(InventorySharedWarehouseEo::getWarehouseName, (Object)inventorySharedReqDto.getWarehouseName())).eq(InventorySharedWarehouseEo::getStatus, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
            if (CollectionUtils.isEmpty((Collection)inventorySharedWarehouseEos)) {
                return new PageInfo();
            }
            List shareCodes = inventorySharedWarehouseEos.stream().map(InventorySharedWarehouseEo::getSharedCode).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(shareCodes)) {
                return new PageInfo();
            }
            inventorySharedReqDto.setSharedCodeList(shareCodes);
        }
        if (CollectionUtils.isNotEmpty((Collection)inventorySharedReqDto.getSharedCodeList())) {
            wrapper.in((Object)"shared_code", (Collection)inventorySharedReqDto.getSharedCodeList());
        }
        if (StringUtils.isNotBlank((CharSequence)inventorySharedReqDto.getSharedCode())) {
            wrapper.like((Object)"shared_code", (Object)inventorySharedReqDto.getSharedCode());
        }
        if (StringUtils.isNotBlank((CharSequence)inventorySharedReqDto.getSharedName())) {
            wrapper.like((Object)"shared_name", (Object)inventorySharedReqDto.getSharedName());
        }
        if (StringUtils.isNotBlank((CharSequence)inventorySharedReqDto.getVirtualWarehouseCode())) {
            wrapper.eq((Object)"virtual_warehouse_code", (Object)inventorySharedReqDto.getVirtualWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)inventorySharedReqDto.getVirtualWarehouseName())) {
            wrapper.like((Object)"virtual_warehouse_name", (Object)inventorySharedReqDto.getVirtualWarehouseName());
        }
        if (StringUtils.isNotBlank((CharSequence)inventorySharedReqDto.getSharedStatus())) {
            wrapper.eq((Object)"shared_status", (Object)inventorySharedReqDto.getSharedStatus());
        }
        wrapper.eq((Object)"dr", (Object)YesNoHelper.NO);
        wrapper.orderByDesc((Object)"create_time");
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List eoList = this.inventorySharedDomain.getMapper().selectList((Wrapper)wrapper);
        PageInfo eoPageInfo = new PageInfo(eoList);
        PageInfo dtoPageInfo = new PageInfo();
        BeanUtils.copyProperties((Object)eoPageInfo, (Object)dtoPageInfo, (String[])new String[]{"list"});
        if (CollectionUtils.isEmpty((Collection)eoList)) {
            return dtoPageInfo;
        }
        List shareCodes = eoList.stream().map(InventorySharedEo::getSharedCode).distinct().collect(Collectors.toList());
        List inventorySharedWarehouseEos = this.inventorySharedWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InventorySharedWarehouseEo.class).in(InventorySharedWarehouseEo::getSharedCode, shareCodes)).eq(InventorySharedWarehouseEo::getStatus, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        ArrayList<InventorySharedRespDto> dtoList = new ArrayList<InventorySharedRespDto>();
        for (InventorySharedEo eo : eoList) {
            InventorySharedRespDto dto = new InventorySharedRespDto();
            BeanUtils.copyProperties((Object)eo, (Object)dto);
            List filterInventorySharedWarehouseEos = inventorySharedWarehouseEos.stream().filter(o -> StringUtils.equals((CharSequence)o.getSharedCode(), (CharSequence)eo.getSharedCode())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(filterInventorySharedWarehouseEos)) {
                ArrayList inventorySharedWarehouseRespDtoList = Lists.newArrayList();
                for (InventorySharedWarehouseEo inventorySharedWarehouseEo : filterInventorySharedWarehouseEos) {
                    InventorySharedWarehouseRespDto inventorySharedWarehouseRespDto = new InventorySharedWarehouseRespDto();
                    BeanUtils.copyProperties((Object)inventorySharedWarehouseEo, (Object)inventorySharedWarehouseRespDto);
                    inventorySharedWarehouseRespDtoList.add(inventorySharedWarehouseRespDto);
                }
                dto.setWarehouseList((List)inventorySharedWarehouseRespDtoList);
            }
            dtoList.add(dto);
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void modifyInventorySharedStatus(String ids, String type) {
        String[] updateIds = ids.split(",");
        String status = "disable";
        if (type.equals(EnableDisableEnum.ENABLE.getCode())) {
            status = "enable";
        }
        for (String id : updateIds) {
            InventorySharedReqDto modifyReqDto = new InventorySharedReqDto();
            modifyReqDto.setId(Long.valueOf(id));
            modifyReqDto.setSharedStatus(status);
            this.modifyInventoryShared(modifyReqDto);
        }
    }

    @Override
    public List<InventorySharedRespDto> queryByIds(String ids) {
        List eoList = ((ExtQueryChainWrapper)this.inventorySharedDomain.filter().in((Object)"id", new Object[]{ids})).list();
        ArrayList<InventorySharedRespDto> dtoList = new ArrayList<InventorySharedRespDto>();
        DtoHelper.eoList2DtoList((Collection)eoList, dtoList, InventorySharedRespDto.class);
        return dtoList;
    }
}

