/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.share.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.RelWarehouseChannelAddListReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.RelWarehouseChannelAddReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.RelWarehouseChannelReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.RelWarehouseChannelRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.biz.service.IRelWarehouseChannelService;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.share.domain.entity.IRelWarehouseChannelDomain;
import com.yunxi.dg.base.center.share.eo.RelWarehouseChannelEo;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import liquibase.util.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="bizRelWarehouseChannelService")
public class RelWarehouseChannelServiceImpl
implements IRelWarehouseChannelService {
    private static final Logger log = LoggerFactory.getLogger(RelWarehouseChannelServiceImpl.class);
    @Resource
    IRelWarehouseChannelDomain relWarehouseChannelDomain;

    @Override
    public Long addRelWarehouseChannel(RelWarehouseChannelAddReqDto addReqDto) {
        RelWarehouseChannelEo relWarehouseChannelEo = new RelWarehouseChannelEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)relWarehouseChannelEo);
        this.relWarehouseChannelDomain.insert((BaseEo)relWarehouseChannelEo);
        return relWarehouseChannelEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addRelWarehouseChannelList(RelWarehouseChannelAddListReqDto addListReqDto) {
        AssertUtils.notNull((Object)addListReqDto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)addListReqDto.getChannelWarehouseId(), (String)"\u6e20\u9053\u4ed3id\u4e0d\u4e3a\u80fd\u7a7a");
        if (CollectionUtils.isEmpty((Collection)addListReqDto.getAddReqDtoList())) {
            return;
        }
        AssertUtils.isTrue((boolean)addListReqDto.getAddReqDtoList().stream().allMatch(a -> StringUtils.isNotEmpty((String)a.getChannelCode())), (String)"\u6ca1\u6709\u6709\u6548\u6e20\u9053\u4ed3\u7f16\u7801");
        List channelCodes = addListReqDto.getAddReqDtoList().stream().map(RelWarehouseChannelAddReqDto::getChannelCode).collect(Collectors.toList());
        Set hasChanelCode = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.relWarehouseChannelDomain.filter().select(new String[]{"channel_code"}).eq((Object)"warehouse_id", (Object)addListReqDto.getChannelWarehouseId())).in((Object)"channel_code", channelCodes)).list().stream().map(RelWarehouseChannelEo::getChannelCode).collect(Collectors.toSet());
        addListReqDto.setAddReqDtoList(addListReqDto.getAddReqDtoList().stream().filter(h -> !hasChanelCode.contains(h.getChannelCode())).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty((Collection)addListReqDto.getAddReqDtoList())) {
            return;
        }
        ArrayList relWarehouseChannelEos = new ArrayList();
        DtoHelper.dtoList2EoList((Collection)addListReqDto.getAddReqDtoList(), relWarehouseChannelEos, RelWarehouseChannelEo.class);
        this.relWarehouseChannelDomain.insertBatch(relWarehouseChannelEos);
    }

    @Override
    public void modifyRelWarehouseChannel(RelWarehouseChannelReqDto modifyReqDto) {
        RelWarehouseChannelEo relWarehouseChannelEo = new RelWarehouseChannelEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)relWarehouseChannelEo);
        this.relWarehouseChannelDomain.updateSelective((BaseEo)relWarehouseChannelEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeRelWarehouseChannel(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.relWarehouseChannelDomain.deleteById(Long.valueOf(id));
        }
    }

    @Override
    public RelWarehouseChannelRespDto queryById(Long id) {
        RelWarehouseChannelEo relWarehouseChannelEo = (RelWarehouseChannelEo)this.relWarehouseChannelDomain.selectByPrimaryKey(id);
        RelWarehouseChannelRespDto relWarehouseChannelRespDto = new RelWarehouseChannelRespDto();
        DtoHelper.eo2Dto((BaseEo)relWarehouseChannelEo, (BaseVo)relWarehouseChannelRespDto);
        return relWarehouseChannelRespDto;
    }

    @Override
    public List<RelWarehouseChannelRespDto> queryByList(Long channelWarehouseId) {
        AssertUtils.notNull((Object)channelWarehouseId, (String)"id \u9519\u8bef");
        List relWarehouseChannelEos = ((ExtQueryChainWrapper)this.relWarehouseChannelDomain.filter().in((Object)"warehouse_id", new Object[]{channelWarehouseId})).list();
        ArrayList<RelWarehouseChannelRespDto> relWarehouseChannelRespDtos = new ArrayList<RelWarehouseChannelRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)relWarehouseChannelEos)) {
            relWarehouseChannelEos.forEach(relWarehouseChannelEo -> {
                RelWarehouseChannelRespDto relWarehouseChannelRespDto = new RelWarehouseChannelRespDto();
                CubeBeanUtils.copyProperties((Object)relWarehouseChannelRespDto, (Object)relWarehouseChannelEo, (String[])new String[0]);
                relWarehouseChannelRespDtos.add(relWarehouseChannelRespDto);
            });
        }
        log.info("\u6e20\u9053\u67e5\u8be2\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString(relWarehouseChannelRespDtos));
        return relWarehouseChannelRespDtos;
    }

    @Override
    public PageInfo<RelWarehouseChannelRespDto> queryByPage(Long channelWarehouseId, Integer pageNum, Integer pageSize) {
        RelWarehouseChannelEo relWarehouseChannelEo = new RelWarehouseChannelEo();
        relWarehouseChannelEo.setWarehouseId(channelWarehouseId);
        PageInfo eoPageInfo = this.relWarehouseChannelDomain.selectPage((BaseEo)relWarehouseChannelEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (CollectionUtils.isNotEmpty((Collection)eoPageInfo.getList())) {
            ArrayList<RelWarehouseChannelRespDto> dtoList = new ArrayList<RelWarehouseChannelRespDto>();
            for (RelWarehouseChannelEo eo : eoPageInfo.getList()) {
                RelWarehouseChannelRespDto relWarehouseChannelRespDto = new RelWarehouseChannelRespDto();
                DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)relWarehouseChannelRespDto);
                dtoList.add(relWarehouseChannelRespDto);
            }
            dtoPageInfo.setList(dtoList);
        }
        log.info("\u6e20\u9053\u67e5\u8be2\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)dtoPageInfo));
        return dtoPageInfo;
    }
}

