/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.inventory.share.svr.rest;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IShareGoodsOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ShareGoodsAutoAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ShareGoodsOrderAuditReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ShareGoodsOrderQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.ShareGoodsOrderReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ShareGoodsOrderCountRespDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.response.ShareGoodsOrderRespDto;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.share.exception.WarehouseAbleException;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/shareGoodsOrder"})
public class ShareGoodsOrderRest
implements IShareGoodsOrderApi {
    private static final Logger log = LoggerFactory.getLogger(ShareGoodsOrderRest.class);
    @Resource(name="${yunxi.dg.base.project}_ShareGoodsOrderApi")
    IShareGoodsOrderApi shareGoodsOrderApi;

    public RestResponse<Long> generateShareGoodsOrder(@Validated @RequestBody ShareGoodsOrderReqDto addReqDto) {
        log.info("\u65b0\u589e\u5206\u8d27\u5355\u53c2\u6570\uff1a[{}]", (Object)JSON.toJSONString((Object)addReqDto));
        return this.shareGoodsOrderApi.generateShareGoodsOrder(addReqDto);
    }

    public RestResponse<Void> editShareGoodsOrder(@PathVariable(value="orderNo") String orderNo, @Validated @RequestBody ShareGoodsOrderReqDto updateReqDto) {
        log.info("\u7f16\u8f91\u5206\u8d27\u5355\u53c2\u6570\uff1a[orderNo:{}, {}]", (Object)orderNo, (Object)JSON.toJSONString((Object)updateReqDto));
        return this.shareGoodsOrderApi.editShareGoodsOrder(orderNo, updateReqDto);
    }

    public RestResponse<Void> cancelShareGoodsOrder(@PathVariable(value="orderNo") String orderNo) {
        log.info("\u5173\u95ed\u5206\u8d27\u5355\u53c2\u6570\uff1a[orderNo:{}]", (Object)orderNo);
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)orderNo), (String)"\u5206\u8d27\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        return this.shareGoodsOrderApi.cancelShareGoodsOrder(orderNo);
    }

    @Retryable(value={WarehouseAbleException.class}, maxAttempts=10, backoff=@Backoff(random=true, delay=500L, maxDelay=6000L, multiplier=1.2))
    public RestResponse<List<String>> batchAuditShareGoodsOrder(@RequestBody List<ShareGoodsOrderAuditReqDto> auditReqDtos) {
        log.info("\u6279\u91cf\u5ba1\u6838\u5206\u8d27\u5355\u53c2\u6570\uff1a[{}]", (Object)JSON.toJSONString(auditReqDtos));
        return this.shareGoodsOrderApi.batchAuditShareGoodsOrder(auditReqDtos);
    }

    public RestResponse<ShareGoodsOrderRespDto> queryByPrimaryKey(@PathVariable(value="id") Long id) {
        log.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        AssertUtils.isTrue((id != null && id > 0L ? 1 : 0) != 0, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        return this.shareGoodsOrderApi.queryByPrimaryKey(id);
    }

    public RestResponse<PageInfo<ShareGoodsOrderRespDto>> queryByPage(@Validated @RequestBody ShareGoodsOrderQueryDto queryDto) {
        log.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)JSON.toJSONString((Object)queryDto));
        return this.shareGoodsOrderApi.queryByPage(queryDto);
    }

    public RestResponse<ShareGoodsOrderCountRespDto> shareGoodsOrderCount(@Validated @RequestBody ShareGoodsOrderQueryDto queryDto) {
        log.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)JSON.toJSONString((Object)queryDto));
        return this.shareGoodsOrderApi.shareGoodsOrderCount(queryDto);
    }

    public RestResponse<List<ShareGoodsOrderRespDto>> queryByParam(@Validated @RequestBody ShareGoodsOrderQueryDto queryDto) {
        log.info("\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)JSON.toJSONString((Object)queryDto));
        return this.shareGoodsOrderApi.queryByParam(queryDto);
    }

    public RestResponse<ShareGoodsOrderRespDto> queryByOrderNo(@PathVariable(value="orderNo") String orderNo) {
        log.info("\u6839\u636e\u5206\u8d27\u5355\u53f7\u67e5\u8be2\u8be6\u60c5\uff1a[{}]", (Object)orderNo);
        return this.shareGoodsOrderApi.queryByOrderNo(orderNo);
    }

    @Retryable(value={WarehouseAbleException.class}, maxAttempts=10, backoff=@Backoff(random=true, delay=500L, maxDelay=6000L, multiplier=1.2))
    public RestResponse<Void> createAndAuditShareGoodsOrder(ShareGoodsAutoAuditReqDto auditReqDtos) {
        log.info("\u81ea\u52a8\u521b\u5efa\u5e76\u5ba1\u6838\u63a5\u53e3\uff1a[{}]", (Object)auditReqDtos);
        return this.shareGoodsOrderApi.createAndAuditShareGoodsOrder(auditReqDtos);
    }
}

