/**
 * @(#) SourceAssert.java 1.0 2022/4/20/020
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.transform.api.exception;

import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.Collection;

/**
 * 描述
 *
 * @author zimu
 * @date 2022/4/20/020
 * @since 1.0.0
 */
public class PlatformAssert {

    public static void notNull(Object obj, PlatformExceptionCode platformExceptionCode, String... formats) {
        if (obj == null) {
            throw platformExceptionCode.buildBizException(formats);
        }
    }

    public static void needEquals(Object obj, Object eq, PlatformExceptionCode platformExceptionCode, String... formats) {
        if (!obj.equals(eq)) {
            throw platformExceptionCode.buildBizException(formats);
        }
    }

    public static void notBlank(String str, PlatformExceptionCode platformExceptionCode, String... formats) {
        if (StringUtils.isBlank(str)) {
            throw platformExceptionCode.buildBizException(formats);
        }
    }

    public static void notEmpty(Collection collection, PlatformExceptionCode platformExceptionCode, String... formats) {
        if (collection == null || collection.isEmpty()) {
            throw platformExceptionCode.buildBizException(formats);
        }
    }

    public static void moreThanZero(BigDecimal bigDecimal, PlatformExceptionCode platformExceptionCode, String... formats) {
        if (bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
            throw platformExceptionCode.buildBizException(formats);
        }
    }

}
