package com.dtyunxi.yundt.cube.center.transform.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.RChannelLogicWarehouseReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.response.RChannelLogicWarehouseRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
* 服务接口
*
* @author cijian
* @since 2022-08-02
*/
@Api(tags = {"服务"})
@FeignClient(
    contextId = "com-dtyunxi-yundt-cube-center-transform-api-IRChannelLogicWarehouseApi",
    name = "${yundt.cube.center.transform.api.name:yundt-cube-center-transform}",
    path = "/v1/pcp/order/rel/warehouse",
    url = "${yundt.cube.center.transform.api:}"
)
public interface IRChannelLogicWarehouseApi {

/**
* 新增
*
* @param addReqDto 请求对象
* @return 处理结果
*/
@PostMapping("")
@ApiOperation(value = "新增", notes = "新增")
RestResponse<Long> addRChannelLogicWarehouse(@RequestBody RChannelLogicWarehouseReqDto addReqDto);

    /**
    * 修改
    *
    * @param modifyReqDto 请求对象
    * @return 处理结果
    */
    @PutMapping("")
    @ApiOperation(value = "修改", notes = "修改")
    RestResponse<Void> modifyRChannelLogicWarehouse(@RequestBody RChannelLogicWarehouseReqDto modifyReqDto);

    /**
    * 删除
    *
    * @param ids        删除数据ID
    * @param instanceId 实例ID
    * @return 处理结果
    */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除", notes = "删除")
    RestResponse<Void> removeRChannelLogicWarehouse(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
