/**
 * @(#) ThirdOrderReqDto.java 1.0 2022/3/30/030
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.transform.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 外部销售订单退货请求
 *
 * @author zimu
 * @date 2022/3/30/030
 * @since 1.0.0
 */
@Data
@ApiModel(value = "ThirdOrderRefundReqDto", description = "外部销售订单退货请求")
public class ThirdOrderRefundReqDto extends BaseVo {
    /**
     *  平台退货单号
     */
    @ApiModelProperty(name = "platformRefundNo",required = true, value = "平台退货单号")
    private String platformRefundNo;
    /**
     *  平台退货申请时间
     */
    @ApiModelProperty(name = "platformRefundApplyTime",required = true, value = "平台退货申请时间")
    private Date platformRefundApplyTime;
    /**
     *  退货单类型 NORMAL:常规退货、SPECIAL:特殊退货、BACK:回购退货
     */
    @ApiModelProperty(name = "refundType", required = true,value = "销售退货单类型 NORMAL:常规退货、SPECIAL:特殊退货、BACK:回购退货")
    private String refundType;
    /**
     *  内部销售退货单号
     */
    @ApiModelProperty(name = "refundNo", value = "内部销售退货单号")
    private String refundNo;
    /**
     *  销售退货状态 WAIT_REFUND:待退货、REFUNDED:已完成
     */
    @ApiModelProperty(name = "refundStatus", value = "销售退货状态 WAIT_REFUND:待退货、REFUNDED:已完成")
    private String refundStatus;
    /**
     *  实际退货时间
     */
    @ApiModelProperty(name = "actualRefundTime", required = true,value = "实际退货时间")
    private Date actualRefundTime;
    /**
     *  第三方id
     */
    @ApiModelProperty(name = "thirdPartyId", required = true,value = "第三方客户租户id")
    private String thirdPartyId;
    /**
     *  联系人名称
     */
    @ApiModelProperty(name = "contactPersonName", required = true,value = "联系人名称")
    private String contactPersonName;
    /**
     *  联系电话
     */
    @ApiModelProperty(name = "contactPhone", required = true,value = "联系电话")
    private String contactPhone;
    /**
     *  销售组织名称
     */
    @ApiModelProperty(name = "saleOrgName", required = true,value = "销售组织名称")
    private String saleOrgName;
    /**
     *  订单渠道code
     */
    @ApiModelProperty(name = "orderChannelCode", required = true,value = "订单渠道code")
    private String orderChannelCode;
    /**
     *  申请销售退货仓编码
     */
    @ApiModelProperty(name = "applyRefundWarehouseCode",required = true, value = "申请销售退货仓编码")
    private String applyRefundWarehouseCode;

    /**
     * 销售退货单商品集合
     */
    @ApiModelProperty(name = "saleRefundOrderItemReqDtoList", required = true, value = "销售退货单商品集合")
    private List<SaleRefundOrderItemReqDto> saleRefundOrderItemReqDtoList;

    /**
     * 销售退货单地址
     */
    @ApiModelProperty(name = "saleRefundAddrReqDto", required = true, value = "销售退货单地址")
    private SaleRefundAddrReqDto saleRefundAddrReqDto;

}
