/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.customer.apiimpl;

import com.dtyunxi.cube.biz.commons.constants.OssConstant;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.ICustomerDataApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerImportLogSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerImportSaveReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.ImportUpdateReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerImportLogRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.enmus.ImportStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.apiimpl.ICustomerImportLogQueryService;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerImportLogDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerImportLogEo;
import com.github.pagehelper.PageInfo;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="customerDataApi")
@Primary
public class CustomerDataApiImpl
implements ICustomerDataApi {
    private static final Logger logger = LoggerFactory.getLogger(CustomerDataApiImpl.class);
    @Autowired
    private CustomerImportLogDas customerImportLogDas;
    @Resource
    private IObjectStorageService objectStorageService;
    @Resource
    private ICustomerImportLogQueryService memberImportLogService;

    public RestResponse<Long> saveCustomerInfoImport(CustomerImportSaveReqDto customerImportSaveReqDto) {
        if (null == customerImportSaveReqDto.getUrl() || null == customerImportSaveReqDto.getImportType()) {
            return new RestResponse("100000", "url\u8def\u5f84\u6216\u5bfc\u5165\u7c7b\u578b\u4e3a\u7a7a");
        }
        CustomerImportLogEo customerImportLogEo = new CustomerImportLogEo();
        customerImportLogEo.setImportFileName(customerImportSaveReqDto.getFileName());
        customerImportLogEo.setStatus(ImportStatusEnum.LOADING.getCode());
        customerImportLogEo.setImportType(customerImportSaveReqDto.getImportType());
        customerImportLogEo.setCreatePerson(customerImportSaveReqDto.getOperator());
        customerImportLogEo.setRemark("\u5bfc\u5165\u7684url" + customerImportSaveReqDto.getUrl());
        DtoHelper.dto2Eo((BaseVo)customerImportSaveReqDto, (BaseEo)customerImportLogEo);
        this.customerImportLogDas.insert((BaseEo)customerImportLogEo);
        return new RestResponse((Object)customerImportLogEo.getId());
    }

    public String uploadExcelFile(MultipartFile multipartFile) {
        String downloadUrl = null;
        try {
            this.objectStorageService.put(OssConstant.BUCKET_NAME, multipartFile.getOriginalFilename(), multipartFile.getInputStream());
            downloadUrl = OssConstant.OSS_DOWNLOAD_URL + "/" + multipartFile.getOriginalFilename();
            return downloadUrl;
        }
        catch (IOException e) {
            logger.error("\u51fa\u73b0\u5f02\u5e38=={}", (Object)e.getMessage());
            return null;
        }
    }

    public RestResponse<Void> update(ImportUpdateReqDto sourceCustomerImportSaveReqDto) {
        if (null == sourceCustomerImportSaveReqDto.getId()) {
            return new RestResponse("100000", "\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CustomerImportLogEo newCustomerImportLogEo = new CustomerImportLogEo();
        newCustomerImportLogEo.setId(sourceCustomerImportSaveReqDto.getId());
        CustomerImportLogEo oldCustomerImportLogEo = (CustomerImportLogEo)this.customerImportLogDas.selectOne((BaseEo)newCustomerImportLogEo);
        if (oldCustomerImportLogEo == null) {
            throw new BizException("\u4e3b\u952eID\u627e\u4e0d\u5230\u5bfc\u5165\u8bb0\u5f55");
        }
        DtoHelper.dto2Eo((BaseVo)sourceCustomerImportSaveReqDto, (BaseEo)oldCustomerImportLogEo);
        this.customerImportLogDas.updateSelective((BaseEo)oldCustomerImportLogEo);
        return RestResponse.VOID;
    }

    public RestResponse<PageInfo<CustomerImportLogRespDto>> queryCustomerImportLogPage(CustomerImportLogSearchReqDto customerImportLogSearchReqDto) {
        RestResponse pageInfoRestResponse = new RestResponse(this.memberImportLogService.queryMemberImportLogPage(customerImportLogSearchReqDto));
        List list = ((PageInfo)pageInfoRestResponse.getData()).getList();
        for (CustomerImportLogRespDto customerImportLogRespDto : list) {
            customerImportLogRespDto.setImportStatusName(ImportStatusEnum.toName((Integer)customerImportLogRespDto.getStatus()));
        }
        return pageInfoRestResponse;
    }
}

