/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.customer.apiimpl.query;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerTypePageReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerNameSimpleRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerTypeRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerTypeQueryApi;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerTypeService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.IRCustomerTypeBrandService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.IRCustomerTypeDirService;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerTypeEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="customerTypeQueryApi")
public class CustomerTypeQueryApiImpl
implements ICustomerTypeQueryApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ICustomerTypeService customerTypeService;
    @Resource
    private IRCustomerTypeDirService rCustomerTypeDirService;
    @Resource
    private IRCustomerTypeBrandService rCustomerTypeBrandService;
    @Autowired
    private ICustomerService customerService;
    @Resource
    private IContext context;

    public RestResponse<List<CustomerTypeRespDto>> queryAllCustomerType(Integer type) {
        List<CustomerTypeEo> customerTypeEos = this.customerTypeService.queryAllCustomerType(type);
        ArrayList<CustomerTypeRespDto> customerTypeRespDtos = new ArrayList<CustomerTypeRespDto>(customerTypeEos.size());
        Long orgId = this.customerTypeService.getCurrentUserOrgIdNoException(this.context.userId());
        for (CustomerTypeEo customerTypeEo : customerTypeEos) {
            CustomerTypeRespDto customerTypeRespDto = this.getCustomerTypeRespDto(customerTypeEo, orgId);
            customerTypeRespDtos.add(customerTypeRespDto);
        }
        return new RestResponse(customerTypeRespDtos);
    }

    public RestResponse<List<CustomerTypeRespDto>> queryAllSimpleCustomerType(Integer type) {
        List<CustomerTypeEo> customerTypeEos = this.customerTypeService.queryAllCustomerType(type);
        ArrayList<CustomerTypeRespDto> customerTypeRespDtos = new ArrayList<CustomerTypeRespDto>(customerTypeEos.size());
        for (CustomerTypeEo customerTypeEo : customerTypeEos) {
            CustomerTypeRespDto customerTypeRespDto = new CustomerTypeRespDto();
            DtoHelper.eo2Dto((BaseEo)customerTypeEo, (BaseVo)customerTypeRespDto);
            customerTypeRespDtos.add(customerTypeRespDto);
        }
        return new RestResponse(customerTypeRespDtos);
    }

    private CustomerTypeRespDto getCustomerTypeRespDto(CustomerTypeEo customerTypeEo, Long orgInfoId) {
        CustomerTypeRespDto customerTypeRespDto = new CustomerTypeRespDto();
        DtoHelper.eo2Dto((BaseEo)customerTypeEo, (BaseVo)customerTypeRespDto);
        customerTypeRespDto.setProductType("\u6307\u5b9a\u5206\u7c7b");
        customerTypeRespDto.setProductBrand("\u6307\u5b9a\u54c1\u724c");
        List<Long> dirIds = this.rCustomerTypeDirService.findByCustomerTypeId(customerTypeEo.getId(), orgInfoId);
        List<Long> brandIds = this.rCustomerTypeBrandService.findByCustomerTypeId(customerTypeEo.getId(), orgInfoId);
        customerTypeRespDto.setDirIds(dirIds);
        customerTypeRespDto.setProductBrandIds(brandIds);
        Integer i = this.customerService.countByCustomerTypeId(customerTypeEo.getId());
        customerTypeRespDto.setCustomerNum(i);
        return customerTypeRespDto;
    }

    public RestResponse<PageInfo<CustomerTypeRespDto>> queryCustomerTypeByPage(Integer pageNum, Integer pageSize) {
        PageInfo<CustomerTypeEo> customerTypeRespDtoPageInfo = this.customerService.queryCustomerTypeByPage(pageNum, pageSize);
        PageInfo pageInfo = new PageInfo();
        ArrayList<CustomerTypeRespDto> list = new ArrayList<CustomerTypeRespDto>();
        Long orgId = this.customerTypeService.getCurrentUserOrgIdNoException(this.context.userId());
        for (CustomerTypeEo customerTypeEo : customerTypeRespDtoPageInfo.getList()) {
            CustomerTypeRespDto customerTypeRespDto = this.getCustomerTypeRespDto(customerTypeEo, orgId);
            list.add(customerTypeRespDto);
        }
        BeanUtils.copyProperties(customerTypeRespDtoPageInfo, (Object)pageInfo);
        pageInfo.setList(list);
        return new RestResponse((Object)pageInfo);
    }

    public RestResponse<PageInfo<CustomerTypeRespDto>> queryCustomerTypeByType(CustomerTypePageReqDto customerTypePageReqDto) {
        return new RestResponse(this.customerTypeService.queryCustomerTypeByType(customerTypePageReqDto));
    }

    public RestResponse<CustomerTypeRespDto> queryById(Long id) {
        CustomerTypeEo customerTypeEo = this.customerTypeService.queryById(id);
        CustomerTypeRespDto customerTypeRespDto = new CustomerTypeRespDto();
        DtoHelper.eo2Dto((BaseEo)customerTypeEo, (BaseVo)customerTypeRespDto);
        return new RestResponse((Object)customerTypeRespDto);
    }

    public RestResponse<CustomerTypeRespDto> queryByCustomerId(Long customerId) {
        return new RestResponse((Object)this.customerTypeService.queryByCustomerId(customerId));
    }

    public RestResponse<List<CustomerNameSimpleRespDto>> queryListByIds(List<Long> ids) {
        return new RestResponse(this.customerTypeService.queryCustomerTyperNameListByIds(ids));
    }
}

