/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.customer.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.enums.SortOrder;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerTypePageReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerTypeReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerNameSimpleRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerTypeRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.enmus.CustomerTypeSourceTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.exception.CustomerBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.customer.api.customer.exception.CustomerExceptionCode;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerTypeService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.IRCustomerTypeBrandService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.IRCustomerTypeDirService;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerTypeDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerTypeEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.RCustomerTypeBrandEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.RCustomerTypeDirEo;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service(value="customerType")
public class CustomerTypeServiceImpl
implements ICustomerTypeService {
    private static final Logger logger = LoggerFactory.getLogger(CustomerTypeServiceImpl.class);
    @Resource
    private CustomerTypeDas customerTypeDas;
    @Resource
    private CustomerDas customerDas;
    @Autowired
    private ICustomerService customerService;
    @Autowired
    private IRCustomerTypeBrandService irCustomerTypeBrandService;
    @Resource
    private IRCustomerTypeDirService irCustomerTypeDirService;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private IContext context;

    @Override
    public List<CustomerTypeEo> queryAllCustomerType(Integer type) {
        return this.customerTypeDas.queryAllCustomerType(type);
    }

    @Override
    @Transactional(transactionManager="dataSourceTransactionManager", rollbackFor={Exception.class})
    public Long saveCustomerType(CustomerTypeReqDto customerTypeSaveReqDto) {
        Integer count;
        CustomerTypeEo customerTypeEo = new CustomerTypeEo();
        customerTypeEo.setCode(customerTypeSaveReqDto.getCode());
        customerTypeEo.setType(customerTypeSaveReqDto.getType());
        customerTypeEo.setId(customerTypeSaveReqDto.getId());
        customerTypeEo.setName(customerTypeSaveReqDto.getName());
        customerTypeEo.setTypeIntroduction(customerTypeSaveReqDto.getTypeIntroduction());
        customerTypeEo.setSort(customerTypeSaveReqDto.getSort());
        CustomerTypeEo customerTypeName = new CustomerTypeEo();
        customerTypeName.setType(customerTypeSaveReqDto.getType());
        customerTypeName.setName(customerTypeSaveReqDto.getName());
        customerTypeName.setDr(0);
        QueryWrapper queryNameWrapper = new QueryWrapper((Object)customerTypeName);
        if (Objects.nonNull(customerTypeSaveReqDto.getId())) {
            queryNameWrapper.ne((Object)"id", (Object)customerTypeSaveReqDto.getId());
        }
        if (Objects.nonNull(count = this.customerTypeDas.getMapper().selectCount((Wrapper)queryNameWrapper)) && count > 0) {
            throw new CustomerBusinessRuntimeException(CustomerExceptionCode.CUSTOMER_NAME_EXISTS_CUSTOMER);
        }
        if (null == customerTypeSaveReqDto.getId()) {
            this.customerTypeDas.insert((BaseEo)customerTypeEo);
        } else {
            CustomerTypeEo customerTypeEo1 = (CustomerTypeEo)this.customerTypeDas.selectByPrimaryKey(customerTypeSaveReqDto.getId());
            if (null == customerTypeEo1) {
                throw new CustomerBusinessRuntimeException(CustomerExceptionCode.SYS_OBJ_NOT_FOUND, new Object[]{"\u5ba2\u6237\u7c7b\u578b"});
            }
            if (CustomerTypeSourceTypeEnum.fromCode((Integer)customerTypeEo.getCustomerTypeSourceType()) == CustomerTypeSourceTypeEnum.system) {
                customerTypeEo.setSort(customerTypeEo1.getSort());
            }
            this.customerTypeDas.updateSelective((BaseEo)customerTypeEo);
            if (Objects.isNull(customerTypeEo.getSort())) {
                this.customerTypeDas.updateInfoById(customerTypeEo);
            }
        }
        List productBrandIds = customerTypeSaveReqDto.getProductBrandIds();
        List productTypeIds = customerTypeSaveReqDto.getProductTypeIds();
        if (CollUtil.isEmpty((Collection)productBrandIds) && CollUtil.isEmpty((Collection)productTypeIds)) {
            return customerTypeEo.getId();
        }
        Long orgId = this.getCurrentUserOrgIdNoException(this.context.userId());
        if (customerTypeSaveReqDto.getId() != null) {
            this.irCustomerTypeBrandService.deleteByCustomerTypeId(customerTypeSaveReqDto.getId(), orgId);
            this.irCustomerTypeDirService.deleteByCustomerTypeId(customerTypeSaveReqDto.getId(), orgId);
        }
        HashSet brandSet = new HashSet(productBrandIds);
        ArrayList<RCustomerTypeBrandEo> rcs = new ArrayList<RCustomerTypeBrandEo>(brandSet.size());
        for (Long brandId : brandSet) {
            RCustomerTypeBrandEo rCustomerTypeBrandEo = new RCustomerTypeBrandEo();
            rCustomerTypeBrandEo.setCustomerTypeId(customerTypeEo.getId());
            rCustomerTypeBrandEo.setBrandId(brandId);
            rCustomerTypeBrandEo.setOrgInfoId(orgId);
            rcs.add(rCustomerTypeBrandEo);
        }
        HashSet dirIdSet = new HashSet(productTypeIds);
        ArrayList<RCustomerTypeDirEo> dirEos = new ArrayList<RCustomerTypeDirEo>(dirIdSet.size());
        for (Long dirId : dirIdSet) {
            RCustomerTypeDirEo rCustomerTypeDirEo = new RCustomerTypeDirEo();
            rCustomerTypeDirEo.setCustomerTypeId(customerTypeEo.getId());
            rCustomerTypeDirEo.setDirId(dirId);
            rCustomerTypeDirEo.setOrgInfoId(orgId);
            dirEos.add(rCustomerTypeDirEo);
        }
        this.irCustomerTypeBrandService.insertBatch(rcs);
        this.irCustomerTypeDirService.insertBatch(dirEos);
        return null;
    }

    @Override
    @Transactional
    public void deleteCustomerType(Long customerTypeId) {
        int i = this.customerService.countByCustomerTypeId(customerTypeId);
        if (i > 0) {
            throw new CustomerBusinessRuntimeException(CustomerExceptionCode.CUSTOMER_TYPE_EXISTS_CUSTOMER_TEMP.getCode(), CustomerExceptionCode.CUSTOMER_TYPE_EXISTS_CUSTOMER_TEMP.getMsg());
        }
        CustomerTypeEo customerTypeEo = (CustomerTypeEo)this.customerTypeDas.selectByPrimaryKey(customerTypeId);
        if (customerTypeEo == null) {
            throw new BizException(CustomerExceptionCode.SYSTEM_DATA_NOT_DELETE.getCode(), "\u8be5\u5ba2\u6237\u7c7b\u578b\u5df2\u5220\u9664");
        }
        if (CustomerTypeSourceTypeEnum.fromCode((Integer)customerTypeEo.getCustomerTypeSourceType()) == CustomerTypeSourceTypeEnum.system) {
            throw new BizException("\u7cfb\u7edf\u6570\u636e\u4e0d\u53ef\u5220\u9664");
        }
        this.customerTypeDas.deleteById(customerTypeId);
    }

    @Override
    @Transactional
    public void changeCustomerType(Long originCustomerTypeId, Long finalCustomerTypeId) {
        this.customerService.updateCustomerTypeId(originCustomerTypeId, finalCustomerTypeId);
    }

    @Override
    public CustomerTypeEo queryById(Long id) {
        CustomerTypeEo customerTypeEo = (CustomerTypeEo)this.customerTypeDas.selectByPrimaryKey(id);
        Assert.notNull((Object)customerTypeEo, (String)CustomerExceptionCode.CUSTOMER_TYPE_NON_EXIST.getMsg());
        return customerTypeEo;
    }

    @Override
    public CustomerTypeRespDto queryByCustomerId(Long customerId) {
        CustomerEo customerEo = (CustomerEo)this.customerDas.selectByPrimaryKey(customerId);
        Assert.notNull((Object)customerEo, (String)CustomerExceptionCode.CUSTOMER_NON_EXIST.getMsg());
        CustomerTypeEo customerTypeEo = (CustomerTypeEo)this.customerTypeDas.selectByPrimaryKey(customerEo.getCustomerTypeId());
        Assert.notNull((Object)customerTypeEo, (String)CustomerExceptionCode.CUSTOMER_TYPE_NON_EXIST.getMsg());
        CustomerTypeRespDto customerTypeRespDto = new CustomerTypeRespDto();
        DtoHelper.eo2Dto((BaseEo)customerTypeEo, (BaseVo)customerTypeRespDto);
        customerTypeRespDto.setProductType("\u6307\u5b9a\u5206\u7c7b");
        customerTypeRespDto.setProductBrand("\u6307\u5b9a\u54c1\u724c");
        if (this.context.userId() != null) {
            Long orgId = this.getCurrentUserOrgIdNoException(this.context.userId());
            List<Long> dirIds = this.irCustomerTypeDirService.findByCustomerTypeId(customerTypeEo.getId(), orgId);
            List<Long> brandIds = this.irCustomerTypeBrandService.findByCustomerTypeId(customerTypeEo.getId(), orgId);
            customerTypeRespDto.setDirIds(dirIds);
            customerTypeRespDto.setProductBrandIds(brandIds);
        }
        return customerTypeRespDto;
    }

    @Override
    public List<CustomerNameSimpleRespDto> queryCustomerTyperNameListByIds(List<Long> ids) {
        logger.info("\u83b7\u53d6\u6307\u5b9a\u5ba2\u6237\u7c7b\u578b[{}]", CollectionUtils.isEmpty(ids) ? "\u7a7a\u5bf9\u8c61" : Integer.valueOf(ids.size()));
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<CustomerNameSimpleRespDto>();
        }
        return this.customerTypeDas.queryCustomeTyperNameListByIds(ids);
    }

    @Override
    public Long getCurrentUserOrgIdNoException(Long userId) {
        RestResponse pageInfoRestResponse = this.organizationQueryApi.queryUserOrgRelation(userId, Integer.valueOf(1), Integer.valueOf(1));
        PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)pageInfoRestResponse);
        if (CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return null;
        }
        return ((OrganizationDto)pageInfo.getList().get(0)).getId();
    }

    @Override
    public PageInfo<CustomerTypeRespDto> queryCustomerTypeByType(CustomerTypePageReqDto customerTypePageReqDto) {
        Integer sortType = customerTypePageReqDto.getSortType();
        CustomerTypeEo customerTypeEo = new CustomerTypeEo();
        customerTypeEo.setType(customerTypePageReqDto.getType());
        if (Objects.nonNull(sortType)) {
            customerTypeEo.addSqlOrderBy((Objects.equals(sortType, 1) ? "-" : "") + "sort", SortOrder.DESC);
        }
        customerTypeEo.addSqlOrderBy("create_time", SortOrder.DESC);
        PageInfo customerTypeEoPageInfo = this.customerTypeDas.selectPage((BaseEo)customerTypeEo, customerTypePageReqDto.getPageNum(), customerTypePageReqDto.getPageSize());
        if (CollUtil.isNotEmpty((Collection)customerTypeEoPageInfo.getList())) {
            ArrayList list = new ArrayList(customerTypeEoPageInfo.getList().size());
            DtoHelper.eoList2DtoList((Collection)customerTypeEoPageInfo.getList(), list, CustomerTypeRespDto.class);
            customerTypeEoPageInfo.setList(list);
        }
        return customerTypeEoPageInfo;
    }
}

