/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.customer.service.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.biz.commons.constants.OssConstant;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.AuditStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.CustomerTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.constants.StatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerAreaListReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchBaseReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.ExportRecordReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerNameSimpleRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.exception.CustomerBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.customer.api.customer.exception.CustomerExceptionCode;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerAreaService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerExtService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerService;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.vo.CustomerExportVo;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerExportRecordDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerGroupDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerLevelDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerSalesmanDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerStatusDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerTypeDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.RCustomerRegionDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.RCustomerSalesmanDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.mapper.CustomerMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerExportRecordEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerLevelEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerStatusEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerTypeEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.RCustomerRegionEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.RCustomerSalesmanEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerGroupEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerLevelEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerTypeEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdRCustomerRegionEo;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAndOrgInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service(value="customerService")
public class CustomerServiceImpl
implements ICustomerService {
    private Logger logger = LoggerFactory.getLogger(CustomerServiceImpl.class);
    @Resource
    private ICustomerExtService iCustomerExtService;
    @Resource
    private IContext iContext;
    @Resource
    private CustomerDas customerDas;
    @Resource
    private CustomerTypeDas customerTypeDas;
    @Resource
    private CustomerExportRecordDas customerExportRecordDas;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private CustomerStatusDas customerStatusDas;
    @Resource
    private CustomerSalesmanDas customerSalesmanDas;
    @Resource
    private CustomerGroupDas customerGroupDas;
    @Resource
    private RCustomerRegionDas rCustomerRegionDas;
    @Resource
    private CustomerLevelDas customerLevelDas;
    @Resource
    private IObjectStorageService objectStorageService;
    @Resource
    private ICustomerAreaService customerAreaService;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private RCustomerSalesmanDas rCustomerSalesmanDas;
    @Resource
    private ICacheService cacheService;

    @Override
    public Long add(CustomerReqDto reqDto) {
        OrganizationInfoDto organizationInfoDto;
        reqDto.setId(null);
        this.validCustomerCode(reqDto, reqDto.getTenantId());
        CustomerEo customerEo = CustomerEo.newInstance();
        this.initCustomerEo(reqDto, customerEo);
        RestResponse listRestResponse = this.organizationQueryApi.queryOrgAndOrgInfoByIds((List)Lists.newArrayList((Object[])new Long[]{reqDto.getOrgInfoId()}));
        if (!CollectionUtils.isEmpty((Collection)((Collection)listRestResponse.getData())) && (organizationInfoDto = ((OrgAndOrgInfoRespDto)((List)listRestResponse.getData()).get(0)).getOrganizationInfoDto()) != null && StringUtils.isNotEmpty((CharSequence)organizationInfoDto.getCreditCode())) {
            customerEo.setIfCertification(Integer.valueOf(1));
        }
        Long id = this.customerDas.insertById(customerEo);
        if (!CollectionUtils.isEmpty((Collection)reqDto.getRegionCodeList())) {
            ArrayList<RCustomerRegionEo> customerRegionEos = new ArrayList<RCustomerRegionEo>(reqDto.getRegionCodeList().size());
            for (String regionCode : reqDto.getRegionCodeList()) {
                RCustomerRegionEo customerRegionEo = new RCustomerRegionEo();
                customerRegionEo.setCustomerId(id);
                customerRegionEo.setRegionCode(regionCode);
                customerRegionEos.add(customerRegionEo);
            }
            this.rCustomerRegionDas.insertBatch(customerRegionEos);
        }
        return id;
    }

    @Override
    public void update(CustomerReqDto reqDto) {
        Assert.notNull((Object)reqDto.getId(), (String)CustomerExceptionCode.PK_ID_NULL.getMsg());
        CustomerEo queryEo = (CustomerEo)this.customerDas.selectByPrimaryKey(reqDto.getId());
        Assert.notNull((Object)queryEo, (String)CustomerExceptionCode.CUSTOMER_NON_EXIST.getMsg());
        this.validCustomerCode(reqDto, reqDto.getTenantId());
        if (Objects.isNull(queryEo.getIfCertification())) {
            reqDto.setIfCertification(Integer.valueOf(0));
        }
        CustomerEo customerEo = CustomerEo.newInstance();
        this.initCustomerEo(reqDto, customerEo);
        customerEo.setCode(queryEo.getCode());
        this.customerDas.updateSelective((BaseEo)customerEo);
        RCustomerRegionEo deleteEo = new RCustomerRegionEo();
        deleteEo.setCustomerId(reqDto.getId());
        this.rCustomerRegionDas.delete((BaseEo)deleteEo);
        if (!CollectionUtils.isEmpty((Collection)reqDto.getRegionCodeList())) {
            ArrayList<RCustomerRegionEo> customerRegionEos = new ArrayList<RCustomerRegionEo>(reqDto.getRegionCodeList().size());
            for (String regionCode : reqDto.getRegionCodeList()) {
                RCustomerRegionEo customerRegionEo = new RCustomerRegionEo();
                customerRegionEo.setCustomerId(reqDto.getId());
                customerRegionEo.setRegionCode(regionCode);
                customerRegionEos.add(customerRegionEo);
            }
            this.rCustomerRegionDas.insertBatch(customerRegionEos);
        }
        CubeBeanUtils.copyProperties((Object)queryEo, (Object)customerEo, (String[])new String[0]);
        String regionCodes = StringUtils.join((Iterable)reqDto.getRegionCodeList(), (String)",");
        String regionNames = StringUtils.join((Iterable)reqDto.getRegionNameList(), (String)",");
    }

    @Override
    public void sendMq(CustomerEo customerEo, String regionNames, String regionCodes) {
        CustomerRespDto customerRespDto = new CustomerRespDto();
        this.logger.info("\u53d1\u9001mq\u5f53\u524d\u7c7b=CustomerServiceImpl.sendMq()customerEo = [" + customerEo + "], regionNames = [" + regionNames + "], regionNames = [" + regionCodes + "]");
        try {
            if (customerEo.getCustomerTypeId() != null) {
                CustomerTypeEo customerTypeEo = (CustomerTypeEo)this.customerTypeDas.selectByPrimaryKey(customerEo.getCustomerTypeId());
                customerRespDto.setCustomerTypeName(customerTypeEo.getName());
            }
            if (customerEo.getStatusId() != null) {
                CustomerStatusEo customerStatusEo = (CustomerStatusEo)this.customerStatusDas.selectByPrimaryKey(customerEo.getStatusId());
                customerRespDto.setStatusName(customerStatusEo.getName());
            }
            customerRespDto.setStatusId(customerEo.getStatusId());
            customerRespDto.setId(customerEo.getId());
            customerRespDto.setCode(customerEo.getCode());
            customerRespDto.setName(customerEo.getName());
            customerRespDto.setRegionId(customerEo.getRegionId());
            customerRespDto.setRegionCode(regionCodes);
            customerRespDto.setRegion(regionNames);
            customerRespDto.setCustomerTypeId(customerEo.getCustomerTypeId());
            customerRespDto.setCustomerId(customerEo.getId());
            customerRespDto.setId(customerEo.getId());
            this.commonsMqService.sendSingleMessage("CUSTOMER_UPDATE", (Object)customerRespDto);
            this.commonsMqService.publishMessageAsync("CUSTOMER_UPDATE_PUBLISH", (Object)JSON.toJSONString((Object)customerRespDto));
        }
        catch (Exception e) {
            this.logger.debug(e.getMessage());
        }
    }

    @Override
    public List<CustomerNameSimpleRespDto> queryByListParent(Long customerId) {
        ArrayList<Long> customerIds = new ArrayList<Long>();
        customerIds.add(customerId);
        List customerNameSimpleRespDtos = this.customerDas.queryListByParentIds(customerIds);
        List<Long> sunParentIds = customerNameSimpleRespDtos.stream().map(CustomerNameSimpleRespDto::getId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(sunParentIds)) {
            customerNameSimpleRespDtos.addAll(this.getCustomerRespDtos(sunParentIds));
        }
        List collect = customerNameSimpleRespDtos.stream().map(CustomerNameSimpleRespDto::getId).collect(Collectors.toList());
        collect.add(customerId);
        return this.customerDas.queryListByNotIds(this.iContext.instanceId(), this.iContext.tenantId(), collect, null, null);
    }

    @Override
    public List<Long> queryIdsBySingleFilter(CustomerSearchBaseReqDto customerSearchReqDto) {
        List ids = this.customerDas.queryIdsBySingleFilter(customerSearchReqDto);
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String queryExcelDownloadUrl() {
        String fileNameTemplate = "\u5ba2\u6237\u5bfc\u5165\u6a21\u677f_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss") + new Random().nextInt(100) + ".xls";
        Workbook workbook = null;
        ExportParams params = new ExportParams(null, "sheet1");
        ByteArrayOutputStream fos = null;
        String filePath = null;
        try {
            workbook = ExcelExportUtil.exportBigExcel((ExportParams)params, CustomerExportVo.class, new ArrayList());
            ExcelExportUtil.closeExportBigExcel();
            fos = new ByteArrayOutputStream();
            workbook.write((OutputStream)fos);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fos.toByteArray());
            filePath = this.objectStorageService.put(OssConstant.BUCKET_NAME, fileNameTemplate, (InputStream)byteArrayInputStream);
            this.logger.info("Excel\u6587\u4ef6\uff1a{}\u5df2\u4e0a\u4f20\u5230oss\u670d\u52a1\u5668...", (Object)(OssConstant.OSS_DOWNLOAD_URL + "/" + fileNameTemplate));
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51fa\u5f02\u5e38\uff1a", (Throwable)e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException var13) {
                this.logger.error("\u5173\u95ed\u6d41\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Throwable)var13);
            }
        }
        return filePath;
    }

    @Override
    public PageInfo<CustomerRespDto> queryByExcel(MultipartFile file) {
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        List customerImportVoList = new ArrayList();
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), CustomerExportVo.class, (ImportParams)importParams);
            customerImportVoList = result.getList();
            if (org.apache.commons.collections.CollectionUtils.isEmpty(customerImportVoList)) {
                throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u7b26\u5408\u6a21\u677f\u683c\u5f0f\u8981\u6c42");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        ArrayList codeInList = new ArrayList();
        customerImportVoList.forEach(customerExportVo -> codeInList.add(customerExportVo.getCode()));
        searchReqDto.setCodeInList(codeInList);
        return this.queryByPage(JSON.toJSONString((Object)searchReqDto), 1, Integer.MAX_VALUE);
    }

    @Override
    public List<CustomerRespDto> queryPostByList(CustomerSearchReqDto searchReqDto) {
        if (!CollectionUtils.isEmpty((Collection)searchReqDto.getRegionCodes())) {
            RCustomerRegionEo selectEo = new RCustomerRegionEo();
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"region_code", (Object)StringUtils.join((Iterable)searchReqDto.getRegionCodes(), (String)",")));
            selectEo.setSqlFilters(sqlFilters);
            List customerRegionEos = this.rCustomerRegionDas.select((BaseEo)selectEo);
            Set customerIdList = customerRegionEos.stream().map(StdRCustomerRegionEo::getCustomerId).collect(Collectors.toSet());
            searchReqDto.setIdList(new ArrayList(customerIdList));
        }
        List customerList = this.customerDas.queryListBySearchCon(searchReqDto);
        return customerList;
    }

    @Override
    public void modifyCustomerUserIdByThirdPartyId(List<CustomerReqDto> reqDtos) {
        this.customerDas.modifyCustomerUserIdByThirdPartyId(reqDtos);
    }

    private List<CustomerNameSimpleRespDto> getCustomerRespDtos(List<Long> parentIds) {
        List customerNameSimpleRespDtos = this.customerDas.queryListByParentIds(parentIds);
        List<Long> sunParentIds = customerNameSimpleRespDtos.stream().map(CustomerNameSimpleRespDto::getId).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(sunParentIds)) {
            customerNameSimpleRespDtos.addAll(this.getCustomerRespDtos(sunParentIds));
        }
        return customerNameSimpleRespDtos;
    }

    @Override
    public CustomerRespDto queryById(Long id) {
        CustomerLevelEo customerLevelEo;
        CustomerEo customerEo = (CustomerEo)this.customerDas.selectByPrimaryKey(id);
        Assert.notNull((Object)customerEo, (String)CustomerExceptionCode.CUSTOMER_NON_EXIST.getMsg());
        CustomerRespDto customerRespDto = new CustomerRespDto();
        DtoHelper.eo2Dto((BaseEo)customerEo, (BaseVo)customerRespDto);
        if (customerEo.getParentCustomerId() != null) {
            CustomerEo customerEo1 = (CustomerEo)this.customerDas.selectByPrimaryKey(customerEo.getParentCustomerId());
            customerEo1 = customerEo1 == null ? new CustomerEo() : customerEo1;
            customerRespDto.setParentCustomerName(customerEo1.getName());
        }
        CustomerTypeEo customerTypeEo = (CustomerTypeEo)this.customerTypeDas.selectByPrimaryKey(customerEo.getCustomerTypeId());
        Assert.notNull((Object)customerTypeEo, (String)CustomerExceptionCode.CUSTOMER_NON_EXIST.getMsg());
        customerRespDto.setCustomerTypeName(customerTypeEo.getName());
        RCustomerRegionEo selectEo = new RCustomerRegionEo();
        selectEo.setCustomerId(id);
        List customerRegionEos = this.rCustomerRegionDas.select((BaseEo)selectEo);
        List regionCodeList = customerRegionEos.stream().map(StdRCustomerRegionEo::getRegionCode).collect(Collectors.toList());
        customerRespDto.setRegionCodeList(regionCodeList);
        if (Objects.nonNull(customerEo.getLevelId()) && Objects.nonNull(customerLevelEo = (CustomerLevelEo)this.customerLevelDas.selectByPrimaryKey(customerEo.getLevelId()))) {
            customerRespDto.setLevelName(customerLevelEo.getName());
        }
        return customerRespDto;
    }

    @Override
    public CustomerRespDto queryByCode(String code) {
        CustomerEo selectItemCustomer = new CustomerEo();
        selectItemCustomer.setCode(code);
        List customerEos = this.customerDas.selectList((BaseEo)selectItemCustomer);
        if (CollectionUtils.isEmpty((Collection)customerEos)) {
            return null;
        }
        CustomerRespDto customerRespDto = new CustomerRespDto();
        DtoHelper.eo2Dto((BaseEo)((BaseEo)customerEos.get(0)), (BaseVo)customerRespDto);
        return customerRespDto;
    }

    @Override
    public PageInfo<CustomerRespDto> queryByPageOnPost(CustomerSearchReqDto searchReqDto, Integer pageNum, Integer pageSize) {
        return this.queryByPage(JSON.toJSONString((Object)searchReqDto), pageNum, pageSize);
    }

    @Override
    public PageInfo<CustomerRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        PageInfo pageInfo;
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            searchReqDto = (CustomerSearchReqDto)JSONObject.parseObject((String)filter, CustomerSearchReqDto.class);
        }
        List<Object> idList = new ArrayList();
        if (searchReqDto.getIsFilterDownstreamCustomersByCurrentUser().booleanValue()) {
            idList = this.getDownstreamCustomerIdsByCurrentUser();
            if (CollectionUtils.isEmpty(idList)) {
                return new PageInfo();
            }
            if (!CollectionUtils.isEmpty((Collection)searchReqDto.getIdList())) {
                idList.retainAll(searchReqDto.getIdList());
            }
        } else if (CollUtil.isNotEmpty((Collection)searchReqDto.getIdList())) {
            idList = searchReqDto.getIdList();
        }
        if (!CollectionUtils.isEmpty((Collection)searchReqDto.getRegionCodes())) {
            CustomerAreaListReqDto customerAreaListReqDto = new CustomerAreaListReqDto();
            customerAreaListReqDto.setCodes(searchReqDto.getRegionCodes());
            List<String> regionCodeList = this.customerAreaService.querySubCodeAll(customerAreaListReqDto);
            RCustomerRegionEo selectEo = new RCustomerRegionEo();
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"region_code", regionCodeList));
            selectEo.setSqlFilters(sqlFilters);
            List customerRegionEos = this.rCustomerRegionDas.select((BaseEo)selectEo);
            List customerIdList = customerRegionEos.stream().map(StdRCustomerRegionEo::getCustomerId).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(customerIdList)) {
                return new PageInfo();
            }
            if (CollUtil.isEmpty(idList)) {
                idList = customerIdList;
            } else {
                idList.retainAll(customerIdList);
            }
            if (CollectionUtils.isEmpty(idList)) {
                return new PageInfo();
            }
        }
        if (Objects.equals(searchReqDto.getOrgFilter(), 1)) {
            Long currentUserOrgId = this.iCustomerExtService.getCurrentUserOrgId();
            if (Objects.isNull(currentUserOrgId)) {
                return new PageInfo();
            }
            Integer adminFlag = (Integer)this.cacheService.hget("COMMON", "USER_ADMIN_KEY", this.iContext.userId() + "", Integer.class);
            this.setMerchantIds(searchReqDto, currentUserOrgId);
            if (Objects.isNull(adminFlag)) {
                searchReqDto.setSalesmanUserId(this.iContext.userId());
            }
        }
        if (Objects.nonNull(searchReqDto.getSalesmanUserId())) {
            List<Long> customerIdList = this.getCurrentUserOrOrgCustomer(searchReqDto.getSalesmanUserId(), null, false);
            if (CollectionUtils.isEmpty(customerIdList)) {
                return new PageInfo();
            }
            if (CollectionUtils.isEmpty(idList)) {
                idList = customerIdList;
            } else {
                idList.retainAll(customerIdList);
            }
            if (CollectionUtils.isEmpty(idList)) {
                return new PageInfo();
            }
        }
        if (Objects.nonNull(searchReqDto.getSalesmanId())) {
            RCustomerSalesmanEo eo = new RCustomerSalesmanEo();
            eo.setSalesmanId(searchReqDto.getSalesmanId());
            List eos = this.rCustomerSalesmanDas.select((BaseEo)eo);
            if (CollectionUtils.isEmpty((Collection)eos)) {
                return new PageInfo();
            }
            List customerIdList = eos.stream().map(RCustomerSalesmanEo::getCustomerId).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(idList)) {
                idList = customerIdList;
            } else {
                idList.retainAll(customerIdList);
            }
            if (CollectionUtils.isEmpty(idList)) {
                return new PageInfo();
            }
            searchReqDto.setIdList(idList);
        }
        if (!CollectionUtils.isEmpty((Collection)searchReqDto.getCustomerGroupIds())) {
            ArrayList<Long> allCustomerGroupIds = new ArrayList<Long>();
            for (Long groupId : searchReqDto.getCustomerGroupIds()) {
                allCustomerGroupIds.add(groupId);
                this.customerGroupDas.getChildCustomerGroupId(groupId, allCustomerGroupIds);
            }
            searchReqDto.setCustomerGroupIds(allCustomerGroupIds);
        }
        List idNotInList = searchReqDto.getIdNotInList();
        if (CollUtil.isNotEmpty(idList) && CollUtil.isNotEmpty((Collection)idNotInList)) {
            idList.removeAll(idNotInList);
            if (CollUtil.isEmpty(idList)) {
                return new PageInfo();
            }
            searchReqDto.setIdNotInList(null);
        }
        searchReqDto.setIdList(idList);
        if (searchReqDto.getListFlag().booleanValue()) {
            searchReqDto.setAuditStatus(AuditStatusEnum.AUDIT_PASS.getCode());
        }
        if (Objects.nonNull(pageInfo = this.customerDas.queryPageBySearchCon(pageNum, pageSize, searchReqDto)) && !CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            List rCustomerRegionEos = this.rCustomerRegionDas.selectCodeByCusList(pageInfo.getList().stream().map(BaseRespDto::getId).collect(Collectors.toList()));
            Map<Object, Object> idRegionCodeMap = new HashMap(0);
            if (!CollectionUtils.isEmpty((Collection)rCustomerRegionEos)) {
                idRegionCodeMap = rCustomerRegionEos.stream().collect(Collectors.groupingBy(StdRCustomerRegionEo::getCustomerId, Collectors.mapping(StdRCustomerRegionEo::getRegionCode, Collectors.joining(","))));
            }
            List regionCodes = rCustomerRegionEos.stream().map(StdRCustomerRegionEo::getRegionCode).collect(Collectors.toList());
            CompletableFuture<Map> typeMapFuture = CompletableFuture.supplyAsync(() -> this.customerTypeDas.getMapper().selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{BaseEo::getId, StdCustomerTypeEo::getName}).in(BaseEo::getId, (Collection)pageInfo.getList().stream().map(CustomerRespDto::getCustomerTypeId).distinct().collect(Collectors.toList()))).stream().collect(Collectors.toMap(BaseEo::getId, StdCustomerTypeEo::getName)));
            CompletableFuture<Map> statusMapFuture = CompletableFuture.supplyAsync(() -> this.customerStatusDas.getMapper().selectList((Wrapper)new LambdaQueryWrapper().in(BaseEo::getId, (Collection)pageInfo.getList().stream().map(CustomerRespDto::getStatusId).distinct().collect(Collectors.toList()))).stream().collect(Collectors.toMap(BaseEo::getId, Function.identity())));
            CompletableFuture<Map> levelMapFuture = CompletableFuture.supplyAsync(() -> this.customerLevelDas.getMapper().selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{BaseEo::getId, StdCustomerLevelEo::getName}).in(BaseEo::getId, (Collection)pageInfo.getList().stream().map(CustomerRespDto::getLevelId).distinct().collect(Collectors.toList()))).stream().collect(Collectors.toMap(BaseEo::getId, StdCustomerLevelEo::getName)));
            CompletableFuture<Map> regionNameMapFuture = CompletableFuture.supplyAsync(() -> {
                if (CollectionUtils.isEmpty((Collection)regionCodes)) {
                    return new HashMap(0);
                }
                CustomerAreaListReqDto customerAreaListReqDto = new CustomerAreaListReqDto();
                customerAreaListReqDto.setCodes(regionCodes);
                return this.customerAreaService.queryForList(customerAreaListReqDto).stream().collect(Collectors.toMap(CustomerAreaRespDto::getCode, CustomerAreaRespDto::getName, (o, o1) -> o));
            });
            CompletableFuture<Map> customerNameMapFuture = CompletableFuture.supplyAsync(() -> Optional.of(pageInfo.getList().stream().map(CustomerRespDto::getParentCustomerId).filter(Objects::nonNull).distinct().collect(Collectors.toList())).filter(org.apache.commons.collections.CollectionUtils::isNotEmpty).map(parentIds -> this.customerDas.queryListByIds(parentIds).stream().collect(Collectors.toMap(CustomerNameSimpleRespDto::getId, CustomerNameSimpleRespDto::getName))).orElse(new HashMap(0)));
            CompletableFuture<Map> groupNameMapFuture = CompletableFuture.supplyAsync(() -> {
                List groupIds = pageInfo.getList().stream().map(CustomerRespDto::getCustomerGroupId).distinct().collect(Collectors.toList());
                if (CollectionUtils.isEmpty(groupIds)) {
                    return new HashMap(0);
                }
                return this.customerGroupDas.selectByIds(groupIds).stream().collect(Collectors.toMap(BaseEo::getId, StdCustomerGroupEo::getGroupName));
            });
            CompletableFuture.allOf(customerNameMapFuture, levelMapFuture, statusMapFuture, typeMapFuture, groupNameMapFuture, regionNameMapFuture);
            Map customerNameMap = new HashMap(0);
            Map groupNameMap = new HashMap(0);
            Map regionNameMap = new HashMap(0);
            Map levelMap = new HashMap(0);
            Map statusMap = new HashMap(0);
            Map typeMap = new HashMap(0);
            try {
                regionNameMap = regionNameMapFuture.get();
                customerNameMap = customerNameMapFuture.get();
                groupNameMap = groupNameMapFuture.get();
                levelMap = levelMapFuture.get();
                statusMap = statusMapFuture.get();
                typeMap = typeMapFuture.get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            for (CustomerRespDto customerRespDto : pageInfo.getList()) {
                CustomerStatusEo statusEo = statusMap.getOrDefault(customerRespDto.getStatusId(), new CustomerStatusEo());
                customerRespDto.setAccountStatus(statusEo.getAccountStatus());
                customerRespDto.setRecordStatus(statusEo.getRecordStatus());
                customerRespDto.setStatusName(statusEo.getName());
                customerRespDto.setCustomerTypeName(typeMap.getOrDefault(customerRespDto.getCustomerTypeId(), ""));
                customerRespDto.setLevelName(levelMap.getOrDefault(customerRespDto.getLevelId(), ""));
                customerRespDto.setRegionCodes((String)idRegionCodeMap.get(customerRespDto.getId()));
                if (customerRespDto.getParentCustomerId() != null) {
                    customerRespDto.setParentCustomerName(customerNameMap.getOrDefault(customerRespDto.getParentCustomerId(), ""));
                }
                if (StatusEnum.ENABLED.getCode().equals(customerRespDto.getRecordStatus()) && StatusEnum.ENABLED.getCode().equals(customerRespDto.getAccountStatus())) {
                    customerRespDto.setValetFlag(StatusEnum.ENABLED.getCode());
                } else {
                    customerRespDto.setValetFlag(StatusEnum.DISABLED.getCode());
                }
                if (null != customerRespDto.getCustomerGroupId()) {
                    customerRespDto.setCustomerGroupName(groupNameMap.getOrDefault(customerRespDto.getCustomerGroupId(), ""));
                }
                if (!StringUtils.isNotEmpty((CharSequence)customerRespDto.getRegionCodes())) continue;
                ArrayList regionNameList = new ArrayList();
                for (String code : customerRespDto.getRegionCodes().split(",")) {
                    regionNameList.add(regionNameMap.get(code));
                }
                customerRespDto.setRegionNames(String.join((CharSequence)",", regionNameList));
            }
        }
        return pageInfo;
    }

    private void setMerchantIds(CustomerSearchReqDto searchReqDto, Long currentUserOrgId) {
        if (Objects.nonNull(searchReqDto.getChannel())) {
            ArrayList merchantIds = Lists.newArrayList();
            if (CustomerTypeEnum.BRAND.getCode().equals(searchReqDto.getChannel())) {
                List customerEos;
                if (CustomerTypeEnum.DEALER.getCode().equals(searchReqDto.getType())) {
                    merchantIds.add(currentUserOrgId);
                } else if (CustomerTypeEnum.RETAILER.getCode().equals(searchReqDto.getType()) && !CollectionUtils.isEmpty((Collection)(customerEos = this.customerDas.getMapper().selectList((Wrapper)new QueryWrapper().eq((Object)"merchant_id", (Object)currentUserOrgId))))) {
                    merchantIds.addAll(customerEos.stream().filter(bean -> null != bean.getOrgInfoId()).map(StdCustomerEo::getOrgInfoId).collect(Collectors.toList()));
                }
            } else if (CustomerTypeEnum.DEALER.getCode().equals(searchReqDto.getChannel()) && CustomerTypeEnum.RETAILER.getCode().equals(searchReqDto.getType())) {
                merchantIds.add(currentUserOrgId);
            }
            searchReqDto.setMerchantIds((List)merchantIds);
        } else {
            searchReqDto.setMerchantIds((List)com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList((Object[])new Long[]{currentUserOrgId}));
        }
    }

    @Override
    public List<Long> getCurrentUserOrOrgCustomer(Long userId, Long orgId, boolean filterOrg) {
        if (filterOrg && Objects.isNull(orgId)) {
            orgId = this.iCustomerExtService.getCurrentUserOrgId();
        }
        if (Objects.isNull(orgId) && Objects.isNull(userId)) {
            return com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
        }
        Set realSalesmanIds = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.customerSalesmanDas.filter(true).select(new String[]{"id"}).eq((Object)"status", (Object)1)).eq(Objects.nonNull(userId), (Object)"user_id", (Object)userId)).eq(Objects.nonNull(orgId), (Object)"org_info_id", (Object)orgId)).list().stream().map(BaseEo::getId).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(realSalesmanIds)) {
            return com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
        }
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.rCustomerSalesmanDas.filter(true).select(new String[]{"customer_id"}).in((Object)"real_salesman_id", realSalesmanIds)).eq(Objects.nonNull(orgId), (Object)"org_id", (Object)orgId)).list().stream().map(RCustomerSalesmanEo::getCustomerId).collect(Collectors.toList());
    }

    private List<Long> getDownstreamCustomerIdsByCurrentUser() {
        Long currentUserOrgId = this.iCustomerExtService.getCurrentUserOrgId();
        List<Long> longs = this.iCustomerExtService.queryDownstreamCustomerIdsByOrgIds(Collections.singletonList(currentUserOrgId));
        return new ArrayList<Long>(longs);
    }

    @Override
    public List<CustomerRespDto> queryByList(String filter) {
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            searchReqDto = (CustomerSearchReqDto)JSONObject.parseObject((String)filter, CustomerSearchReqDto.class);
        }
        if (!CollectionUtils.isEmpty((Collection)searchReqDto.getRegionCodes())) {
            RCustomerRegionEo selectEo = new RCustomerRegionEo();
            ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
            sqlFilters.add(SqlFilter.in((String)"region_code", (Object)StringUtils.join((Iterable)searchReqDto.getRegionCodes(), (String)",")));
            selectEo.setSqlFilters(sqlFilters);
            List customerRegionEos = this.rCustomerRegionDas.select((BaseEo)selectEo);
            Set customerIdList = customerRegionEos.stream().map(StdRCustomerRegionEo::getCustomerId).collect(Collectors.toSet());
            searchReqDto.setIdList(new ArrayList(customerIdList));
        }
        List customerList = this.customerDas.queryListBySearchCon(searchReqDto);
        return customerList;
    }

    @Override
    public void moveCustomerToRegion(String sourceRegionCode, String targetRegionCode) {
        RCustomerRegionEo sourceSelectEo = new RCustomerRegionEo();
        sourceSelectEo.setRegionCode(sourceRegionCode);
        List sourceRegionEos = this.rCustomerRegionDas.select((BaseEo)sourceSelectEo);
        if (CollectionUtils.isEmpty((Collection)sourceRegionEos)) {
            throw new CustomerBusinessRuntimeException(CustomerExceptionCode.REGION_NON_EXIST_CUSTOMER.getCode(), CustomerExceptionCode.REGION_NON_EXIST_CUSTOMER.getMsg());
        }
        RCustomerRegionEo targetSelectEo = new RCustomerRegionEo();
        targetSelectEo.setRegionCode(targetRegionCode);
        List targetRegionEos = this.rCustomerRegionDas.select((BaseEo)targetSelectEo);
        if (CollectionUtils.isEmpty((Collection)targetRegionEos)) {
            this.customerDas.updateCustomerByRegionCode(sourceRegionCode, targetRegionCode);
        } else {
            List sourceCustomerIds = sourceRegionEos.stream().map(StdRCustomerRegionEo::getCustomerId).collect(Collectors.toList());
            List targetCustomerIds = targetRegionEos.stream().map(StdRCustomerRegionEo::getCustomerId).collect(Collectors.toList());
            sourceCustomerIds.retainAll(targetCustomerIds);
            if (CollectionUtils.isEmpty(sourceCustomerIds)) {
                this.customerDas.updateCustomerByRegionCode(sourceRegionCode, targetRegionCode);
            } else {
                this.customerDas.updateByRegionCodeAndOutCustomerId(sourceRegionCode, targetRegionCode, sourceCustomerIds);
                RCustomerRegionEo deleteEo = new RCustomerRegionEo();
                ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
                sqlFilters.add(SqlFilter.in((String)"customer_id", (Object)StringUtils.join(sourceCustomerIds, (String)",")));
                deleteEo.setSqlFilters(sqlFilters);
                deleteEo.setRegionCode(sourceRegionCode);
                this.rCustomerRegionDas.delete((BaseEo)deleteEo);
            }
        }
    }

    private void validCustomerName(CustomerReqDto reqDto) {
        Assert.hasText((String)reqDto.getName(), (String)CustomerExceptionCode.NAME_NULL.getMsg());
        CustomerEo eo = CustomerEo.newInstance();
        eo.setName(reqDto.getName());
        eo.setTenantId(reqDto.getTenantId());
        List customerEos = this.customerDas.select((BaseEo)eo);
        if (reqDto.getId() == null && !CollectionUtils.isEmpty((Collection)customerEos)) {
            throw new CustomerBusinessRuntimeException(CustomerExceptionCode.NAME_EXISTS.getCode(), CustomerExceptionCode.NAME_EXISTS.getMsg() + "\u4e0d\u5141\u8bb8\u65b0\u589e");
        }
        if (reqDto.getId() != null && !CollectionUtils.isEmpty((Collection)customerEos) && !((CustomerEo)customerEos.get(0)).getId().equals(reqDto.getId())) {
            throw new CustomerBusinessRuntimeException(CustomerExceptionCode.NAME_EXISTS.getCode(), CustomerExceptionCode.NAME_EXISTS.getMsg() + "\u4e0d\u5141\u8bb8\u4fee\u6539");
        }
    }

    private void initCustomerEo(CustomerReqDto reqDto, CustomerEo customerEo) {
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)customerEo);
    }

    private void validCustomerCode(CustomerReqDto reqDto, Long tenantId) {
        if (Objects.nonNull(reqDto)) {
            Assert.hasText((String)reqDto.getCode(), (String)CustomerExceptionCode.CUSTOMER_CODE_NULL.getMsg());
            CustomerEo customerEo = CustomerEo.newInstance();
            customerEo.setTenantId(tenantId);
            customerEo.setCode(reqDto.getCode());
            customerEo = (CustomerEo)this.customerDas.selectOne((BaseEo)customerEo);
            if (customerEo != null) {
                if (reqDto.getId() == null) {
                    throw new CustomerBusinessRuntimeException(CustomerExceptionCode.CUSTOMER_CODE_EXISTS.getCode(), CustomerExceptionCode.CUSTOMER_CODE_EXISTS.getMsg() + reqDto.getCode());
                }
                if (reqDto.getId() != null && !customerEo.getId().equals(reqDto.getId())) {
                    throw new CustomerBusinessRuntimeException(CustomerExceptionCode.CUSTOMER_CODE_EXISTS.getCode(), CustomerExceptionCode.CUSTOMER_CODE_EXISTS.getMsg() + reqDto.getCode());
                }
            }
        }
    }

    @Override
    public Integer countByCustomerTypeId(Long customerTypeId) {
        return this.customerDas.countByCustomerTypeId(customerTypeId);
    }

    @Override
    public void updateCustomerTypeId(Long originCustomerTypeId, Long finalCustomerTypeId) {
        CustomerMapper mapper = (CustomerMapper)this.customerDas.getMapper();
        mapper.updateCustomerTypeId(originCustomerTypeId, finalCustomerTypeId);
    }

    @Override
    public PageInfo<CustomerTypeEo> queryCustomerTypeByPage(Integer pageNum, Integer pageSize) {
        if (pageNum == null) {
            pageNum = 1;
        }
        if (pageSize == null) {
            pageSize = 20;
        }
        CustomerTypeEo customerTypeEo = new CustomerTypeEo();
        customerTypeEo.setOrderBy("sort");
        return this.customerTypeDas.selectPage((BaseEo)customerTypeEo, pageNum, pageSize);
    }

    @Override
    @Transactional
    public void updateAccountStatus(CustomerReqDto customerReqDto) {
        CustomerEo customerEo = new CustomerEo();
        customerEo.setOrgInfoId(customerReqDto.getOrgInfoId());
        List customerEos = this.customerDas.select((BaseEo)customerEo);
        if (CollectionUtils.isEmpty((Collection)customerEos)) {
            throw new CustomerBusinessRuntimeException(CustomerExceptionCode.CUSTOMER_NON_EXIST.getCode(), CustomerExceptionCode.CUSTOMER_NON_EXIST.getMsg());
        }
        CustomerEo newCustomerEo = (CustomerEo)customerEos.get(0);
        newCustomerEo.setStatusId(customerReqDto.getStatusId());
        newCustomerEo.setUserId(null != customerReqDto.getUserId() ? customerReqDto.getUserId() : newCustomerEo.getUserId());
        this.customerDas.update((BaseEo)newCustomerEo);
    }

    @Override
    public void saveCustomerExportRecord(ExportRecordReqDto reqDto) {
        Assert.isTrue((reqDto != null ? 1 : 0) != 0, (String)"\u5ba2\u5546\u5bfc\u51fa\u8bb0\u5f55\u4e3a\u7a7a");
        reqDto.setTenantId(ServiceContext.getContext().getRequestTenantId());
        reqDto.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        CustomerExportRecordEo exportRecordEo = CustomerExportRecordEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)exportRecordEo);
        this.customerExportRecordDas.insert((BaseEo)exportRecordEo);
    }

    @Override
    public List<CustomerNameSimpleRespDto> queryListByIds(List<Long> ids) {
        return this.customerDas.queryListByIds(ids);
    }
}

