/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.customer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerStatusReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerStatusRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.exception.CustomerBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.customer.api.customer.exception.CustomerExceptionCode;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerStatusService;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerStatusDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerStatusEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service(value="customerStatusService")
public class CustomerStatusServiceImpl
implements ICustomerStatusService {
    @Resource
    private CustomerStatusDas customerStatusDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(CustomerStatusReqDto reqDto) {
        reqDto.setTenantId(ServiceContext.getContext().getRequestTenantId());
        reqDto.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        reqDto.setId(null);
        if (reqDto.getRecordStatus() == null) {
            reqDto.setRecordStatus(Integer.valueOf(1));
        }
        this.validCustomerStatusName(reqDto);
        this.validCustomerStatusCode(reqDto, reqDto.getTenantId());
        CustomerStatusEo customerStatusEo = CustomerStatusEo.newInstance();
        this.initCustomerStatusEo(reqDto, customerStatusEo);
        this.customerStatusDas.insert((BaseEo)customerStatusEo);
        return customerStatusEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateRecordStatus(Long id, Integer recordStatus) {
        CustomerStatusEo queryEo = (CustomerStatusEo)this.customerStatusDas.selectByPrimaryKey(id);
        Assert.notNull((Object)queryEo, (String)CustomerExceptionCode.CUSTOMER_STATUS_NON_EXIST.getMsg());
        CustomerStatusEo customerStatusEo = CustomerStatusEo.newInstance();
        customerStatusEo.setId(id);
        customerStatusEo.setRecordStatus(recordStatus);
        this.customerStatusDas.updateSelective((BaseEo)customerStatusEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(CustomerStatusReqDto reqDto) {
        reqDto.setTenantId(ServiceContext.getContext().getRequestTenantId());
        reqDto.setInstanceId(ServiceContext.getContext().getRequestInstanceId());
        Assert.notNull((Object)reqDto.getId(), (String)CustomerExceptionCode.PK_ID_NULL.getMsg());
        CustomerStatusEo queryEo = (CustomerStatusEo)this.customerStatusDas.selectByPrimaryKey(reqDto.getId());
        Assert.notNull((Object)queryEo, (String)CustomerExceptionCode.CUSTOMER_STATUS_NON_EXIST.getMsg());
        this.validCustomerStatusName(reqDto);
        this.validCustomerStatusCode(reqDto, reqDto.getTenantId());
        CustomerStatusEo customerStatusEo = CustomerStatusEo.newInstance();
        this.initCustomerStatusEo(reqDto, customerStatusEo);
        this.customerStatusDas.updateSelective((BaseEo)customerStatusEo);
    }

    @Override
    public CustomerStatusRespDto queryById(Long id) {
        CustomerStatusEo customerStatusEo = (CustomerStatusEo)this.customerStatusDas.selectByPrimaryKey(id);
        Assert.notNull((Object)customerStatusEo, (String)CustomerExceptionCode.CUSTOMER_STATUS_NON_EXIST.getMsg());
        CustomerStatusRespDto customerStatusRespDto = new CustomerStatusRespDto();
        DtoHelper.eo2Dto((BaseEo)customerStatusEo, (BaseVo)customerStatusRespDto);
        return customerStatusRespDto;
    }

    @Override
    public PageInfo<CustomerStatusRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CustomerStatusEo customerStatusEo = CustomerStatusEo.newInstance();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            CustomerStatusReqDto customerStatusReqDto = (CustomerStatusReqDto)JSONObject.parseObject((String)filter, CustomerStatusReqDto.class);
            DtoHelper.dto2Eo((BaseVo)customerStatusReqDto, (BaseEo)customerStatusEo);
        }
        customerStatusEo.setTenantId(ServiceContext.getContext().getRequestTenantId());
        PageInfo pageInfo = this.customerStatusDas.selectPage((BaseEo)customerStatusEo, pageNum, pageSize);
        PageInfo respDtoPageInfo = new PageInfo();
        ArrayList respDtoList = Lists.newArrayList();
        CubeBeanUtils.copyProperties((Object)respDtoPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        DtoHelper.eoList2DtoList((Collection)pageInfo.getList(), (Collection)respDtoList, CustomerStatusRespDto.class);
        respDtoPageInfo.setList((List)respDtoList);
        return respDtoPageInfo;
    }

    @Override
    public List<CustomerStatusRespDto> queryByList(String filter) {
        CustomerStatusEo customerStatusEo = CustomerStatusEo.newInstance();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            CustomerStatusReqDto customerStatusReqDto = (CustomerStatusReqDto)JSONObject.parseObject((String)filter, CustomerStatusReqDto.class);
            DtoHelper.dto2Eo((BaseVo)customerStatusReqDto, (BaseEo)customerStatusEo);
        }
        customerStatusEo.setTenantId(ServiceContext.getContext().getRequestTenantId());
        List customerStatusEoList = this.customerStatusDas.select((BaseEo)customerStatusEo);
        ArrayList respDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)customerStatusEoList, (Collection)respDtoList, CustomerStatusRespDto.class);
        return respDtoList;
    }

    private void validCustomerStatusName(CustomerStatusReqDto reqDto) {
        Assert.hasText((String)reqDto.getName(), (String)CustomerExceptionCode.NAME_NULL.getMsg());
        CustomerStatusEo eo = CustomerStatusEo.newInstance();
        eo.setName(reqDto.getName());
        eo.setTenantId(reqDto.getTenantId());
        if (reqDto.getId() == null) {
            if (this.customerStatusDas.count((BaseEo)eo) > 0) {
                throw new CustomerBusinessRuntimeException(CustomerExceptionCode.NAME_EXISTS.getCode(), CustomerExceptionCode.NAME_EXISTS.getMsg() + "\u4e0d\u5141\u8bb8\u65b0\u589e");
            }
        } else {
            Long supplierId = reqDto.getId();
            List customerStatusEos = this.customerStatusDas.select((BaseEo)eo);
            if (!CollectionUtils.isEmpty((Collection)customerStatusEos)) {
                if (customerStatusEos.size() == 1) {
                    if (!((CustomerStatusEo)customerStatusEos.get(0)).getId().equals(supplierId)) {
                        throw new CustomerBusinessRuntimeException(CustomerExceptionCode.NAME_EXISTS.getCode(), CustomerExceptionCode.NAME_EXISTS.getMsg() + "\u4e0d\u5141\u8bb8\u4fee\u6539");
                    }
                } else {
                    throw new CustomerBusinessRuntimeException(CustomerExceptionCode.NAME_EXISTS.getCode(), CustomerExceptionCode.NAME_EXISTS.getMsg() + "\u4e0d\u5141\u8bb8\u4fee\u6539");
                }
            }
        }
    }

    private void initCustomerStatusEo(CustomerStatusReqDto reqDto, CustomerStatusEo customerStatusEo) {
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)customerStatusEo);
    }

    private void validCustomerStatusCode(CustomerStatusReqDto reqDto, Long tenantId) {
        if (Objects.nonNull(reqDto)) {
            Assert.hasText((String)reqDto.getCode(), (String)CustomerExceptionCode.CUSTOMER_STATUS_CODE_NULL.getMsg());
            CustomerStatusEo customerStatusEo = CustomerStatusEo.newInstance();
            customerStatusEo.setTenantId(tenantId);
            customerStatusEo.setCode(reqDto.getCode());
            customerStatusEo = (CustomerStatusEo)this.customerStatusDas.selectOne((BaseEo)customerStatusEo);
            if (customerStatusEo != null) {
                if (reqDto.getId() == null) {
                    throw new CustomerBusinessRuntimeException(CustomerExceptionCode.CUSTOMER_STATUS_CODE_EXISTS.getCode(), CustomerExceptionCode.CUSTOMER_CODE_EXISTS.getMsg() + reqDto.getCode());
                }
                if (reqDto.getId() != null && !customerStatusEo.getId().equals(reqDto.getId())) {
                    throw new CustomerBusinessRuntimeException(CustomerExceptionCode.CUSTOMER_STATUS_CODE_EXISTS.getCode(), CustomerExceptionCode.CUSTOMER_CODE_EXISTS.getMsg() + reqDto.getCode());
                }
            }
        }
    }
}

