/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.svr.rest.customer;

import cn.hutool.core.util.StrUtil;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.IAddressApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.AddressAddReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.AddressModifyReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.AddressQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.AddressRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.IAddressQueryApi;
import com.github.pagehelper.PageInfo;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/address"})
public class AddressRest
implements IAddressApi,
IAddressQueryApi {
    @Resource
    private IAddressApi addressApi;
    @Resource
    private IAddressQueryApi addressQueryApi;

    public RestResponse<Long> addAddress(@Valid @RequestBody AddressAddReqDto reqDto) {
        String addressType = reqDto.getAddressType();
        if (StrUtil.isNotBlank((CharSequence)addressType)) {
            String[] addressTypes;
            String[] stringArray = addressTypes = addressType.split(",");
            int n = addressTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                reqDto.setAddressType(type);
                this.addressApi.addAddress(reqDto);
                ++n2;
            }
        }
        return RestResponse.createLong((Long)0L);
    }

    public RestResponse<Void> modifyAddress(@Valid @RequestBody AddressModifyReqDto reqDto) {
        return this.addressApi.modifyAddress(reqDto);
    }

    public RestResponse<Void> removeAddress(@PathVariable(value="id") Long id) {
        return this.addressApi.removeAddress(id);
    }

    public RestResponse<AddressRespDto> queryAddressById(@PathVariable(value="id") Long id) {
        return this.addressQueryApi.queryAddressById(id);
    }

    public RestResponse<PageInfo<AddressRespDto>> queryAddressByPage(@SpringQueryMap AddressQueryReqDto reqDto, @RequestParam(name="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize) {
        return this.addressQueryApi.queryAddressByPage(reqDto, pageNum, pageSize);
    }
}

