/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.mkld;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.biz.commons.utils.ExecutorUtils;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.GovernStatusEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.GovernTypeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreGovernAllotReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerGovernContentRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerGovernRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerGovernService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerRelateService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.adapter.AbstractStoreSellerGovernContentServiceImpl;
import com.dtyunxi.yundt.cube.center.customer.dao.das.StoreDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.StoreSellerGovernContentDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.StoreEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.StoreSellerGovernContentEo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerExtQueryApi;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="mkld_IStoreSellerGovernContentService")
public class MkldStoreSellerGovernContentServiceImpl
extends AbstractStoreSellerGovernContentServiceImpl {
    private Logger logger = LoggerFactory.getLogger(MkldStoreSellerGovernContentServiceImpl.class);
    @Resource
    private StoreSellerGovernContentDas storeSellerGovernContentDas;
    @Resource
    private StoreDas storeDas;
    @Resource
    private ISellerExtQueryApi sellerExtQueryApi;
    @Resource(name="${yunxi.dg.base.project}_IStoreSellerGovernService")
    private IStoreSellerGovernService storeSellerGovernService;
    @Resource(name="${yunxi.dg.base.project}_IStoreSellerRelateService")
    private IStoreSellerRelateService storeSellerRelateService;

    @Override
    public void updateStoreSellerGovernStoreParent(StoreGovernAllotReqDto reqDto) {
        if (ObjectUtils.isEmpty((Object)reqDto.getId()) || reqDto.getStoreParentIds() == null) {
            throw new BizException("-1", "id\u3001storeIds\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.verifyRelateStatus(reqDto);
        StoreSellerGovernRespDto storeSellerGovern = this.storeSellerGovernService.queryStoreSellerGovernByID(reqDto.getId(), null);
        if (ObjectUtils.isEmpty((Object)storeSellerGovern)) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u8be5\u5546\u5bb6\u7ba1\u8f96\u5206\u914d\u4fe1\u606f");
        }
        this.deleteStoreGovernContent(storeSellerGovern.getId(), GovernTypeEnum.STOREPARENT.getCode());
        this.dealStoreGovernContent(storeSellerGovern, reqDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateStoreSellerGovernBlacklist(StoreGovernAllotReqDto reqDto) {
        if (ObjectUtils.isEmpty((Object)reqDto.getId()) || reqDto.getBlacklistIds() == null) {
            throw new BizException("-1", "id\u3001blacklistIds\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.verifyRelateStatus(reqDto);
        StoreSellerGovernRespDto storeSellerGovern = this.storeSellerGovernService.queryStoreSellerGovernByID(reqDto.getId(), null);
        if (ObjectUtils.isEmpty((Object)storeSellerGovern)) {
            throw new BizException("-1", "\u627e\u4e0d\u5230\u8be5\u5546\u5bb6\u7ba1\u8f96\u5206\u914d\u4fe1\u606f");
        }
        this.deleteStoreGovernContent(storeSellerGovern.getId(), GovernTypeEnum.BLACKLIST.getCode());
        this.dealStoreGovernContent(storeSellerGovern, reqDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void dealStoreGovernContent(StoreSellerGovernRespDto storeSellerGovern, StoreGovernAllotReqDto governContent) {
        this.logger.info("\u5904\u7406\u5546\u5bb6\u836f\u5e97\u7ba1\u8f96\u5206\u914d\u5185\u5bb9\uff1a{}==={}", (Object)JSON.toJSONString((Object)storeSellerGovern), (Object)JSON.toJSONString((Object)governContent));
        if (ObjectUtils.isEmpty((Object)storeSellerGovern) || ObjectUtils.isEmpty((Object)governContent)) {
            throw new BizException("-1", "\u53c2\u6570\u8bf7\u6c42\u5f02\u5e38");
        }
        ArrayList insertGovernContentList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)governContent.getAreas())) {
            governContent.getAreas().forEach(area -> {
                StoreSellerGovernContentEo eo = new StoreSellerGovernContentEo();
                eo.setStoreSellerId(storeSellerGovern.getId());
                eo.setOrganizationId(storeSellerGovern.getOrganizationId());
                eo.setGovernType(GovernTypeEnum.AREA.getCode());
                eo.setGovernContent(area);
                insertGovernContentList.add(eo);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)governContent.getStoreIds())) {
            governContent.getStoreIds().forEach(store -> {
                StoreSellerGovernContentEo eo = new StoreSellerGovernContentEo();
                eo.setStoreSellerId(storeSellerGovern.getId());
                eo.setOrganizationId(storeSellerGovern.getOrganizationId());
                eo.setGovernType(GovernTypeEnum.STORE.getCode());
                eo.setGovernContent(store);
                insertGovernContentList.add(eo);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)governContent.getStoreParentIds())) {
            StoreEo storeEo = new StoreEo();
            storeEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"store_id", (Object)governContent.getStoreParentIds())}));
            List storeEos = this.storeDas.select((BaseEo)storeEo);
            Assert.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)storeEos), (String)"0001", (String)"\u5f53\u524d\u4e0a\u4f20\u7236\u7ea7\u836f\u5e97\u4e0d\u5b58\u5728\uff01\uff01\uff01");
            StoreEo storeChild = new StoreEo();
            List creditNum = storeEos.stream().map(c -> c.getSocialCreditNum()).collect(Collectors.toList());
            storeChild.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"parent_social_credit_num", creditNum)}));
            List storeChildren = this.storeDas.select((BaseEo)storeChild);
            Assert.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)storeChildren), (String)"0001", (String)"\u5f53\u524d\u4e0a\u4f20\u7236\u7ea7\u836f\u5e97\u4e0d\u5b58\u5728\u4e0b\u7ea7\u95e8\u5e97\uff01\uff01\uff01");
            governContent.getStoreParentIds().forEach(store -> {
                StoreSellerGovernContentEo eo = new StoreSellerGovernContentEo();
                eo.setStoreSellerId(storeSellerGovern.getId());
                eo.setOrganizationId(storeSellerGovern.getOrganizationId());
                eo.setGovernType(GovernTypeEnum.STOREPARENT.getCode());
                eo.setGovernContent(store);
                insertGovernContentList.add(eo);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)governContent.getBlacklistIds())) {
            governContent.getBlacklistIds().forEach(store -> {
                StoreSellerGovernContentEo eo = new StoreSellerGovernContentEo();
                eo.setStoreSellerId(storeSellerGovern.getId());
                eo.setOrganizationId(storeSellerGovern.getOrganizationId());
                eo.setGovernType(GovernTypeEnum.BLACKLIST.getCode());
                eo.setGovernContent(store);
                insertGovernContentList.add(eo);
            });
        }
        if (CollectionUtils.isNotEmpty(insertGovernContentList)) {
            this.storeSellerGovernContentDas.insertBatch(insertGovernContentList);
        }
        this.logger.info("\u7ba1\u8f96\u5185\u5bb9\u5904\u7406\u5b8c\u6210\uff0c\u51c6\u5907\u6784\u5efa\u5173\u8054\u6570\u636e");
        this.storeSellerGovernService.changeStoreSellerGovernStatus(storeSellerGovern.getSellerId(), storeSellerGovern.getOrganizationId(), GovernStatusEnum.DEAL);
        ExecutorUtils.execute(() -> {
            this.logger.info("\u5f02\u6b65\u6267\u884c");
            this.storeSellerRelateService.buildStoreSellerRelate(storeSellerGovern.getSellerId(), storeSellerGovern.getOrganizationId());
        });
    }

    @Override
    public List<String> queryGovernContentListByOrgId(Long orgId) {
        SellerRespDto sellerRespDto = (SellerRespDto)RestResponseHelper.extractData((RestResponse)this.sellerExtQueryApi.querySellerByOrganizationId(orgId));
        if (null == sellerRespDto) {
            throw new BizException("-1", "\u6839\u636e\u5927B\u7ec4\u7ec7id: " + orgId + "\u83b7\u53d6\u5546\u5bb6\u4fe1\u606f\u4e3a\u7a7a");
        }
        List storeSellerGovernContentRespDtos = this.storeSellerGovernContentDas.queryGovernContentList(sellerRespDto.getId());
        ArrayList<String> storeIds = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)storeSellerGovernContentRespDtos)) {
            Map<String, List<StoreSellerGovernContentRespDto>> storeSellerGovernContentMap = storeSellerGovernContentRespDtos.stream().collect(Collectors.groupingBy(e -> e.getGovernType()));
            List<StoreSellerGovernContentRespDto> areaType = storeSellerGovernContentMap.get("AREA");
            if (CollectionUtils.isNotEmpty(areaType)) {
                ArrayList governContentArea = new ArrayList();
                areaType.forEach(e -> governContentArea.add(e.getGovernContent()));
                List storeIdList = this.storeDas.queryStoreIdByArea(governContentArea);
                if (CollectionUtils.isNotEmpty((Collection)storeIdList)) {
                    storeIds.addAll(storeIdList);
                }
            }
            this.logger.info("\u7ba1\u8f96\u533a\u57df\u7c7b\u578b\u836f\u5e97\u673a\u6784id\uff0c{}", storeIds);
            List<StoreSellerGovernContentRespDto> storeType = storeSellerGovernContentMap.get("STORE");
            if (CollectionUtils.isNotEmpty(storeType)) {
                storeType.forEach(e -> storeIds.add(e.getGovernContent()));
            }
            this.logger.info("\u7ba1\u8f96\u533a\u57df\u548c\u5e97\u94fa\u7c7b\u578b\u836f\u5e97\u673a\u6784id\uff0c{}", storeIds);
            List<StoreSellerGovernContentRespDto> blackType = storeSellerGovernContentMap.get("BLACKLIST");
            if (CollectionUtils.isNotEmpty(blackType)) {
                ArrayList blackStoreIds = new ArrayList();
                blackType.forEach(e -> blackStoreIds.add(e.getGovernContent()));
                storeIds.removeAll(blackStoreIds);
                this.logger.info("\u7ba1\u8f96\u9ed1\u540d\u5355\u7c7b\u578b\u836f\u5e97\u673a\u6784id\uff0c{}", blackStoreIds);
            }
        }
        this.logger.info("\u6700\u7ec8\u8fd4\u56de\u836f\u5e97\u673a\u6784id\uff0c{}", storeIds);
        return storeIds;
    }
}

