/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.mkld;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreCategoryCodeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.UpdateStoreSellerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreCategoryCodeRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.adapter.AbstractStoreSellerServiceImpl;
import com.dtyunxi.yundt.cube.center.customer.dao.das.StoreSellerDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.StoreSellerEo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerExtQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="mkld_IStoreSellerService")
public class MkldStoreSellerServiceImpl
extends AbstractStoreSellerServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(MkldStoreSellerServiceImpl.class);
    @Resource
    private StoreSellerDas storeSellerDas;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IContext context;
    @Resource
    private ISellerExtQueryApi sellerExtQueryApi;

    @Override
    public void batchUpdateStoreSeller(UpdateStoreSellerReqDto reqDto) {
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()));
        logger.info("\u6279\u91cf\u4fee\u6539\u5546\u5bb6\u836f\u5e97\u5173\u7cfb \u5f53\u524d\u5927B\u7ec4\u7ec7id\uff0c{}", (Object)orgId);
        SellerRespDto sellerRespDto = (SellerRespDto)RestResponseHelper.extractData((RestResponse)this.sellerExtQueryApi.querySellerByOrganizationId(orgId));
        if (null == sellerRespDto) {
            throw new BizException("-1", "\u6839\u636e\u5927B\u7ec4\u7ec7id: " + orgId + "\u83b7\u53d6\u5546\u5bb6\u4fe1\u606f\u4e3a\u7a7a");
        }
        StoreSellerEo selectEo = new StoreSellerEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"store_id", (Object)reqDto.getStoreIds()));
        sqlFilters.add(SqlFilter.eq((String)"seller_id", (Object)sellerRespDto.getId()));
        selectEo.setSqlFilters(sqlFilters);
        List storeSellerEoList = this.storeSellerDas.select((BaseEo)selectEo);
        HashMap storeSellerMap = CollectionUtils.isNotEmpty((Collection)storeSellerEoList) ? storeSellerEoList.stream().collect(Collectors.toMap(e -> e.getStoreId(), e -> e, (e1, e2) -> e1)) : new HashMap();
        String brands = null;
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getBrandCodes())) {
            brands = reqDto.getBrandCodes().stream().distinct().collect(Collectors.joining(";"));
        }
        ArrayList<StoreSellerEo> addStoreSeller = new ArrayList<StoreSellerEo>();
        ArrayList<StoreSellerEo> updateStoreSeller = new ArrayList<StoreSellerEo>();
        StoreSellerEo storeSellerEo = null;
        for (String storeId : reqDto.getStoreIds()) {
            if (storeSellerMap.containsKey(storeId)) {
                StoreSellerEo storeSeller = (StoreSellerEo)storeSellerMap.get(storeId);
                if (null != reqDto.getIfSupply()) {
                    storeSeller.setIfSupply(reqDto.getIfSupply());
                } else if (ObjectUtils.isNotEmpty((Object)reqDto.getParentDistributionId()) && StringUtils.isNotBlank((CharSequence)reqDto.getParentDistributionCode())) {
                    storeSeller.setParentDistributionId(reqDto.getParentDistributionId());
                    storeSeller.setParentDistributionCode(reqDto.getParentDistributionCode());
                } else if (StringUtils.isNotBlank((CharSequence)brands)) {
                    storeSeller.setBrand(brands);
                } else if (StringUtils.isNotBlank((CharSequence)reqDto.getStoreCategoryCode())) {
                    storeSeller.setStoreCategoryCode(reqDto.getStoreCategoryCode());
                }
                storeSeller.setUpdateTime(null);
                updateStoreSeller.add(storeSeller);
                continue;
            }
            storeSellerEo = new StoreSellerEo();
            storeSellerEo.setSellerId(sellerRespDto.getId());
            storeSellerEo.setStoreId(storeId);
            storeSellerEo.setIfSupply(Integer.valueOf(0));
            storeSellerEo.setDr(0);
            if (null != reqDto.getIfSupply()) {
                storeSellerEo.setIfSupply(reqDto.getIfSupply());
            } else if (ObjectUtils.isNotEmpty((Object)reqDto.getParentDistributionId()) && StringUtils.isNotBlank((CharSequence)reqDto.getParentDistributionCode())) {
                storeSellerEo.setParentDistributionId(reqDto.getParentDistributionId());
                storeSellerEo.setParentDistributionCode(reqDto.getParentDistributionCode());
            } else if (StringUtils.isNotBlank((CharSequence)reqDto.getStoreCategoryCode())) {
                storeSellerEo.setStoreCategoryCode(reqDto.getStoreCategoryCode());
            } else if (StringUtils.isNotBlank((CharSequence)brands)) {
                storeSellerEo.setBrand(brands);
            }
            addStoreSeller.add(storeSellerEo);
        }
        if (CollectionUtils.isNotEmpty(addStoreSeller)) {
            logger.info("\u6279\u91cf\u65b0\u589e\u5546\u5bb6\u836f\u5e97\u6570\u636e\uff0c{}", (Object)JSONObject.toJSONString(addStoreSeller));
            this.storeSellerDas.insertBatch(addStoreSeller);
        }
        if (CollectionUtils.isNotEmpty(updateStoreSeller)) {
            logger.info("\u6279\u91cf\u4fee\u6539\u5546\u5bb6\u836f\u5e97\u6570\u636e\uff0c{}", (Object)JSONObject.toJSONString(updateStoreSeller));
            for (StoreSellerEo sellerEo : updateStoreSeller) {
                this.storeSellerDas.updateSelective((BaseEo)sellerEo);
            }
        }
    }

    @Override
    public List<StoreCategoryCodeRespDto> queryStoreCategory() {
        StoreCategoryCodeEnum[] values = StoreCategoryCodeEnum.values();
        ArrayList<StoreCategoryCodeRespDto> list = new ArrayList<StoreCategoryCodeRespDto>();
        for (StoreCategoryCodeEnum storeCategory : values) {
            StoreCategoryCodeRespDto respDto = new StoreCategoryCodeRespDto();
            respDto.setCode(storeCategory.getCode());
            respDto.setName(storeCategory.getName());
            list.add(respDto);
        }
        return list;
    }
}

