/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.mkld;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.exception.CustomerBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.customer.api.customer.exception.CustomerExceptionCode;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.impl.CustomerServiceImpl;
import com.dtyunxi.yundt.cube.center.customer.biz.service.adapter.AbstractCustomerServiceImpl;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerStatusDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerTypeDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.RCustomerRegionDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerStatusEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerTypeEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.RCustomerRegionEo;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationInfoDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.response.OrgAndOrgInfoRespDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service(value="mkld_IPjCustomerService")
public class MkldCustomerServiceImpl
extends AbstractCustomerServiceImpl {
    private Logger logger = LoggerFactory.getLogger(CustomerServiceImpl.class);
    @Resource
    private CustomerDas customerDas;
    @Resource
    private CustomerTypeDas customerTypeDas;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private CustomerStatusDas customerStatusDas;
    @Resource
    private RCustomerRegionDas rCustomerRegionDas;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;

    @Override
    public Long add(CustomerReqDto reqDto) {
        OrganizationInfoDto organizationInfoDto;
        reqDto.setId((Long)null);
        this.validCustomerCode(reqDto, reqDto.getTenantId());
        CustomerEo customerEo = CustomerEo.newInstance();
        this.initCustomerEo(reqDto, customerEo);
        RestResponse listRestResponse = this.organizationQueryApi.queryOrgAndOrgInfoByIds((List)Lists.newArrayList((Object[])new Long[]{reqDto.getOrgInfoId()}));
        if (!CollectionUtils.isEmpty((Collection)((Collection)listRestResponse.getData())) && (organizationInfoDto = ((OrgAndOrgInfoRespDto)((List)listRestResponse.getData()).get(0)).getOrganizationInfoDto()) != null && StringUtils.isNotEmpty((CharSequence)organizationInfoDto.getCreditCode())) {
            customerEo.setIfCertification(Integer.valueOf(1));
        }
        Long id = this.customerDas.insertById(customerEo);
        if (!CollectionUtils.isEmpty((Collection)reqDto.getRegionCodeList())) {
            ArrayList<RCustomerRegionEo> customerRegionEos = new ArrayList<RCustomerRegionEo>(reqDto.getRegionCodeList().size());
            for (String regionCode : reqDto.getRegionCodeList()) {
                RCustomerRegionEo customerRegionEo = new RCustomerRegionEo();
                customerRegionEo.setCustomerId(id);
                customerRegionEo.setRegionCode(regionCode);
                customerRegionEos.add(customerRegionEo);
            }
            this.rCustomerRegionDas.insertBatch(customerRegionEos);
        }
        return id;
    }

    @Override
    public void update(CustomerReqDto reqDto) {
        Assert.notNull((Object)reqDto.getId(), (String)CustomerExceptionCode.PK_ID_NULL.getMsg());
        CustomerEo queryEo = (CustomerEo)this.customerDas.selectByPrimaryKey(reqDto.getId());
        Assert.notNull((Object)queryEo, (String)CustomerExceptionCode.CUSTOMER_NON_EXIST.getMsg());
        this.validCustomerCode(reqDto, reqDto.getTenantId());
        if (Objects.isNull(queryEo.getIfCertification())) {
            reqDto.setIfCertification(Integer.valueOf(0));
        }
        CustomerEo customerEo = CustomerEo.newInstance();
        this.initCustomerEo(reqDto, customerEo);
        customerEo.setCode(queryEo.getCode());
        this.customerDas.updateSelective((BaseEo)customerEo);
        RCustomerRegionEo deleteEo = new RCustomerRegionEo();
        deleteEo.setCustomerId(reqDto.getId());
        this.rCustomerRegionDas.delete((BaseEo)deleteEo);
        if (!CollectionUtils.isEmpty((Collection)reqDto.getRegionCodeList())) {
            ArrayList<RCustomerRegionEo> customerRegionEos = new ArrayList<RCustomerRegionEo>(reqDto.getRegionCodeList().size());
            for (String regionCode : reqDto.getRegionCodeList()) {
                RCustomerRegionEo customerRegionEo = new RCustomerRegionEo();
                customerRegionEo.setCustomerId(reqDto.getId());
                customerRegionEo.setRegionCode(regionCode);
                customerRegionEos.add(customerRegionEo);
            }
            this.rCustomerRegionDas.insertBatch(customerRegionEos);
        }
        CubeBeanUtils.copyProperties((Object)queryEo, (Object)customerEo, (String[])new String[0]);
        String regionCodes = StringUtils.join((Iterable)reqDto.getRegionCodeList(), (String)",");
        String regionNames = StringUtils.join((Iterable)reqDto.getRegionNameList(), (String)",");
        this.sendMq(queryEo, regionNames, regionCodes);
    }

    private void initCustomerEo(CustomerReqDto reqDto, CustomerEo customerEo) {
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)customerEo);
    }

    private void validCustomerCode(CustomerReqDto reqDto, Long tenantId) {
        if (Objects.nonNull(reqDto)) {
            Assert.hasText((String)reqDto.getCode(), (String)CustomerExceptionCode.CUSTOMER_CODE_NULL.getMsg());
            CustomerEo customerEo = CustomerEo.newInstance();
            customerEo.setTenantId(tenantId);
            customerEo.setCode(reqDto.getCode());
            customerEo = (CustomerEo)this.customerDas.selectOne((BaseEo)customerEo);
            if (customerEo != null) {
                if (reqDto.getId() == null) {
                    throw new CustomerBusinessRuntimeException(CustomerExceptionCode.CUSTOMER_CODE_EXISTS.getCode(), CustomerExceptionCode.CUSTOMER_CODE_EXISTS.getMsg() + reqDto.getCode());
                }
                if (reqDto.getId() != null && !customerEo.getId().equals(reqDto.getId())) {
                    throw new CustomerBusinessRuntimeException(CustomerExceptionCode.CUSTOMER_CODE_EXISTS.getCode(), CustomerExceptionCode.CUSTOMER_CODE_EXISTS.getMsg() + reqDto.getCode());
                }
            }
        }
    }

    @Override
    public void sendMq(CustomerEo customerEo, String regionNames, String regionCodes) {
        CustomerRespDto customerRespDto = new CustomerRespDto();
        this.logger.info("\u53d1\u9001mq\u5f53\u524d\u7c7b=CustomerServiceImpl.sendMq()customerEo = [" + customerEo + "], regionNames = [" + regionNames + "], regionNames = [" + regionCodes + "]");
        try {
            if (customerEo.getCustomerTypeId() != null) {
                CustomerTypeEo customerTypeEo = (CustomerTypeEo)this.customerTypeDas.selectByPrimaryKey(customerEo.getCustomerTypeId());
                customerRespDto.setCustomerTypeName(customerTypeEo.getName());
            }
            if (customerEo.getStatusId() != null) {
                CustomerStatusEo customerStatusEo = (CustomerStatusEo)this.customerStatusDas.selectByPrimaryKey(customerEo.getStatusId());
                customerRespDto.setStatusName(customerStatusEo.getName());
            }
            customerRespDto.setStatusId(customerEo.getStatusId());
            customerRespDto.setId(customerEo.getId());
            customerRespDto.setCode(customerEo.getCode());
            customerRespDto.setName(customerEo.getName());
            customerRespDto.setRegionId(customerEo.getRegionId());
            customerRespDto.setRegionCode(regionCodes);
            customerRespDto.setRegion(regionNames);
            customerRespDto.setCustomerTypeId(customerEo.getCustomerTypeId());
            customerRespDto.setCustomerId(customerEo.getId());
            customerRespDto.setId(customerEo.getId());
            this.commonsMqService.sendSingleMessage("CUSTOMER_UPDATE", (Object)customerRespDto);
            this.commonsMqService.publishMessageAsync("CUSTOMER_UPDATE_PUBLISH", (Object)JSON.toJSONString((Object)customerRespDto));
        }
        catch (Exception var6) {
            this.logger.debug(var6.getMessage());
        }
    }
}

