/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.customer.biz.service.adapter;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.biz.commons.utils.ExecutorUtils;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.huieryun.core.util.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreAreaLevelEnum;
import com.dtyunxi.yundt.cube.center.customer.api.constants.StoreCategoryCodeEnum;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.IfSupplyEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreSellerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreAreaRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerGovernExcelRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.proxy.report.IStoreSearchQueryApi;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreAreaService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerGovernContentService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerRelateService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerService;
import com.dtyunxi.yundt.cube.center.customer.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.yundt.cube.center.customer.biz.vo.StoreExcelVo;
import com.dtyunxi.yundt.cube.center.customer.dao.das.StoreDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.StoreEo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yx.tcbj.center.customer.api.dto.request.CompanyCheckReqDto;
import com.yx.tcbj.center.customer.api.dto.request.store.StoreReqDto;
import com.yx.tcbj.center.customer.api.dto.request.store.StoreSearchReqDto;
import com.yx.tcbj.center.customer.api.dto.response.StoreSearchRespDto;
import com.yx.tcbj.center.customer.api.dto.response.store.StoreRespDto;
import com.yx.tcbj.center.customer.biz.service.ICustomerQueryService;
import com.yx.tcbj.center.customer.biz.service.IStoreService;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.web.multipart.MultipartFile;

public abstract class AbstractStoreServiceImpl
implements IStoreService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractStoreServiceImpl.class);
    @Resource
    private StoreDas storeDas;
    @Resource(name="${yunxi.dg.base.project}_IStoreSellerGovernContentService")
    private IStoreSellerGovernContentService storeSellerGovernContentService;
    @Resource
    private IStoreSearchQueryApi storeSearchQueryApi;
    @Resource(name="${yunxi.dg.base.project}_IStoreAreaService")
    private IStoreAreaService storeAreaService;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IContext context;
    @Resource
    private ISellerQueryApi iSellerQueryApi;
    @Resource(name="${yunxi.dg.base.project}_IStoreSellerService")
    private IStoreSellerService storeSellerService;
    @Resource(name="${yunxi.dg.base.project}_ICustomerQueryService")
    private ICustomerQueryService customerQueryService;
    @Resource(name="${yunxi.dg.base.project}_IStoreSellerRelateService")
    private IStoreSellerRelateService storeSellerRelateService;
    @Resource
    private ISellerExtQueryApi sellerExtQueryApi;

    @Override
    public List<StoreRespDto> queryByStoreName(String storeName) {
        StoreEo storeEo = new StoreEo();
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.like((String)"store_name", (Object)("%" + storeName + "%")));
        storeEo.setSqlFilters((List)sqlFilters);
        List stores = this.storeDas.select((BaseEo)storeEo);
        ArrayList storeRespDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)stores, (Collection)storeRespDtos, StoreRespDto.class);
        return storeRespDtos;
    }

    @Override
    public PageInfo<StoreRespDto> queryPageByStoreName(String storeName, Integer pageNum, Integer pageSize) {
        PageInfo storeRespDtoPageInfo = this.storeDas.queryPageByStoreName(storeName, Integer.valueOf(1), Integer.valueOf(20));
        return storeRespDtoPageInfo;
    }

    @Override
    public List<StoreRespDto> queryStoreCheck(CompanyCheckReqDto reqDto) {
        Assert.notNull((Object)reqDto.getCode(), (String)"\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)reqDto.getName(), (String)"\u516c\u53f8\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)reqDto.getLegalPersonName(), (String)"\u6cd5\u4eba\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        StoreEo storeEo = new StoreEo();
        storeEo.setSocialCreditNum(reqDto.getCode());
        storeEo.setStoreName(reqDto.getName());
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getLegalPersonName())) {
            storeEo.setStoreName(reqDto.getLegalPersonName());
        }
        List storeEos = this.storeDas.select((BaseEo)storeEo);
        ArrayList dtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)storeEos, (Collection)dtoList, StoreRespDto.class);
        return dtoList;
    }

    @Override
    public void addStoreBatch(List<StoreReqDto> reqDtos) {
        ArrayList storeEos = Lists.newArrayList();
        DtoHelper.dtoList2EoList(reqDtos, (Collection)storeEos, StoreEo.class);
        this.storeDas.insertBatch((List)storeEos);
    }

    @Override
    public void addStore(StoreReqDto reqDtos) {
    }

    @Override
    public List<StoreRespDto> querySocialCreditNums(List<String> socialCreditNums) {
        StoreEo storeEo = new StoreEo();
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"social_credit_num", socialCreditNums));
        storeEo.setSqlFilters((List)sqlFilters);
        List storeEos = this.storeDas.select((BaseEo)storeEo);
        ArrayList storeRespDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)storeEos, (Collection)storeRespDtos, StoreRespDto.class);
        return storeRespDtos;
    }

    @Override
    public void updateStoreBatch(List<StoreReqDto> reqDtos) {
        ArrayList storeEos = Lists.newArrayList();
        DtoHelper.dtoList2EoList(reqDtos, (Collection)storeEos, StoreEo.class);
        this.storeDas.updateBatchNew((List)storeEos);
    }

    @Override
    public void updateStore(StoreReqDto reqDto) {
        StoreEo storeEo = new StoreEo();
        BeanUtils.copyProperties((Object)reqDto, (Object)storeEo);
        ArrayList sqlFilters = Lists.newArrayList();
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getSocialCreditNum())) {
            sqlFilters.add(SqlFilter.eq((String)"social_credit_num", (Object)reqDto.getSocialCreditNum()));
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getStoreId())) {
            sqlFilters.add(SqlFilter.eq((String)"store_id", (Object)reqDto.getStoreId()));
        }
        if (CollectionUtils.isEmpty((Collection)sqlFilters)) {
            throw new BizException("\u6ca1\u6709\u4fee\u6539\u7684\u6761\u4ef6");
        }
        storeEo.setSqlFilters((List)sqlFilters);
        this.storeDas.updateSelectiveSqlFilter((BaseEo)storeEo);
    }

    @Override
    public PageInfo<StoreSearchRespDto> queryStoreListSearch(StoreSearchReqDto storeSearchReqDto) {
        logger.info("\u836f\u5e97\u67e5\u8be2\u641c\u7d22\u6761\u4ef6\uff0c{}", (Object)JSONObject.toJSONString((Object)storeSearchReqDto));
        Long orgId = null;
        orgId = storeSearchReqDto.getOrgId() != null ? storeSearchReqDto.getOrgId() : (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()));
        logger.info("\u5f53\u524d\u5927B\u7ec4\u7ec7id\uff0c{}", (Object)orgId);
        List<String> storeIds = this.storeSellerGovernContentService.queryGovernContentListByOrgId(orgId);
        PageInfo storeSearchRespDtos = null;
        if (CollectionUtils.isNotEmpty(storeIds)) {
            storeSearchReqDto.setOrgId(orgId);
            storeSearchReqDto.setStoreIds(storeIds);
            storeSearchRespDtos = (PageInfo)RestResponseHelper.extractData(this.storeSearchQueryApi.queryStoreListSearch(storeSearchReqDto));
        }
        return storeSearchRespDtos;
    }

    @Override
    public List<String> queryStoreType() {
        List strings = this.storeDas.queryStoreType();
        if (strings == null) {
            return new ArrayList<String>();
        }
        return strings;
    }

    @Override
    public PageInfo<StoreRespDto> queryPage(StoreQueryReqDto reqDto) {
        PageInfo storeRespDtoPageInfo;
        if (ObjectUtils.isNotEmpty((Object)reqDto) && CollectionUtil.isNotEmpty((Collection)reqDto.getAreas())) {
            StringBuffer areaArr = new StringBuffer();
            areaArr.append("(");
            reqDto.getAreas().forEach(area -> areaArr.append((String)area).append(","));
            areaArr.deleteCharAt(areaArr.length() - 1).append(")");
            reqDto.setAreaArr(areaArr.toString());
        }
        if ((storeRespDtoPageInfo = this.storeDas.queryPage(reqDto, Integer.valueOf(reqDto.getPageNum()), Integer.valueOf(reqDto.getPageSize()))).getList() == null) {
            storeRespDtoPageInfo.setList(new ArrayList());
        }
        return storeRespDtoPageInfo;
    }

    @Override
    public RestResponse<StoreSellerGovernExcelRespDto> excel(MultipartFile file, String brandMapStr) {
        List<String> codes;
        Map brandMap = (Map)JSON.parseObject((String)brandMapStr, Map.class);
        StoreSellerGovernExcelRespDto respDto = new StoreSellerGovernExcelRespDto();
        respDto.setNum(Integer.valueOf(0));
        respDto.setSuccessNum(Integer.valueOf(0));
        respDto.setFailNum(Integer.valueOf(0));
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        importParams.setKeyIndex(null);
        List storeExcelVoList = Lists.newArrayList();
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), StoreExcelVo.class, (ImportParams)importParams);
            storeExcelVoList = result.getList();
            if (CollectionUtils.isEmpty((Collection)storeExcelVoList)) {
                throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u7b26\u5408\u6a21\u677f\u683c\u5f0f\u8981\u6c42");
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
        Map<Object, Object> storeSellerMap = Maps.newHashMap();
        Map<Object, Object> customerMap = Maps.newHashMap();
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()));
        List<StoreRespDto> stores = this.storeSellerGovernContentService.queryByOrgId(orgId);
        Map<String, String> storeMap = stores.stream().collect(Collectors.toMap(StoreRespDto::getSocialCreditNum, StoreRespDto::getStoreId, (k1, k2) -> k1));
        SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
        sellerQueryReqDto.setOrganizationId(orgId);
        SellerRespDto sellerRespDto = (SellerRespDto)RestResponseHelper.extractData((RestResponse)this.sellerExtQueryApi.querySellerByOrganizationId(orgId));
        logger.info("\u5356\u5bb6\u4fe1\u606f \u53c2\u6570:{},\u7ed3\u679c:{}", (Object)orgId, (Object)JSON.toJsonString((Object)sellerRespDto));
        if (ObjectUtils.isNotEmpty((Object)sellerRespDto)) {
            StoreSellerReqDto reqDto = new StoreSellerReqDto();
            reqDto.setSellerId(sellerRespDto.getId());
            storeSellerMap = this.storeSellerService.selectList(reqDto).stream().collect(Collectors.toMap(e -> e.getStoreId(), e -> e, (k1, k2) -> k1));
            logger.info("\u5546\u5bb6\u836f\u5e97\u5173\u7cfb \u53c2\u6570:{},\u7ed3\u679c:{}", (Object)JSON.toJsonString((Object)reqDto), (Object)JSON.toJsonString((Object)storeSellerMap));
        }
        if (CollectionUtils.isNotEmpty(codes = storeExcelVoList.stream().map(e -> e.getParentCustomerCode()).collect(Collectors.toList()))) {
            List<CustomerRespDto> customerRespDtoList = this.customerQueryService.queryCustomerListByCodesAndOrg(codes, orgId.toString());
            if (CollectionUtils.isNotEmpty(customerRespDtoList)) {
                customerMap = customerRespDtoList.stream().collect(Collectors.toMap(e -> e.getCode(), e -> e, (k1, k2) -> k1));
            }
            logger.info("\u5ba2\u6237\u4fe1\u606f \u53c2\u6570:{},\u7ed3\u679c:{}", (Object)JSON.toJsonString(codes), (Object)JSON.toJsonString((Object)customerMap));
        }
        ArrayList successList = Lists.newArrayList();
        ArrayList errorList = Lists.newArrayList();
        ArrayList notExistBrands = new ArrayList(8);
        ArrayList existBrands = new ArrayList(8);
        for (StoreExcelVo vo : storeExcelVoList) {
            if (StringUtils.isEmpty((CharSequence)vo.getSocialCreditNum()) || StringUtils.isEmpty((CharSequence)storeMap.get(vo.getSocialCreditNum()))) {
                errorList.add(this.excelErrorMsg(vo, "\u836f\u5e97\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u65e0\u6cd5\u627e\u5230\u6216\u4e0d\u5728\u7ba1\u8f96\u8303\u56f4\u5185"));
                continue;
            }
            String storeId = storeMap.get(vo.getSocialCreditNum());
            if (Objects.isNull(sellerRespDto)) {
                errorList.add(this.excelErrorMsg(vo, "\u5546\u5bb6\u4fe1\u606f\u4e0d\u5b58\u5728"));
                continue;
            }
            StoreSellerReqDto dto = new StoreSellerReqDto();
            if (storeSellerMap != null && Objects.nonNull(storeSellerMap.get(storeId))) {
                CubeBeanUtils.copyProperties((Object)dto, (Object)storeSellerMap.get(storeId), (String[])new String[0]);
            }
            dto.setStoreId(storeId);
            dto.setSellerId(sellerRespDto.getId());
            if (StringUtils.isNotEmpty((CharSequence)vo.getParentCustomerCode())) {
                if (Objects.isNull(customerMap.get(vo.getParentCustomerCode()))) {
                    errorList.add(this.excelErrorMsg(vo, "\u5ba2\u6237\u7f16\u53f7\u65e0\u6cd5\u627e\u5230\u6216\u65e0\u6743\u9650"));
                    continue;
                }
                dto.setParentDistributionCode(((CustomerRespDto)customerMap.get(vo.getParentCustomerCode())).getCode());
                dto.setParentDistributionId(((CustomerRespDto)customerMap.get(vo.getParentCustomerCode())).getId());
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getIfSupply())) {
                IfSupplyEnum ifSupplyEnum = IfSupplyEnum.fromName((String)vo.getIfSupply());
                if (Objects.isNull(ifSupplyEnum)) {
                    errorList.add(this.excelErrorMsg(vo, "\u662f\u5426\u4f9b\u8d27\u683c\u5f0f\u6709\u8bef"));
                    continue;
                }
                dto.setIfSupply(ifSupplyEnum.getCode());
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getBrandNames())) {
                notExistBrands.clear();
                existBrands.clear();
                Arrays.stream(vo.getBrandNames().split(";")).distinct().forEach(e -> {
                    if (StringUtils.isBlank((CharSequence)((CharSequence)brandMap.get(e)))) {
                        notExistBrands.add(e);
                    } else {
                        existBrands.add(brandMap.get(e));
                    }
                });
                if (notExistBrands.size() > 0) {
                    errorList.add(this.excelErrorMsg(vo, "\u7ecf\u8425\u54c1\u724c[" + notExistBrands.stream().collect(Collectors.joining(";")) + "]\u4e0d\u5b58\u5728"));
                    continue;
                }
                dto.setBrand(existBrands.stream().collect(Collectors.joining(";")));
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getStoreCategory())) {
                StoreCategoryCodeEnum storeCategoryCodeEnum = StoreCategoryCodeEnum.fromName((String)vo.getStoreCategory());
                if (ObjectUtils.isEmpty((Object)storeCategoryCodeEnum)) {
                    errorList.add(this.excelErrorMsg(vo, "\u8be5\u836f\u5e97\u7c7b\u522b\u4e0d\u5b58\u5728"));
                    continue;
                }
                dto.setStoreCategoryCode(storeCategoryCodeEnum.getCode());
            }
            StoreSellerRespDto storeSellerRespDto = new StoreSellerRespDto();
            CubeBeanUtils.copyProperties((Object)storeSellerRespDto, (Object)dto, (String[])new String[0]);
            if (dto.getId() == null) {
                Long id = this.storeSellerService.addStoreSeller(dto);
                storeSellerRespDto.setId(id);
            } else {
                this.storeSellerService.modifyStoreSeller(dto);
            }
            logger.info("\u66f4\u65b0\u95e8\u5e97\u4fe1\u606fMap\u96c6\u5408:{},{}", (Object)storeId, (Object)JSON.toJsonString((Object)storeSellerRespDto));
            storeSellerMap.put(storeId, storeSellerRespDto);
            successList.add(vo);
        }
        if (CollectionUtils.isNotEmpty((Collection)errorList)) {
            respDto.setFailNum(Integer.valueOf(errorList.size()));
            String excelName = "cube/\u836f\u5e97\u8bbe\u7f6e\u5bfc\u5165\u5931\u8d25\u4fe1\u606f-\u660e\u7ec6Excel-" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
            try {
                String exportUrl = EasyPoiExportUtil.getExportUrl(errorList, StoreExcelVo.class, null, excelName, "xls");
                respDto.setErrorFile(exportUrl);
            }
            catch (Exception e3) {
                e3.printStackTrace();
                logger.error("\u836f\u5e97\u8bbe\u7f6e\u5bfc\u5165\u5931\u8d25\u4fe1\u606f-\u9519\u8bef:{}", (Object)e3.toString());
                return new RestResponse("-1", "\u836f\u5e97\u8bbe\u7f6e\u5bfc\u5165\u5931\u8d25\u4fe1\u606f-\u9519\u8bef:" + e3);
            }
        }
        respDto.setNum(Integer.valueOf(storeExcelVoList.size()));
        respDto.setSuccessNum(Integer.valueOf(successList.size()));
        return new RestResponse((Object)respDto);
    }

    @Override
    public void deleteAllStore(Boolean ifConfirm) {
        if (ifConfirm.booleanValue()) {
            this.storeDas.deleteAllStore();
        }
    }

    @Override
    public void fillStoreAreaCode(List<String> storeIds) {
        logger.info("\u586b\u8865\u533a\u57dfCODE\u4fe1\u606f\uff1a{}", (Object)JSON.toJsonString(storeIds));
        if (CollectionUtils.isEmpty(storeIds)) {
            return;
        }
        List<StoreAreaRespDto> areaTreeList = this.storeAreaService.queryTree();
        for (StoreAreaRespDto area1 : areaTreeList) {
            if (!CollectionUtils.isNotEmpty((Collection)area1.getChildren())) continue;
            area1.getChildren().forEach(area2 -> {
                if (CollectionUtils.isNotEmpty((Collection)area2.getChildren())) {
                    area2.setChildrenMap(area2.getChildren().stream().collect(Collectors.toMap(StoreAreaRespDto::getName, StoreAreaRespDto2 -> StoreAreaRespDto2)));
                }
            });
            area1.setChildrenMap(area1.getChildren().stream().collect(Collectors.toMap(StoreAreaRespDto::getName, StoreAreaRespDto2 -> StoreAreaRespDto2)));
        }
        Map<String, StoreAreaRespDto> areaMap = areaTreeList.stream().collect(Collectors.toMap(StoreAreaRespDto::getName, StoreAreaRespDto2 -> StoreAreaRespDto2));
        List<StoreRespDto> storeList = this.queryListByIds(storeIds);
        storeList.forEach(store -> {
            StoreEo eo = new StoreEo();
            eo.setId(store.getId());
            StoreAreaRespDto province = (StoreAreaRespDto)areaMap.get(store.getProvince());
            if (ObjectUtils.isNotEmpty((Object)province)) {
                eo.setProvinceCode(province.getCode());
                StoreAreaRespDto city = (StoreAreaRespDto)province.getChildrenMap().get(store.getCity());
                if (ObjectUtils.isNotEmpty((Object)city)) {
                    eo.setCityCode(city.getCode());
                    StoreAreaRespDto district = (StoreAreaRespDto)city.getChildrenMap().get(store.getDistrict());
                    eo.setDistrictCode(district.getCode());
                }
            }
            this.storeDas.updateSelective((BaseEo)eo);
        });
        logger.info("\u836f\u5e97\u533a\u57df\u51fa\u73b0\u53d8\u66f4\uff0c\u66f4\u65b0\u7ba1\u8f96\u5173\u8054\u6570\u636e");
        ExecutorUtils.execute(() -> {
            logger.info("\u5f02\u6b65\u6267\u884c\uff1a\u836f\u5e97\u533a\u57df\u51fa\u73b0\u53d8\u66f4\uff0c\u66f4\u65b0\u7ba1\u8f96\u5173\u8054\u6570\u636e");
            this.storeSellerRelateService.updateRelateByStoreChange(storeIds);
        });
    }

    @Override
    public void fillStoreAreaCodeForNot() {
        List storeIds = this.storeDas.queryStoreAreaCodeForNot();
        if (CollectionUtil.isEmpty((Collection)storeIds)) {
            logger.info("\u65e0\u533a\u57dfcode\u4e3a\u7a7a\u7684\u836f\u5e97\u6570\u636e");
            return;
        }
        this.fillStoreAreaCode(storeIds);
    }

    @Override
    public void syncStore(List<StoreReqDto> reqDtoList) {
        logger.info("\u540c\u6b65\u836f\u5e97\u6570\u636e\uff1a{}", (Object)JSON.toJsonString(reqDtoList));
        if (CollectionUtils.isEmpty(reqDtoList)) {
            return;
        }
        List<String> storeIds = reqDtoList.stream().map(StoreReqDto::getStoreId).collect(Collectors.toList());
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"store_id", storeIds));
        StoreEo params = new StoreEo();
        params.setSqlFilters(sqlFilters);
        List queryStoreList = this.storeDas.select((BaseEo)params);
        if (CollectionUtils.isEmpty((Collection)queryStoreList)) {
            this.addStoreBatch(reqDtoList);
            return;
        }
        ArrayList<StoreReqDto> insertList = new ArrayList<StoreReqDto>();
        reqDtoList.forEach(reqDto -> {
            StoreEo queryEo = null;
            for (StoreEo eo : queryStoreList) {
                if (!eo.getStoreId().equals(reqDto.getStoreId())) continue;
                queryEo = eo;
                break;
            }
            if (ObjectUtils.isEmpty(queryEo)) {
                insertList.add((StoreReqDto)reqDto);
            } else {
                StoreEo updateEo = new StoreEo();
                DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)updateEo);
                updateEo.setId(queryEo.getId());
                this.storeDas.update((BaseEo)updateEo);
            }
        });
        this.addStoreBatch(insertList);
        this.fillStoreAreaCode(storeIds);
    }

    @Override
    public List<String> queryByArea(List<String> areas) {
        if (CollectionUtil.isEmpty(areas)) {
            return new ArrayList<String>();
        }
        List storeIds = this.storeDas.queryStoreIdByArea(areas);
        if (storeIds == null) {
            return new ArrayList<String>();
        }
        return storeIds;
    }

    @Override
    public List<StoreRespDto> queryListByIds(List<String> storeIds) {
        if (CollectionUtil.isEmpty(storeIds)) {
            return new ArrayList<StoreRespDto>();
        }
        StoreEo params = new StoreEo();
        params.setSqlFilters((List)Stream.of(SqlFilter.in((String)"store_id", storeIds)).collect(Collectors.toCollection(ArrayList::new)));
        List select = this.storeDas.select((BaseEo)params);
        ArrayList<StoreRespDto> list = new ArrayList<StoreRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, list, StoreRespDto.class);
        return list;
    }

    @Deprecated
    private Map<String, StoreAreaRespDto> searchStoreArea(StoreReqDto reqDto, List<StoreAreaRespDto> areaList) {
        HashMap<String, StoreAreaRespDto> restMap = new HashMap<String, StoreAreaRespDto>();
        areaList.forEach(area -> {
            if (StringUtils.isNotEmpty((CharSequence)reqDto.getProvince()) && restMap.get(StoreAreaLevelEnum.PROVINCE.getName()) == null && area.getLevel().intValue() == StoreAreaLevelEnum.PROVINCE.getCode().intValue() && reqDto.getProvince().equals(area.getName())) {
                restMap.put(StoreAreaLevelEnum.PROVINCE.getName(), (StoreAreaRespDto)area);
            }
            if (StringUtils.isNotEmpty((CharSequence)reqDto.getCity()) && restMap.get(StoreAreaLevelEnum.CITY.getName()) == null && area.getLevel().intValue() == StoreAreaLevelEnum.CITY.getCode().intValue() && reqDto.getCity().equals(area.getName())) {
                restMap.put(StoreAreaLevelEnum.CITY.getName(), (StoreAreaRespDto)area);
            }
            if (StringUtils.isNotEmpty((CharSequence)reqDto.getDistrict()) && restMap.get(StoreAreaLevelEnum.DISTRICT.getName()) == null && area.getLevel().intValue() == StoreAreaLevelEnum.DISTRICT.getCode().intValue() && reqDto.getDistrict().equals(area.getName())) {
                restMap.put(StoreAreaLevelEnum.DISTRICT.getName(), (StoreAreaRespDto)area);
            }
        });
        return restMap;
    }

    public StoreExcelVo excelErrorMsg(StoreExcelVo vo, String errorMsg) {
        vo.setErrorMsg(errorMsg);
        return vo;
    }

    @Override
    public StoreRespDto queryStoreRespDtoByCreditNum(String creditNum) {
        return null;
    }

    @Override
    public List<StoreRespDto> queryStoreByParentSocialCreditNum(String parentSocialCreditNum) {
        return null;
    }
}

