/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.customer.biz.service.tcbj.small;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.huieryun.core.util.JSON;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.IfSupplyEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.StoreSellerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerGovernExcelRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.StoreSellerRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.proxy.report.IStoreSearchQueryApi;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerGovernContentService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.IStoreSellerService;
import com.dtyunxi.yundt.cube.center.customer.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.yundt.cube.center.customer.biz.vo.StoreExcelVo;
import com.dtyunxi.yundt.cube.center.customer.dao.das.StoreDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.StoreEo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerQueryApi;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yx.tcbj.center.customer.api.dto.request.CompanyCheckReqDto;
import com.yx.tcbj.center.customer.api.dto.request.store.StoreSearchReqDto;
import com.yx.tcbj.center.customer.api.dto.response.StoreSearchRespDto;
import com.yx.tcbj.center.customer.api.dto.response.store.StoreRespDto;
import com.yx.tcbj.center.customer.biz.service.adapter.AbstractStoreServiceImpl;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service(value="tcbj_small_IStoreService")
public class TcbjSmallStoreServiceImpl
extends AbstractStoreServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(TcbjSmallStoreServiceImpl.class);
    @Resource
    private StoreDas storeDas;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IStoreSearchQueryApi storeSearchQueryApi;
    @Resource
    private IContext context;
    @Resource(name="${yunxi.dg.base.project}_IStoreSellerService")
    private IStoreSellerService storeSellerService;
    @Resource(name="${yunxi.dg.base.project}_IStoreSellerGovernContentService")
    private IStoreSellerGovernContentService storeSellerGovernContentService;
    @Resource
    private ISellerQueryApi iSellerQueryApi;

    @Override
    public StoreRespDto queryStoreRespDtoByCreditNum(String creditNum) {
        if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{creditNum})) {
            return null;
        }
        StoreEo params = new StoreEo();
        params.setSocialCreditNum(creditNum);
        StoreEo storeEo = (StoreEo)this.storeDas.selectOne((BaseEo)params);
        StoreRespDto storeRespDto = new StoreRespDto();
        DtoHelper.eo2Dto((BaseEo)storeEo, (BaseVo)storeRespDto);
        return storeRespDto;
    }

    @Override
    public List<StoreRespDto> queryStoreByParentSocialCreditNum(String parentSocialCreditNum) {
        if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{parentSocialCreditNum})) {
            return null;
        }
        StoreEo params = new StoreEo();
        params.setParentSocialCreditNum(parentSocialCreditNum);
        List storeEos = this.storeDas.selectList((BaseEo)params);
        ArrayList storeRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)storeEos, (Collection)storeRespDtoList, StoreRespDto.class);
        return storeRespDtoList;
    }

    @Override
    public List<StoreRespDto> queryStoreCheck(CompanyCheckReqDto reqDto) {
        Assert.notNull((Object)reqDto.getCode(), (String)"\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)reqDto.getName(), (String)"\u516c\u53f8\u540d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Assert.notNull((Object)reqDto.getLegalPersonName(), (String)"\u6cd5\u4eba\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        StoreEo storeEo = new StoreEo();
        storeEo.setSocialCreditNum(reqDto.getCode());
        storeEo.setStoreName(reqDto.getName());
        List storeEos = this.storeDas.select((BaseEo)storeEo);
        ArrayList dtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)storeEos, (Collection)dtoList, StoreRespDto.class);
        return dtoList;
    }

    @Override
    public PageInfo<StoreSearchRespDto> queryStoreListSearch(StoreSearchReqDto storeSearchReqDto) {
        logger.info("\u836f\u5e97\u67e5\u8be2\u641c\u7d22\u6761\u4ef6\uff0c{}", (Object)JSONObject.toJSONString((Object)storeSearchReqDto));
        Long orgId = null;
        orgId = storeSearchReqDto.getOrgId() != null ? storeSearchReqDto.getOrgId() : (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()));
        logger.info("\u5f53\u524d\u5927B\u7ec4\u7ec7id\uff0c{}", (Object)orgId);
        storeSearchReqDto.setOrgId(orgId);
        PageInfo storeSearchRespDtos = (PageInfo)RestResponseHelper.extractData(this.storeSearchQueryApi.queryStoreListSearch(storeSearchReqDto));
        return storeSearchRespDtos;
    }

    @Override
    public RestResponse<StoreSellerGovernExcelRespDto> excel(MultipartFile file, String brandMapStr) {
        List codes;
        StoreSellerGovernExcelRespDto respDto = new StoreSellerGovernExcelRespDto();
        respDto.setNum(Integer.valueOf(0));
        respDto.setSuccessNum(Integer.valueOf(0));
        respDto.setFailNum(Integer.valueOf(0));
        ImportParams importParams = new ImportParams();
        importParams.setHeadRows(1);
        importParams.setTitleRows(0);
        importParams.setKeyIndex(null);
        List storeExcelVoList = Lists.newArrayList();
        try {
            ExcelImportResult result = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), StoreExcelVo.class, (ImportParams)importParams);
            storeExcelVoList = result.getList();
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)storeExcelVoList)) {
                throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u4e2d\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u7b26\u5408\u6a21\u677f\u683c\u5f0f\u8981\u6c42");
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new BizException("\u65e0\u6cd5\u8bfb\u53d6 Excel \u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u7c7b\u578b");
        }
        Map<Object, Object> storeSellerMap = Maps.newHashMap();
        Map<Object, Object> customerMap = Maps.newHashMap();
        Long orgId = (Long)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryOrgIdByUserId(this.context.userId()));
        List<StoreRespDto> stores = this.storeSellerGovernContentService.queryByOrgId(orgId);
        Map<String, String> storeMap = stores.stream().collect(Collectors.toMap(StoreRespDto::getSocialCreditNum, StoreRespDto::getStoreId, (k1, k2) -> k1));
        SellerQueryReqDto sellerQueryReqDto = new SellerQueryReqDto();
        sellerQueryReqDto.setOrganizationId(orgId);
        List sellerRespList = (List)RestResponseHelper.extractData((RestResponse)this.iSellerQueryApi.queryListByFeign(sellerQueryReqDto));
        logger.info("\u5356\u5bb6\u4fe1\u606f \u53c2\u6570:{},\u7ed3\u679c:{}", (Object)orgId, (Object)JSON.toJsonString((Object)sellerRespList));
        SellerRespDto sellerRespDto = null;
        if (CollectionUtils.isNotEmpty((Collection)sellerRespList)) {
            sellerRespDto = (SellerRespDto)sellerRespList.get(0);
            StoreSellerReqDto reqDto = new StoreSellerReqDto();
            reqDto.setSellerId(sellerRespDto.getId());
            storeSellerMap = this.storeSellerService.selectList(reqDto).stream().collect(Collectors.toMap(e -> e.getStoreId(), e -> e, (k1, k2) -> k1));
            logger.info("\u5546\u5bb6\u836f\u5e97\u5173\u7cfb \u53c2\u6570:{},\u7ed3\u679c:{}", (Object)JSON.toJsonString((Object)reqDto), (Object)JSON.toJsonString((Object)storeSellerMap));
        }
        if (CollectionUtils.isNotEmpty(codes = storeExcelVoList.stream().map(e -> e.getParentCustomerCode()).collect(Collectors.toList()))) {
            CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
            searchReqDto.setListFlag(Boolean.valueOf(true));
            searchReqDto.setChannel(Integer.valueOf(2));
            searchReqDto.setType(Integer.valueOf(3));
            PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryByPage(JSONObject.toJSONString((Object)searchReqDto), Integer.valueOf(1), Integer.valueOf(10)));
            if (CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                customerMap = pageInfo.getList().stream().collect(Collectors.toMap(e -> e.getCode(), e -> e, (k1, k2) -> k1));
            }
            logger.info("\u5ba2\u6237\u4fe1\u606f \u53c2\u6570:{},\u7ed3\u679c:{}", (Object)JSON.toJsonString(codes), (Object)JSON.toJsonString((Object)customerMap));
        }
        ArrayList successList = Lists.newArrayList();
        ArrayList errorList = Lists.newArrayList();
        for (StoreExcelVo vo : storeExcelVoList) {
            if (StringUtils.isEmpty((CharSequence)vo.getSocialCreditNum()) || StringUtils.isEmpty((CharSequence)storeMap.get(vo.getSocialCreditNum()))) {
                errorList.add(this.excelErrorMsg(vo, "\u836f\u5e97\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u65e0\u6cd5\u627e\u5230\u6216\u4e0d\u5728\u7ba1\u8f96\u8303\u56f4\u5185"));
                continue;
            }
            String storeId = storeMap.get(vo.getSocialCreditNum());
            if (Objects.isNull(sellerRespDto)) {
                errorList.add(this.excelErrorMsg(vo, "\u5546\u5bb6\u4fe1\u606f\u4e0d\u5b58\u5728"));
                continue;
            }
            StoreSellerReqDto dto = new StoreSellerReqDto();
            if (storeSellerMap != null && Objects.nonNull(storeSellerMap.get(storeId))) {
                CubeBeanUtils.copyProperties((Object)dto, (Object)storeSellerMap.get(storeId), (String[])new String[0]);
            }
            dto.setStoreId(storeId);
            dto.setSellerId(sellerRespDto.getId());
            if (StringUtils.isNotEmpty((CharSequence)vo.getParentCustomerCode())) {
                if (Objects.isNull(customerMap.get(vo.getParentCustomerCode()))) {
                    errorList.add(this.excelErrorMsg(vo, "\u5ba2\u6237\u7f16\u53f7\u65e0\u6cd5\u627e\u5230\u6216\u65e0\u6743\u9650"));
                    continue;
                }
                dto.setParentDistributionCode(((CustomerRespDto)customerMap.get(vo.getParentCustomerCode())).getCode());
                dto.setParentDistributionId(((CustomerRespDto)customerMap.get(vo.getParentCustomerCode())).getId());
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getIfSupply())) {
                IfSupplyEnum ifSupplyEnum = IfSupplyEnum.fromName((String)vo.getIfSupply());
                if (Objects.isNull(ifSupplyEnum)) {
                    errorList.add(this.excelErrorMsg(vo, "\u662f\u5426\u4f9b\u8d27\u683c\u5f0f\u6709\u8bef"));
                    continue;
                }
                dto.setIfSupply(ifSupplyEnum.getCode());
            }
            StoreSellerRespDto storeSellerRespDto = new StoreSellerRespDto();
            CubeBeanUtils.copyProperties((Object)storeSellerRespDto, (Object)dto, (String[])new String[0]);
            if (dto.getId() == null) {
                Long id = this.storeSellerService.addStoreSeller(dto);
                storeSellerRespDto.setId(id);
            } else {
                this.storeSellerService.modifyStoreSeller(dto);
            }
            logger.info("\u66f4\u65b0\u95e8\u5e97\u4fe1\u606fMap\u96c6\u5408:{},{}", (Object)storeId, (Object)JSON.toJsonString((Object)storeSellerRespDto));
            storeSellerMap.put(storeId, storeSellerRespDto);
            successList.add(vo);
        }
        if (CollectionUtils.isNotEmpty((Collection)errorList)) {
            respDto.setFailNum(Integer.valueOf(errorList.size()));
            String excelName = "cube/\u836f\u5e97\u8bbe\u7f6e\u5bfc\u5165\u5931\u8d25\u4fe1\u606f-\u8ba2\u5355\u660e\u7ec6Excel-" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
            try {
                String exportUrl = EasyPoiExportUtil.getExportUrl(errorList, StoreExcelVo.class, null, excelName, "xls");
                respDto.setErrorFile(exportUrl);
            }
            catch (Exception e3) {
                e3.printStackTrace();
                logger.error("\u836f\u5e97\u8bbe\u7f6e\u5bfc\u5165\u5931\u8d25\u4fe1\u606f-\u9519\u8bef:{}", (Object)e3.toString());
                return new RestResponse("-1", "\u836f\u5e97\u8bbe\u7f6e\u5bfc\u5165\u5931\u8d25\u4fe1\u606f-\u9519\u8bef:" + e3);
            }
        }
        respDto.setNum(Integer.valueOf(storeExcelVoList.size()));
        respDto.setSuccessNum(Integer.valueOf(successList.size()));
        return new RestResponse((Object)respDto);
    }
}

