/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.tcbj;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerAddReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerBlacklistReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerImportReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerQueryReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeCustomerReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.EmployeeRegionReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmployeeCustomerImportDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmployeeCustomerImportRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmployeeCustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.util.AssertUtil;
import com.dtyunxi.yundt.cube.center.customer.biz.service.adapter.AbstractEmployeeCustomerServiceImpl;
import com.dtyunxi.yundt.cube.center.customer.biz.utils.EasyPoiExportUtil;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.das.CustomerDas;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.mapper.CustomerAreaMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.mapper.CustomerMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.customer.mapper.RCustomerRegionMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.das.EmployeeCustomerDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.EmployeeCustomerBlacklistEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.EmployeeCustomerEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.EmployeeRegionEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerAreaEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.CustomerEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.RCustomerRegionEo;
import com.dtyunxi.yundt.cube.center.customer.dao.mapper.EmployeeCustomerBlacklistMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.mapper.EmployeeCustomerTemporaryMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.mapper.EmployeeRegionMapper;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdCustomerAreaEo;
import com.dtyunxi.yundt.cube.center.customer.dao.stdeo.customer.StdRCustomerRegionEo;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tcbj_IEmployeeCustomerService")
public class TcbjEmployeeCustomerServiceImpl
extends AbstractEmployeeCustomerServiceImpl {
    public final Logger logger = LoggerFactory.getLogger(TcbjEmployeeCustomerServiceImpl.class);
    @Resource
    private EmployeeCustomerDas employeeCustomerDas;
    @Resource
    private IUserQueryApi userQueryApi;
    @Resource
    private CustomerMapper customerMapper;
    @Resource
    private CustomerDas customerDas;
    @Resource
    private RCustomerRegionMapper rCustomerRegionMapper;
    @Resource
    private CustomerAreaMapper customerAreaMapper;
    @Resource
    private EmployeeCustomerTemporaryMapper employeeCustomerTemporaryMapper;
    @Resource
    private EmployeeRegionMapper employeeRegionMapper;
    @Resource
    private EmployeeCustomerBlacklistMapper employeeCustomerBlacklistMapper;

    @Override
    public Long addEmployeeCustomer(EmployeeCustomerReqDto addReqDto) {
        EmployeeCustomerEo employeeCustomerEo = new EmployeeCustomerEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)employeeCustomerEo);
        this.employeeCustomerDas.insert((BaseEo)employeeCustomerEo);
        return employeeCustomerEo.getId();
    }

    @Override
    public void modifyEmployeeCustomer(EmployeeCustomerReqDto modifyReqDto) {
        EmployeeCustomerEo employeeCustomerEo = new EmployeeCustomerEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)employeeCustomerEo);
        this.employeeCustomerDas.updateSelective((BaseEo)employeeCustomerEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeEmployeeCustomer(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.employeeCustomerDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public EmployeeCustomerRespDto queryById(Long id) {
        EmployeeCustomerEo employeeCustomerEo = (EmployeeCustomerEo)this.employeeCustomerDas.selectByPrimaryKey(id);
        EmployeeCustomerRespDto employeeCustomerRespDto = new EmployeeCustomerRespDto();
        DtoHelper.eo2Dto((BaseEo)employeeCustomerEo, (BaseVo)employeeCustomerRespDto);
        return employeeCustomerRespDto;
    }

    @Override
    public PageInfo<EmployeeCustomerRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        EmployeeCustomerReqDto employeeCustomerReqDto = (EmployeeCustomerReqDto)JSON.parseObject((String)filter, EmployeeCustomerReqDto.class);
        EmployeeCustomerEo employeeCustomerEo = new EmployeeCustomerEo();
        DtoHelper.dto2Eo((BaseVo)employeeCustomerReqDto, (BaseEo)employeeCustomerEo);
        PageInfo eoPageInfo = this.employeeCustomerDas.selectPage((BaseEo)employeeCustomerEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, EmployeeCustomerRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public EmployeeCustomerImportRespDto customerImport(EmployeeCustomerImportReqDto importReqDto) {
        this.logger.info("\u5bfc\u5165\u5ba2\u6237:{}", (Object)importReqDto.getFileUrl());
        String fileUrl = importReqDto.getFileUrl();
        AssertUtil.assertNotBlank((String)fileUrl, (String)"\u5bfc\u5165\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        String attachment = ServiceContext.getContext().getAttachment("yes-req-cus-b2b-organizationid");
        this.logger.info("\u5bfc\u5165\u5ba2\u6237attachment:{}", (Object)attachment);
        EmployeeCustomerImportRespDto resultDto = new EmployeeCustomerImportRespDto();
        List importDtos = Lists.newArrayList();
        try {
            InputStream is = this.getInputStream(fileUrl);
            ExcelImportResult objectExcelImportResult = EasyPoiExportUtil.importExcel(is, 0, 1, EmployeeCustomerImportDto.class);
            importDtos = objectExcelImportResult.getList();
        }
        catch (Exception e) {
            throw new BizException("\u5bfc\u5165\u5ba2\u6237\u89e3\u6790\u5931\u8d25\uff1a" + e.getMessage());
        }
        this.logger.info("\u5bfc\u5165\u7684\u6570\u636e==>{}", (Object)JSONObject.toJSONString((Object)importDtos));
        if (CollectionUtils.isEmpty((Collection)importDtos)) {
            throw new BizException("\u5bfc\u5165\u7684\u8868\u683c\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8868\u683c\u540e\u91cd\u65b0\u5bfc\u5165");
        }
        resultDto.setTotalSize(importDtos.size());
        List<String> customerCodeList = importDtos.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getCustomerCode())).map(EmployeeCustomerImportDto::getCustomerCode).distinct().collect(Collectors.toList());
        List<CustomerRespDto> customerDtoList = this.queryCustomerByCodeList(customerCodeList);
        Map<Object, Object> customerDtoMap = new HashMap(customerDtoList.size() * 4 / 3 + 2);
        if (CollectionUtils.isNotEmpty(customerDtoList)) {
            customerDtoMap = customerDtoList.stream().collect(Collectors.toMap(CustomerRespDto::getCode, Function.identity(), (k1, k2) -> k1));
        }
        ArrayList resultList = Lists.newArrayList();
        for (EmployeeCustomerImportDto importDto : importDtos) {
            if (StringUtils.isEmpty((CharSequence)importDto.getCustomerCode())) {
                importDto.setErrorReason("\u5ba2\u6237\u7f16\u53f7\u4e3a\u7a7a;");
                continue;
            }
            if (customerDtoMap.isEmpty() || !customerDtoMap.containsKey(importDto.getCustomerCode())) {
                importDto.setErrorReason("\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728;");
                continue;
            }
            CustomerRespDto customerDto = (CustomerRespDto)customerDtoMap.get(importDto.getCustomerCode());
            String merchantId = customerDto.getMerchantId().toString();
            if (!Objects.equals(attachment, merchantId)) {
                importDto.setErrorReason("\u5ba2\u6237\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5546\u5bb6;");
                continue;
            }
            resultList.add(customerDto);
        }
        resultDto.setResultList((List)resultList);
        List list = importDtos.stream().filter(dto -> StringUtils.isNotEmpty((CharSequence)dto.getErrorReason())).collect(Collectors.toList());
        resultDto.setFailSize(list.size());
        if (CollectionUtils.isNotEmpty(list)) {
            String title = "\u5bfc\u5165\u5ba2\u6237\u8fd4\u56de\u7ed3\u679c";
            String fileName = title + System.currentTimeMillis();
            try {
                String exportUrl = EasyPoiExportUtil.getExportUrl(list, EmployeeCustomerImportDto.class, title, fileName, "xls");
                resultDto.setErrorFileUrl(exportUrl);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BizException("\u5bfc\u51fa\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
        return resultDto;
    }

    private InputStream getInputStream(String fileUrl) throws IOException {
        URL url = new URL(fileUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        return conn.getInputStream();
    }

    private List<CustomerRespDto> queryCustomerByList(List<String> codeList, List<Long> idList) {
        if (CollectionUtils.isEmpty(codeList) && CollectionUtils.isEmpty(idList)) {
            throw new BizException("\u5fc5\u4f20id\u96c6\u5408\u6216code\u96c6\u5408\u53c2\u6570\u4e3a\u7a7a");
        }
        QueryWrapper customerEoQueryWrapper = new QueryWrapper();
        if (CollectionUtils.isNotEmpty(codeList)) {
            customerEoQueryWrapper.in((Object)"code", codeList);
        }
        if (CollectionUtils.isNotEmpty(idList)) {
            customerEoQueryWrapper.in((Object)"id", idList);
        }
        customerEoQueryWrapper.eq((Object)"dr", (Object)"0");
        List customerEos = this.customerMapper.selectList((Wrapper)customerEoQueryWrapper);
        Map<Object, Object> customerRegionMap = new HashMap();
        Map<Object, Object> areaEoMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)customerEos)) {
            List customerIds = customerEos.stream().map(BaseEo::getId).collect(Collectors.toList());
            QueryWrapper customerRegionEoQueryWrapper = new QueryWrapper();
            customerRegionEoQueryWrapper.in((Object)"customer_id", customerIds);
            customerRegionEoQueryWrapper.eq((Object)"dr", (Object)"0");
            List rCustomerRegionEos = this.rCustomerRegionMapper.selectList((Wrapper)customerRegionEoQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)rCustomerRegionEos)) {
                customerRegionMap = rCustomerRegionEos.stream().collect(Collectors.groupingBy(StdRCustomerRegionEo::getCustomerId));
                List regionCodeList = rCustomerRegionEos.stream().map(StdRCustomerRegionEo::getRegionCode).distinct().collect(Collectors.toList());
                QueryWrapper areaEoQueryWrapper = new QueryWrapper();
                areaEoQueryWrapper.in((Object)"code", regionCodeList);
                areaEoQueryWrapper.eq((Object)"dr", (Object)"0");
                List customerAreaEos = this.customerAreaMapper.selectList((Wrapper)areaEoQueryWrapper);
                if (CollectionUtils.isNotEmpty((Collection)customerAreaEos)) {
                    areaEoMap = customerAreaEos.stream().collect(Collectors.toMap(StdCustomerAreaEo::getCode, Function.identity(), (k1, k2) -> k1));
                }
            }
        }
        ArrayList respDtoList = Lists.newArrayList();
        for (CustomerEo customerEo : customerEos) {
            CustomerRespDto respDto = new CustomerRespDto();
            CubeBeanUtils.copyProperties((Object)respDto, (Object)customerEo, (String[])new String[0]);
            if (!customerRegionMap.isEmpty() && customerRegionMap.containsKey(customerEo.getId())) {
                List rCustomerRegionEos = (List)customerRegionMap.get(customerEo.getId());
                String regionNames = "";
                for (RCustomerRegionEo rCustomerRegionEo : rCustomerRegionEos) {
                    if (areaEoMap.isEmpty() || !areaEoMap.containsKey(rCustomerRegionEo.getRegionCode())) continue;
                    if ("".equals(regionNames)) {
                        regionNames = ((CustomerAreaEo)areaEoMap.get(rCustomerRegionEo.getRegionCode())).getName();
                        continue;
                    }
                    regionNames = regionNames + ";" + ((CustomerAreaEo)areaEoMap.get(rCustomerRegionEo.getRegionCode())).getName();
                }
                respDto.setRegionNames(regionNames);
                respDto.setRegionCodeList(rCustomerRegionEos.stream().map(StdRCustomerRegionEo::getRegionCode).collect(Collectors.toList()));
            }
            respDtoList.add(respDto);
        }
        return respDtoList;
    }

    @Override
    public List<CustomerRespDto> queryCustomerByIdList(List<Long> idList) {
        return this.queryCustomerByList(null, idList);
    }

    @Override
    public List<CustomerRespDto> queryCustomerByCodeList(List<String> codeList) {
        return this.queryCustomerByList(codeList, null);
    }

    @Override
    public List<EmployeeCustomerRespDto> queryEmployeeCustomerList(EmployeeCustomerQueryReqDto queryReqDto) {
        this.logger.info("\u67e5\u8be2\u4eba\u5458\u5173\u8054\u5ba2\u6237\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)queryReqDto));
        String attachment = ServiceContext.getContext().getAttachment("yes-req-cus-b2b-organizationid");
        if (Objects.isNull(queryReqDto.getMerchantId()) && StringUtils.isNotEmpty((CharSequence)attachment)) {
            queryReqDto.setMerchantId(Long.valueOf(attachment));
        }
        EmployeeCustomerEo employeeCustomerEo = EmployeeCustomerEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)queryReqDto, (BaseEo)employeeCustomerEo);
        List eoList = this.employeeCustomerDas.select((BaseEo)employeeCustomerEo);
        if (CollectionUtils.isEmpty((Collection)eoList)) {
            return Lists.newArrayList();
        }
        ArrayList respDtos = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)eoList, (Collection)respDtos, EmployeeCustomerRespDto.class);
        List<Long> customerIdList = respDtos.stream().map(EmployeeCustomerRespDto::getCustomerId).distinct().collect(Collectors.toList());
        List<CustomerRespDto> customerDtoList = this.queryCustomerByIdList(customerIdList);
        Map<Object, Object> customerDtoMap = new HashMap(customerDtoList.size() * 4 / 3 + 2);
        if (CollectionUtils.isNotEmpty(customerDtoList)) {
            customerDtoMap = customerDtoList.stream().collect(Collectors.toMap(BaseRespDto::getId, Function.identity(), (k1, k2) -> k1));
        }
        for (EmployeeCustomerRespDto respDto : respDtos) {
            if (customerDtoMap.isEmpty() || !customerDtoMap.containsKey(respDto.getCustomerId())) continue;
            CustomerRespDto customerRespDto = (CustomerRespDto)customerDtoMap.get(respDto.getCustomerId());
            respDto.setCustomerCode(customerRespDto.getCode());
            respDto.setCustomerName(customerRespDto.getName());
            respDto.setCustomerRegionNames(customerRespDto.getRegionNames());
        }
        return respDtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveEmployeeBindInfo(EmployeeCustomerAddReqDto addReqDto) {
        List customerBlackList;
        List customerInfoList;
        List regionInfoList;
        this.logger.info("\u66f4\u65b0\u4eba\u5458\u7ed1\u5b9a\u5ba2\u6237\u4fe1\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)addReqDto));
        AssertUtil.assertNotNull((Object)addReqDto, (String)"\u5fc5\u4f20\u53c2\u6570DTO\u4e3a\u7a7a");
        AssertUtil.assertNotNull((Object)addReqDto.getEmployeeId(), (String)"\u5fc5\u4f20\u53c2\u6570\u4eba\u5458ID\u4e3a\u7a7a");
        AssertUtil.assertNotNull((Object)addReqDto.getMerchantId(), (String)"\u5fc5\u4f20\u53c2\u6570\u5546\u5bb6ID\u4e3a\u7a7a");
        QueryWrapper employeeRegionQuery = new QueryWrapper();
        employeeRegionQuery.eq((Object)"employee_id", (Object)addReqDto.getEmployeeId());
        employeeRegionQuery.eq((Object)"merchant_id", (Object)addReqDto.getMerchantId());
        employeeRegionQuery.eq((Object)"dr", (Object)0);
        Integer employeeRegionNum = this.employeeRegionMapper.selectCount((Wrapper)employeeRegionQuery);
        this.logger.info("\u66f4\u65b0\u4eba\u5458\u7ed1\u5b9a\u533a\u57df\u67e5\u8be2\u6761\u6570:{}", (Object)JSON.toJSONString((Object)employeeRegionNum));
        if (employeeRegionNum > 0) {
            int deleteNum = this.employeeRegionMapper.delete((Wrapper)employeeRegionQuery);
            this.logger.info("\u66f4\u65b0\u4eba\u5458\u7ed1\u5b9a\u533a\u57df\u5220\u9664\u6761\u6570:{}", (Object)JSON.toJSONString((Object)deleteNum));
            if (deleteNum != employeeRegionNum) {
                throw new BizException("\u5220\u9664\u4eba\u5458\u7ed1\u5b9a\u533a\u57df\u9519\u8bef");
            }
        }
        QueryWrapper employeeCustomerQuery = new QueryWrapper();
        employeeCustomerQuery.eq((Object)"employee_id", (Object)addReqDto.getEmployeeId());
        employeeCustomerQuery.eq((Object)"merchant_id", (Object)addReqDto.getMerchantId());
        employeeCustomerQuery.eq((Object)"dr", (Object)0);
        Integer employeeCustomerNum = this.employeeCustomerTemporaryMapper.selectCount((Wrapper)employeeCustomerQuery);
        this.logger.info("\u66f4\u65b0\u4eba\u5458\u7ed1\u5b9a\u5ba2\u6237\u67e5\u8be2\u6761\u6570:{}", (Object)JSON.toJSONString((Object)employeeCustomerNum));
        if (employeeCustomerNum > 0) {
            int deleteNum = this.employeeCustomerTemporaryMapper.delete((Wrapper)employeeCustomerQuery);
            this.logger.info("\u66f4\u65b0\u4eba\u5458\u7ed1\u5b9a\u5ba2\u6237\u5220\u9664\u6761\u6570:{}", (Object)JSON.toJSONString((Object)deleteNum));
            if (deleteNum != employeeCustomerNum) {
                throw new BizException("\u5220\u9664\u4eba\u5458\u5ba2\u6237\u4fe1\u606f\u9519\u8bef");
            }
        }
        QueryWrapper employeeCustomerBlackQuery = new QueryWrapper();
        employeeCustomerBlackQuery.eq((Object)"employee_id", (Object)addReqDto.getEmployeeId());
        employeeCustomerBlackQuery.eq((Object)"merchant_id", (Object)addReqDto.getMerchantId());
        employeeCustomerBlackQuery.eq((Object)"dr", (Object)0);
        Integer employeeCustomerBlackNum = this.employeeCustomerBlacklistMapper.selectCount((Wrapper)employeeCustomerBlackQuery);
        this.logger.info("\u66f4\u65b0\u4eba\u5458\u7ed1\u5b9a\u5ba2\u6237\u9ed1\u540d\u5355\u67e5\u8be2\u6761\u6570:{}", (Object)JSON.toJSONString((Object)employeeCustomerBlackNum));
        if (employeeCustomerBlackNum > 0) {
            int deleteNum = this.employeeCustomerBlacklistMapper.delete((Wrapper)employeeCustomerBlackQuery);
            this.logger.info("\u66f4\u65b0\u4eba\u5458\u7ed1\u5b9a\u5ba2\u6237\u9ed1\u540d\u5355\u5220\u9664\u6761\u6570:{}", (Object)JSON.toJSONString((Object)deleteNum));
            if (deleteNum != employeeCustomerBlackNum) {
                throw new BizException("\u5220\u9664\u4eba\u5458\u5ba2\u6237\u9ed1\u540d\u5355\u4fe1\u606f\u9519\u8bef");
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(regionInfoList = addReqDto.getRegionInfoList()))) {
            ArrayList addList = Lists.newArrayList();
            for (EmployeeRegionReqDto employeeRegionReqDto : regionInfoList) {
                EmployeeRegionEo addEo = EmployeeRegionEo.newInstance();
                CubeBeanUtils.copyProperties((Object)addEo, (Object)employeeRegionReqDto, (String[])new String[0]);
                addEo.setEmployeeId(addReqDto.getEmployeeId());
                addEo.setUserId(addReqDto.getUserId());
                addEo.setMerchantId(addReqDto.getMerchantId());
                addList.add(addEo);
            }
            this.employeeRegionMapper.insertBatch((List)addList);
        }
        if (CollectionUtils.isNotEmpty((Collection)(customerInfoList = addReqDto.getCustomerInfoList()))) {
            ArrayList addList = Lists.newArrayList();
            for (EmployeeCustomerReqDto addDto : customerInfoList) {
                EmployeeCustomerEo addEo = EmployeeCustomerEo.newInstance();
                CubeBeanUtils.copyProperties((Object)addEo, (Object)addDto, (String[])new String[0]);
                addEo.setEmployeeId(addReqDto.getEmployeeId());
                addEo.setUserId(addReqDto.getUserId());
                addEo.setMerchantId(addReqDto.getMerchantId());
                addList.add(addEo);
            }
            this.employeeCustomerTemporaryMapper.insertBatch((List)addList);
        }
        if (CollectionUtils.isNotEmpty((Collection)(customerBlackList = addReqDto.getCustomerBlackList()))) {
            ArrayList addList = Lists.newArrayList();
            for (EmployeeCustomerBlacklistReqDto addDto : customerBlackList) {
                EmployeeCustomerBlacklistEo addEo = EmployeeCustomerBlacklistEo.newInstance();
                CubeBeanUtils.copyProperties((Object)addEo, (Object)addDto, (String[])new String[0]);
                addEo.setEmployeeId(addReqDto.getEmployeeId());
                addEo.setUserId(addReqDto.getUserId());
                addEo.setMerchantId(addReqDto.getMerchantId());
                addList.add(addEo);
            }
            this.employeeCustomerBlacklistMapper.insertBatch((List)addList);
        }
    }
}

