/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.mkld;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerAddressReqDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.adapter.AbstractCustomerAddressServiceImpl;
import com.dtyunxi.yundt.cube.center.customer.dao.das.AddressExtDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerAddressDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.customer.AddressEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="mkld_ICustomerAddressService")
public class MkldCustomerAddressServiceImpl
extends AbstractCustomerAddressServiceImpl {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private CustomerAddressDas customerAddressDas;
    @Resource
    private AddressExtDas addressExtDas;

    @Override
    public void addCustomerAddress(List<CustomerAddressReqDto> reqDto) {
        if (!org.springframework.util.CollectionUtils.isEmpty(reqDto)) {
            ArrayList<AddressEo> addressEoList = new ArrayList<AddressEo>();
            ArrayList<AddressEo> updateEoList = new ArrayList<AddressEo>();
            for (CustomerAddressReqDto addressReqDto : reqDto) {
                AddressEo addressEo;
                List select;
                AddressEo queryEo = new AddressEo();
                queryEo.setUserId(addressReqDto.getUserId());
                queryEo.setCustomerCode(addressReqDto.getCustomerCode());
                queryEo.setSapAddressCode(addressReqDto.getSapAddressCode());
                if (StringUtils.isNotEmpty((CharSequence)addressReqDto.getOrganizationCode())) {
                    queryEo.setOrganizationCode(addressReqDto.getOrganizationCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)addressReqDto.getDepartmentCode())) {
                    queryEo.setDepartmentCode(addressReqDto.getDepartmentCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)addressReqDto.getChannelCode())) {
                    queryEo.setChannelCode(addressReqDto.getChannelCode());
                }
                if (CollectionUtils.isNotEmpty((Collection)(select = this.addressExtDas.select((BaseEo)queryEo)))) {
                    addressEo = new AddressEo();
                    BeanUtils.copyProperties((Object)addressReqDto, (Object)addressEo);
                    addressEo.setId(((AddressEo)select.get(0)).getId());
                    updateEoList.add(addressEo);
                    continue;
                }
                addressEo = new AddressEo();
                BeanUtils.copyProperties((Object)addressReqDto, (Object)addressEo);
                addressEoList.add(addressEo);
            }
            if (!org.springframework.util.CollectionUtils.isEmpty(addressEoList)) {
                this.addressExtDas.insertBatch(addressEoList);
            }
            if (!org.springframework.util.CollectionUtils.isEmpty(updateEoList)) {
                this.addressExtDas.updateBatchByIds(updateEoList);
            }
        }
    }
}

