/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.mkld;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.SalesRangeExtReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.SalesRangeReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.SalesRangeRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.adapter.AbstractSalesRangeServiceImpl;
import com.dtyunxi.yundt.cube.center.customer.dao.das.SalesRangeDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.SalesRangeEo;
import com.dtyunxi.yundt.cube.center.customer.dao.mapper.SalesRangeMapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.stereotype.Service;

@Service(value="mkld_ISalesRangeService")
public class MkldSalesRangeServiceImpl
extends AbstractSalesRangeServiceImpl {
    @Resource
    private SalesRangeDas salesRangeDas;
    @Resource
    private SalesRangeMapper salesRangeMapper;

    @Override
    public PageInfo<SalesRangeRespDto> querySalesOrgByPage(SalesRangeReqDto salesRangeReqDto) {
        ExtQueryChainWrapper filterSql = this.salesRangeDas.filter();
        if (ObjectUtils.isNotEmpty((Object)salesRangeReqDto.getOrgCode())) {
            filterSql.like((Object)"org_code", (Object)("%" + salesRangeReqDto.getOrgCode() + "%"));
        }
        if (ObjectUtils.isNotEmpty((Object)salesRangeReqDto.getOrgName())) {
            filterSql.like((Object)"org_name", (Object)("%" + salesRangeReqDto.getOrgName() + "%"));
        }
        PageInfo eoPageInfo = ((ExtQueryChainWrapper)filterSql.groupBy((Object)"org_code")).page(salesRangeReqDto.getPageNum(), salesRangeReqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, SalesRangeRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<SalesRangeRespDto> queryAllSalesOrgByPage(SalesRangeExtReqDto salesRangeReqDto) {
        QueryWrapper salesRangeEoQueryWrapper = new QueryWrapper();
        salesRangeEoQueryWrapper.groupBy((Object)"org_code");
        salesRangeEoQueryWrapper.eq((Object)"dr", (Object)0);
        List salesRangeEos = this.salesRangeMapper.selectList((Wrapper)salesRangeEoQueryWrapper);
        ArrayList<SalesRangeRespDto> salesRangeRespDtos = new ArrayList<SalesRangeRespDto>();
        DtoHelper.eoList2DtoList((Collection)salesRangeEos, salesRangeRespDtos, SalesRangeRespDto.class);
        return salesRangeRespDtos;
    }

    @Override
    public PageInfo<SalesRangeRespDto> querySalesOrgRelationDepByPage(SalesRangeReqDto salesRangeReqDto) {
        ExtQueryChainWrapper filterSql = this.salesRangeDas.filter();
        if (ObjectUtils.isNotEmpty((Object)salesRangeReqDto.getOrgCode())) {
            filterSql.like((Object)"org_code", (Object)("%" + salesRangeReqDto.getOrgCode() + "%"));
        }
        if (ObjectUtils.isNotEmpty((Object)salesRangeReqDto.getDepName())) {
            filterSql.like((Object)"dep_name", (Object)("%" + salesRangeReqDto.getDepName() + "%"));
        }
        PageInfo eoPageInfo = ((ExtQueryChainWrapper)filterSql.groupBy((Object)"dep_code")).page(salesRangeReqDto.getPageNum(), salesRangeReqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, SalesRangeRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<SalesRangeRespDto> queryAllSalesOrgRelationByPage(SalesRangeReqDto salesRangeReqDto) {
        ExtQueryChainWrapper filterSql = this.salesRangeDas.filter();
        if (ObjectUtils.isNotEmpty((Object)salesRangeReqDto.getOrgCode())) {
            filterSql.eq((Object)"org_code", (Object)salesRangeReqDto.getOrgCode());
        }
        if (ObjectUtils.isNotEmpty((Object)salesRangeReqDto.getOrgName())) {
            filterSql.eq((Object)"org_name", (Object)salesRangeReqDto.getOrgName());
        }
        if (ObjectUtils.isNotEmpty((Object)salesRangeReqDto.getDepCode())) {
            filterSql.eq((Object)"dep_code", (Object)salesRangeReqDto.getDepCode());
        }
        if (ObjectUtils.isNotEmpty((Object)salesRangeReqDto.getDepName())) {
            filterSql.eq((Object)"dep_name", (Object)salesRangeReqDto.getDepName());
        }
        PageInfo eoPageInfo = filterSql.page(salesRangeReqDto.getPageNum(), salesRangeReqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, SalesRangeRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void batchSalesRange(List<SalesRangeReqDto> list) {
        ArrayList<SalesRangeEo> eoList = new ArrayList<SalesRangeEo>();
        ArrayList<SalesRangeEo> updateList = new ArrayList<SalesRangeEo>();
        if (CollectionUtils.isNotEmpty(list)) {
            for (SalesRangeReqDto rangeReqDto : list) {
                List<SalesRangeRespDto> salesRangeReqDto = this.querySalesOrgRelationDepByList(rangeReqDto);
                if (CollectionUtils.isNotEmpty(salesRangeReqDto)) {
                    SalesRangeEo updateEo = new SalesRangeEo();
                    DtoHelper.dto2Eo((BaseVo)rangeReqDto, (BaseEo)updateEo);
                    updateEo.setId(salesRangeReqDto.get(0).getId());
                    updateList.add(updateEo);
                    continue;
                }
                SalesRangeEo salesRangeEo = new SalesRangeEo();
                DtoHelper.dto2Eo((BaseVo)rangeReqDto, (BaseEo)salesRangeEo);
                eoList.add(salesRangeEo);
            }
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            this.salesRangeDas.updateBatchByIds(updateList);
        }
        if (CollectionUtils.isNotEmpty(eoList)) {
            this.salesRangeDas.insertBatch(eoList);
        }
    }

    @Override
    public List<SalesRangeRespDto> querySalesOrgRelationDepByCode(SalesRangeReqDto salesRangeReqDto) {
        SalesRangeEo salesRangeEo = new SalesRangeEo();
        if (null != salesRangeReqDto.getId()) {
            salesRangeEo.setId(salesRangeReqDto.getId());
        }
        if (null != salesRangeReqDto.getOrgCode()) {
            salesRangeEo.setOrgCode(salesRangeReqDto.getOrgCode());
        }
        if (null != salesRangeReqDto.getOrgName()) {
            salesRangeEo.setOrgName(salesRangeReqDto.getOrgName());
        }
        if (null != salesRangeReqDto.getDepCode()) {
            salesRangeEo.setDepCode(salesRangeReqDto.getDepCode());
        }
        if (null != salesRangeReqDto.getDepName()) {
            salesRangeEo.setDepName(salesRangeReqDto.getDepName());
        }
        if (null != salesRangeReqDto.getChannelCode()) {
            salesRangeEo.setChannelCode(salesRangeReqDto.getChannelCode());
        }
        if (null != salesRangeReqDto.getChannelName()) {
            salesRangeEo.setChannelName(salesRangeReqDto.getChannelName());
        }
        List salesRangeEoList = this.salesRangeDas.select((BaseEo)salesRangeEo);
        ArrayList<SalesRangeRespDto> dtoList = new ArrayList<SalesRangeRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)salesRangeEoList)) {
            DtoHelper.eoList2DtoList((Collection)salesRangeEoList, dtoList, SalesRangeRespDto.class);
        }
        return dtoList;
    }

    @Override
    public List<SalesRangeRespDto> querySalesOrgRelationDepByList(SalesRangeReqDto salesRangeReqDto) {
        QueryWrapper filterSql = new QueryWrapper();
        if (ObjectUtils.isNotEmpty((Object)salesRangeReqDto.getOrgCode())) {
            filterSql.eq((Object)"org_code", (Object)salesRangeReqDto.getOrgCode());
        }
        if (ObjectUtils.isNotEmpty((Object)salesRangeReqDto.getOrgCodeList())) {
            filterSql.in((Object)"org_code", (Collection)salesRangeReqDto.getOrgCodeList());
        }
        if (ObjectUtils.isNotEmpty((Object)salesRangeReqDto.getDepCode())) {
            filterSql.eq((Object)"dep_code", (Object)salesRangeReqDto.getDepCode());
        }
        if (ObjectUtils.isNotEmpty((Object)salesRangeReqDto.getDepCodeList())) {
            filterSql.in((Object)"dep_code", (Collection)salesRangeReqDto.getDepCodeList());
        }
        if (ObjectUtils.isNotEmpty((Object)salesRangeReqDto.getChannelCode())) {
            filterSql.eq((Object)"channel_code", (Object)salesRangeReqDto.getChannelCode());
        }
        if (ObjectUtils.isNotEmpty((Object)salesRangeReqDto.getChannelCodeList())) {
            filterSql.in((Object)"channel_code", (Collection)salesRangeReqDto.getChannelCodeList());
        }
        if (ObjectUtils.isNotEmpty((Object)salesRangeReqDto.getOrgCode()) || ObjectUtils.isNotEmpty((Object)salesRangeReqDto.getOrgCodeList())) {
            filterSql.groupBy((Object)"org_code");
        } else if (ObjectUtils.isNotEmpty((Object)salesRangeReqDto.getDepCode()) || ObjectUtils.isNotEmpty((Object)salesRangeReqDto.getDepCodeList())) {
            filterSql.groupBy((Object)"dep_code");
        } else if (ObjectUtils.isNotEmpty((Object)salesRangeReqDto.getChannelCode()) || ObjectUtils.isNotEmpty((Object)salesRangeReqDto.getChannelCodeList())) {
            filterSql.groupBy((Object)"channel_code");
        }
        List salesRangeEoList = this.salesRangeDas.queryEoList(filterSql);
        ArrayList<SalesRangeRespDto> dtoList = new ArrayList<SalesRangeRespDto>();
        if (CollectionUtils.isNotEmpty((Collection)salesRangeEoList)) {
            DtoHelper.eoList2DtoList((Collection)salesRangeEoList, dtoList, SalesRangeRespDto.class);
        }
        return dtoList;
    }

    @Override
    public PageInfo<SalesRangeRespDto> querySalesOrgDepByPage(SalesRangeReqDto salesRangeReqDto) {
        PageHelper.startPage((int)salesRangeReqDto.getPageNum(), (int)salesRangeReqDto.getPageSize());
        PageInfo eoPageInfo = new PageInfo(this.salesRangeDas.querySalesRangeEoList(salesRangeReqDto));
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, SalesRangeRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public SalesRangeRespDto queryByOrganizationCode(String organizationCode) {
        SalesRangeEo salesRangeEo = new SalesRangeEo();
        salesRangeEo.setOrgCode(organizationCode);
        List salesRangeEoList = this.salesRangeDas.select((BaseEo)salesRangeEo);
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)salesRangeEoList, dtoList, SalesRangeRespDto.class);
        if (ObjectUtils.isNotEmpty(dtoList)) {
            return (SalesRangeRespDto)dtoList.get(0);
        }
        return null;
    }
}

