/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.adapter;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.dto.enums.CustomerExceptionCode;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerPropertyReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerPropertyValueReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerPropertyRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.PropertyListRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.ICustomerPropertyService;
import com.dtyunxi.yundt.cube.center.customer.biz.utils.Assert;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerPropertyDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerPropertyInfoDas;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerPropertyValueDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerPropertyEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerPropertyInfoEo;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerPropertyValueEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractCustomerPropertyServiceImpl
implements ICustomerPropertyService {
    @Resource
    private CustomerPropertyDas customerPropertyDas;
    @Resource
    private CustomerPropertyInfoDas customerPropertyInfoDas;
    @Resource
    private CustomerPropertyValueDas customerPropertyValueDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addCustomerProperty(CustomerPropertyReqDto addReqDto) {
        CustomerPropertyEo customerProperty = new CustomerPropertyEo();
        customerProperty.setName(addReqDto.getName());
        CustomerPropertyEo customerPropertySelect = (CustomerPropertyEo)this.customerPropertyDas.selectOne((BaseEo)customerProperty);
        ArrayList<String> resultList = new ArrayList<String>();
        if (customerPropertySelect != null) {
            resultList.add(CustomerExceptionCode.PROPERTY_NAME_REPETITION.getMsg());
        }
        CustomerPropertyEo customerPropertyEo = new CustomerPropertyEo();
        List customerPropertyValueReqDtoList = addReqDto.getCustomerPropertyValueReqDtoList();
        List values = customerPropertyValueReqDtoList.stream().map(c -> c.getValue()).collect(Collectors.toList());
        long count = values.stream().distinct().count();
        if ((long)values.size() != count) {
            resultList.add(CustomerExceptionCode.PROPERTY_VALUE_REPETITION.getMsg());
        }
        if (CollectionUtils.isNotEmpty(resultList)) {
            String join = String.join((CharSequence)",", resultList);
            throw new BizException(join);
        }
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)customerPropertyEo);
        this.customerPropertyDas.insert((BaseEo)customerPropertyEo);
        ArrayList customerPropertyValueEos = new ArrayList();
        List collect = values.stream().filter(value -> value != null).collect(Collectors.toList());
        collect.stream().forEach(v -> {
            CustomerPropertyValueEo customerPropertyValueEo = new CustomerPropertyValueEo();
            customerPropertyValueEo.setPropertyId(customerPropertyEo.getId());
            customerPropertyValueEo.setValue(v);
            customerPropertyValueEos.add(customerPropertyValueEo);
        });
        if (CollectionUtils.isNotEmpty(customerPropertyValueEos)) {
            this.customerPropertyValueDas.insertBatch(customerPropertyValueEos);
        }
        return customerPropertyEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyCustomerProperty(CustomerPropertyReqDto modifyReqDto) {
        List customerPropertyValueReqDtoList;
        ArrayList<String> resultList = new ArrayList<String>();
        CustomerPropertyEo customerProperty = (CustomerPropertyEo)this.customerPropertyDas.selectByPrimaryKey(modifyReqDto.getId());
        if (!customerProperty.getName().equals(modifyReqDto.getName())) {
            CustomerPropertyEo customerPropertyUpdate = new CustomerPropertyEo();
            customerPropertyUpdate.setName(modifyReqDto.getName());
            CustomerPropertyEo customerPropertySelect = (CustomerPropertyEo)this.customerPropertyDas.selectOne((BaseEo)customerPropertyUpdate);
            if (customerPropertySelect != null) {
                resultList.add(CustomerExceptionCode.PROPERTY_NAME_REPETITION.getMsg());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(customerPropertyValueReqDtoList = modifyReqDto.getCustomerPropertyValueReqDtoList()))) {
            List values = customerPropertyValueReqDtoList.stream().map(c -> c.getValue()).collect(Collectors.toList());
            long count = values.stream().distinct().count();
            if ((long)values.size() != count) {
                resultList.add(CustomerExceptionCode.PROPERTY_VALUE_REPETITION.getMsg());
            }
        }
        if (CollectionUtils.isNotEmpty(resultList)) {
            String join = String.join((CharSequence)",", resultList);
            throw new BizException(join);
        }
        CustomerPropertyEo customerPropertyEo = new CustomerPropertyEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)customerPropertyEo);
        this.customerPropertyDas.updateSelective((BaseEo)customerPropertyEo);
        if (CollectionUtils.isNotEmpty((Collection)customerPropertyValueReqDtoList)) {
            ArrayList customerPropertyValueEoList = new ArrayList();
            customerPropertyValueReqDtoList.stream().forEach(v -> {
                CustomerPropertyValueEo customerPropertyValueEo = new CustomerPropertyValueEo();
                if (v.getId() != null) {
                    customerPropertyValueEo.setId(v.getId());
                    customerPropertyValueEo.setValue(v.getValue());
                    this.customerPropertyValueDas.updateSelective((BaseEo)customerPropertyValueEo);
                } else {
                    customerPropertyValueEo.setPropertyId(modifyReqDto.getId());
                    customerPropertyValueEo.setValue(v.getValue());
                    customerPropertyValueEoList.add(customerPropertyValueEo);
                }
            });
            if (CollectionUtils.isNotEmpty(customerPropertyValueEoList)) {
                this.customerPropertyValueDas.insertBatch(customerPropertyValueEoList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCustomerProperty(String ids) {
        String[] removeIds = ids.split(",");
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            sqlFilters.add(SqlFilter.in((String)"property_id", (Object)removeIds));
        }
        CustomerPropertyInfoEo customerPropertyInfoEo = new CustomerPropertyInfoEo();
        customerPropertyInfoEo.setSqlFilters(sqlFilters);
        List customerPropertyInfoEoList = this.customerPropertyInfoDas.select((BaseEo)customerPropertyInfoEo);
        Assert.isTrue(CollectionUtils.isEmpty((Collection)customerPropertyInfoEoList), CustomerExceptionCode.PROPERTY_RELATION_CUSTOMER_CANNOT_DELETE);
        for (String id : removeIds) {
            this.customerPropertyDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public void deleteCustomerPropertyValue(Long valueId) {
        CustomerPropertyInfoEo customerPropertyInfoEo = new CustomerPropertyInfoEo();
        customerPropertyInfoEo.setPropertyValueId(valueId);
        List select = this.customerPropertyInfoDas.select((BaseEo)customerPropertyInfoEo);
        Assert.isTrue(CollectionUtils.isEmpty((Collection)select), CustomerExceptionCode.PROPERTY_VALUE_RELATION_CUSTOMER_CANNOT_DELETE);
        this.customerPropertyValueDas.deleteById(valueId);
    }

    @Override
    public CustomerPropertyRespDto queryById(Long id) {
        CustomerPropertyEo customerPropertyEo = (CustomerPropertyEo)this.customerPropertyDas.selectByPrimaryKey(id);
        CustomerPropertyRespDto customerPropertyRespDto = new CustomerPropertyRespDto();
        DtoHelper.eo2Dto((BaseEo)customerPropertyEo, (BaseVo)customerPropertyRespDto);
        return customerPropertyRespDto;
    }

    @Override
    public List<PropertyListRespDto> queryByList() {
        ArrayList propertyListRespDtoList = Lists.newArrayList();
        List customerPropertyEoList = this.customerPropertyDas.selectAll();
        if (CollectionUtils.isNotEmpty((Collection)customerPropertyEoList)) {
            List ids = customerPropertyEoList.stream().map(c -> c.getId()).collect(Collectors.toList());
            ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
            sqlFilterList.add(SqlFilter.in((String)"property_id", ids));
            CustomerPropertyValueEo customerPropertyValueEo = new CustomerPropertyValueEo();
            customerPropertyValueEo.setSqlFilters(sqlFilterList);
            List value = this.customerPropertyValueDas.select((BaseEo)customerPropertyValueEo);
            customerPropertyEoList.stream().forEach(c -> {
                PropertyListRespDto propertyListRespDto = new PropertyListRespDto();
                CubeBeanUtils.copyProperties((Object)propertyListRespDto, (Object)c, (String[])new String[0]);
                ArrayList customerPropertyValueReqDtoList = new ArrayList();
                value.stream().forEach(v -> {
                    if (c.getId().equals(v.getPropertyId())) {
                        CustomerPropertyValueReqDto customerPropertyValueReqDto = new CustomerPropertyValueReqDto();
                        CubeBeanUtils.copyProperties((Object)customerPropertyValueReqDto, (Object)v, (String[])new String[0]);
                        customerPropertyValueReqDtoList.add(customerPropertyValueReqDto);
                    }
                });
                propertyListRespDto.setCustomerPropertyValueReqDtoList(customerPropertyValueReqDtoList);
                propertyListRespDtoList.add(propertyListRespDto);
            });
        }
        return propertyListRespDtoList;
    }

    @Override
    public PageInfo<CustomerPropertyRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CustomerPropertyReqDto customerPropertyReqDto = (CustomerPropertyReqDto)JSON.parseObject((String)filter, CustomerPropertyReqDto.class);
        CustomerPropertyEo customerPropertyEo = new CustomerPropertyEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotBlank((CharSequence)customerPropertyReqDto.getName())) {
            sqlFilters.add(SqlFilter.like((String)"name", (Object)("%" + customerPropertyReqDto.getName() + "%")));
        }
        customerPropertyEo.setSqlFilters(sqlFilters);
        customerPropertyEo.setOrderByDesc("create_time");
        PageInfo eoPageInfo = this.customerPropertyDas.selectPage((BaseEo)customerPropertyEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CustomerPropertyRespDto.class);
        List ids = dtoList.stream().map(list -> list.getId()).collect(Collectors.toList());
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (CollectionUtils.isNotEmpty(ids)) {
            sqlFilterList.add(SqlFilter.in((String)"property_id", ids));
        }
        CustomerPropertyValueEo customerPropertyValueEo = new CustomerPropertyValueEo();
        customerPropertyValueEo.setSqlFilters(sqlFilterList);
        List customerPropertyValueEoList = this.customerPropertyValueDas.select((BaseEo)customerPropertyValueEo);
        dtoList.stream().forEach(d -> {
            ArrayList customerPropertyValueReqDtoList = new ArrayList();
            customerPropertyValueEoList.stream().forEach(v -> {
                if (d.getId().equals(v.getPropertyId())) {
                    CustomerPropertyValueReqDto customerPropertyValueReqDto = new CustomerPropertyValueReqDto();
                    CubeBeanUtils.copyProperties((Object)customerPropertyValueReqDto, (Object)v, (String[])new String[0]);
                    customerPropertyValueReqDtoList.add(customerPropertyValueReqDto);
                }
            });
            if (CollectionUtils.isNotEmpty(customerPropertyValueReqDtoList)) {
                d.setCustomerPropertyValueReqDtoList(customerPropertyValueReqDtoList);
            }
        });
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

