/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.adapter;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerReceivingReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerReceivingRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.service.ICustomerReceivingService;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerReceivingDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerReceivingEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractCustomerReceivingServiceImpl
implements ICustomerReceivingService {
    @Resource
    private CustomerReceivingDas customerReceivingDas;

    @Override
    public Long addCustomerReceiving(CustomerReceivingReqDto addReqDto) {
        CustomerReceivingEo customerReceivingEo = new CustomerReceivingEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)customerReceivingEo);
        this.customerReceivingDas.insert((BaseEo)customerReceivingEo);
        return customerReceivingEo.getId();
    }

    @Override
    public void modifyCustomerReceiving(CustomerReceivingReqDto modifyReqDto) {
        CustomerReceivingEo customerReceivingEo = new CustomerReceivingEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)customerReceivingEo);
        this.customerReceivingDas.updateSelective((BaseEo)customerReceivingEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCustomerReceiving(String ids) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.customerReceivingDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public CustomerReceivingRespDto queryById(Long id) {
        CustomerReceivingEo customerReceivingEo = (CustomerReceivingEo)this.customerReceivingDas.selectByPrimaryKey(id);
        CustomerReceivingRespDto customerReceivingRespDto = new CustomerReceivingRespDto();
        DtoHelper.eo2Dto((BaseEo)customerReceivingEo, (BaseVo)customerReceivingRespDto);
        return customerReceivingRespDto;
    }

    @Override
    public PageInfo<CustomerReceivingRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CustomerReceivingReqDto customerReceivingReqDto = (CustomerReceivingReqDto)JSON.parseObject((String)filter, CustomerReceivingReqDto.class);
        CustomerReceivingEo customerReceivingEo = new CustomerReceivingEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        if (customerReceivingReqDto.getCustomerId() != null) {
            sqlFilterList.add(SqlFilter.eq((String)"customer_id", (Object)customerReceivingReqDto.getCustomerId()));
        }
        if (StringUtils.isNotBlank((CharSequence)customerReceivingReqDto.getName())) {
            sqlFilterList.add(SqlFilter.like((String)"name", (Object)customerReceivingReqDto.getName()));
        }
        if (StringUtils.isNotBlank((CharSequence)customerReceivingReqDto.getPhone())) {
            sqlFilterList.add(SqlFilter.like((String)"phone", (Object)customerReceivingReqDto.getPhone()));
        }
        customerReceivingEo.setSqlFilters(sqlFilterList);
        customerReceivingEo.setOrderByDesc("create_time");
        PageInfo eoPageInfo = this.customerReceivingDas.selectPage((BaseEo)customerReceivingEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CustomerReceivingRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

