/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.customer.biz.service.adapter;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.CustomerRelationReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.CustomerRelationRespDto;
import com.dtyunxi.yundt.cube.center.customer.biz.customer.service.ICustomerService;
import com.dtyunxi.yundt.cube.center.customer.biz.service.ICustomerRelationService;
import com.dtyunxi.yundt.cube.center.customer.dao.das.CustomerRelationDas;
import com.dtyunxi.yundt.cube.center.customer.dao.eo.CustomerRelationEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractCustomerRelationServiceImpl
implements ICustomerRelationService {
    private Logger logger = LoggerFactory.getLogger(AbstractCustomerRelationServiceImpl.class);
    @Resource
    private CustomerRelationDas customerRelationDas;
    @Autowired
    private ICustomerService customerService;

    @Override
    public Long addCustomerRelation(CustomerRelationReqDto addReqDto) {
        CustomerRelationEo customerRelationEo = new CustomerRelationEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)customerRelationEo);
        this.customerRelationDas.insert((BaseEo)customerRelationEo);
        return customerRelationEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addBatchCustomerRelation(List<CustomerRelationReqDto> dtoList) {
        if (CollectionUtil.isEmpty(dtoList)) {
            return;
        }
        List<String> codes = dtoList.stream().map(CustomerRelationReqDto::getParentThirdCode).collect(Collectors.toList());
        this.removeCustomerRelationByParentCode(codes);
        ArrayList customerRelationEos = new ArrayList();
        DtoHelper.dtoList2EoList(dtoList, customerRelationEos, CustomerRelationEo.class);
        this.customerRelationDas.insertBatch(customerRelationEos);
    }

    @Override
    public void modifyCustomerRelation(CustomerRelationReqDto modifyReqDto) {
        CustomerRelationEo customerRelationEo = new CustomerRelationEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)customerRelationEo);
        this.customerRelationDas.updateSelective((BaseEo)customerRelationEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeCustomerRelation(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.customerRelationDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public void removeCustomerRelationByParentCode(List<String> codes) {
        QueryWrapper filter = new QueryWrapper();
        filter.in((Object)"parent_third_code", codes);
        int delete = this.customerRelationDas.getMapper().delete((Wrapper)filter);
    }

    @Override
    public CustomerRelationRespDto queryById(Long id) {
        CustomerRelationEo customerRelationEo = (CustomerRelationEo)this.customerRelationDas.selectByPrimaryKey(id);
        CustomerRelationRespDto customerRelationRespDto = new CustomerRelationRespDto();
        DtoHelper.eo2Dto((BaseEo)customerRelationEo, (BaseVo)customerRelationRespDto);
        return customerRelationRespDto;
    }

    @Override
    public PageInfo<CustomerRelationRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        CustomerRelationReqDto customerRelationReqDto = (CustomerRelationReqDto)JSON.parseObject((String)filter, CustomerRelationReqDto.class);
        CustomerRelationEo customerRelationEo = new CustomerRelationEo();
        DtoHelper.dto2Eo((BaseVo)customerRelationReqDto, (BaseEo)customerRelationEo);
        PageInfo eoPageInfo = this.customerRelationDas.selectPage((BaseEo)customerRelationEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, CustomerRelationRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public CustomerRespDto queryMiddleCustomerInfo(Long smallCusId, Long greatCusId) {
        this.logger.info("\u6839\u636e\u5927\u5c0fB\u5ba2\u6237ID\u5224\u65ad\u5e76\u67e5\u8be2\u4e2dB\u4fe1\u606f\uff1a{}=={}", (Object)smallCusId, (Object)greatCusId);
        if (ObjectUtils.isEmpty((Object)smallCusId) && ObjectUtils.isEmpty((Object)greatCusId)) {
            return null;
        }
        Long cusId = null;
        cusId = ObjectUtils.isNotEmpty((Object)smallCusId) ? smallCusId : greatCusId;
        CustomerRespDto customerRespDto = this.customerService.queryById(cusId);
        if (ObjectUtils.isEmpty((Object)customerRespDto)) {
            return null;
        }
        CustomerRelationReqDto reqDto = new CustomerRelationReqDto();
        if (ObjectUtils.isNotEmpty((Object)smallCusId)) {
            reqDto.setThirdCode(customerRespDto.getThirdPartyId());
        } else {
            reqDto.setParentThirdCode(customerRespDto.getThirdPartyId());
        }
        List<CustomerRelationRespDto> customerRelationRespList = this.queryList(reqDto);
        if (CollectionUtil.isNotEmpty(customerRelationRespList)) {
            return customerRespDto;
        }
        return null;
    }

    @Override
    public List<CustomerRelationRespDto> queryList(CustomerRelationReqDto reqDto) {
        CustomerRelationEo customerRelationEo = new CustomerRelationEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)customerRelationEo);
        List select = this.customerRelationDas.select((BaseEo)customerRelationEo);
        ArrayList<CustomerRelationRespDto> dtoList = new ArrayList<CustomerRelationRespDto>();
        DtoHelper.eoList2DtoList((Collection)select, dtoList, CustomerRelationRespDto.class);
        return dtoList;
    }

    @Override
    public void replenishCustomerRelation(List<String> codes) {
        if (CollectionUtil.isEmpty(codes)) {
            return;
        }
        List customerRelationEos = this.customerRelationDas.queryCurrentCustomerRelation(codes);
        if (CollectionUtil.isNotEmpty((Collection)customerRelationEos)) {
            customerRelationEos.forEach(eo -> this.customerRelationDas.updateSelective((BaseEo)eo));
        }
    }

    @Override
    public CustomerRelationRespDto queryByCustomer(Long customerId) {
        CustomerRelationEo customerRelationEo = this.customerRelationDas.queryByCustomer(customerId);
        CustomerRelationRespDto relationRespDto = new CustomerRelationRespDto();
        DtoHelper.eo2Dto((BaseEo)customerRelationEo, (BaseVo)relationRespDto);
        if (ObjectUtils.isEmpty((Object)relationRespDto.getId())) {
            return null;
        }
        return relationRespDto;
    }
}

