/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.customer.biz.util;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.yundt.cube.center.customer.api.constants.RoBootAccessTokenEnum;
import com.dtyunxi.yundt.cube.center.customer.api.dto.request.DingTaskReqDto;
import com.google.common.collect.Lists;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.tomcat.util.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DingTaskUtils {
    private static final Logger log = LoggerFactory.getLogger(DingTaskUtils.class);
    @Value(value="${dingTalkRobot.sendMsg:https://oapi.dingtalk.com/robot/send}")
    private String robotUrl;
    @Value(value="${dingTalkRobot.secret:SEC76e08939274ce72fb36f48ec2ccf7b8bad3143293083e09759594b63711e6303}")
    private String secret;
    private static String sign = null;
    private static Long timestamp = null;
    public static final String THRESHOLD = "MAX";
    public static String NORMAL_WARN_CONTENT = "#### \u670d\u52a1\u5f02\u5e38\u544a\u8b66 \n\n \u5f02\u5e38\u670d\u52a1\uff1a%s \n\n \u5f02\u5e38\u63a5\u53e3\uff1a%s \n\n \u54cd\u5e94\u72b6\u6001\uff1a%s \n\n \u54cd\u5e94\u65f6\u95f4\uff1a%s  \n\n \u54cd\u5e94\u4fe1\u606f\uff1a%s ";
    public static String SELLER_RELATION_WARN_CONTENT = "#### \u95e8\u5e97\u5546\u5bb6\u5173\u7cfb\u76d1\u63a7\u544a\u8b66 \n\n \u5f02\u5e38\u63a5\u53e3\uff1a%s \n\n \u5f02\u5e38\u8303\u56f4\uff1a%s \n\n  \u5f02\u5e38\u4fe1\u606f\uff1a%s \n\n \u64cd\u4f5c\u7528\u6237\uff1a%s \n\n \u5f02\u5e38\u65f6\u95f4\uff1a%s ";

    public void dingTalkRobot(String accessToken, String content) {
        try {
            log.info("\u53d1\u9001\u76d1\u63a7\u544a\u8b66\u4fe1\u606f\uff0c\u6d88\u606f\u5185\u5bb9\uff1a{}", (Object)content);
            String s = HttpUtil.post((String)(this.robotUrl + "?access_token=" + accessToken + "&timestamp=" + timestamp + "&sign=" + sign), (String)content);
            log.info("\u6d88\u606f\u53d1\u9001Result:{}", (Object)s);
            Map map = (Map)JSON.parseObject((String)s, Map.class);
            if (Integer.parseInt(map.get("errcode").toString()) == 310000 && map.get("errmsg").toString().indexOf("timestamp") != -1) {
                this.getDingTalkRobotConfig(this.secret);
                this.dingTalkRobot(accessToken, content);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getDingTalkRobotConfig(String secret) throws Exception {
        timestamp = System.currentTimeMillis();
        log.info("\u83b7\u53d6\u9489\u9489\u7b7e\u540d\u914d\u7f6e\u65f6\u95f4\u6233\uff1a{}", (Object)timestamp);
        String stringToSign = timestamp + "\n" + secret;
        Mac mac = Mac.getInstance("HmacSHA256");
        mac.init(new SecretKeySpec(secret.getBytes("UTF-8"), "HmacSHA256"));
        byte[] signData = mac.doFinal(stringToSign.getBytes("UTF-8"));
        sign = URLEncoder.encode(new String(Base64.encodeBase64((byte[])signData)), "UTF-8");
    }

    public static void main(String[] args) {
        DingTaskReqDto.ActionCard actionCard = new DingTaskReqDto.ActionCard(String.format(SELLER_RELATION_WARN_CONTENT, RoBootAccessTokenEnum.STORE_SELLER_RELATION_AUTO_ROBOOT.getDesc(), com.dtyunxi.huieryun.core.util.JSON.toJsonString((Object)Lists.newArrayList((Object[])new String[]{"92230112MA196KN781", "92230112MA19ALPJ3Q", "92230112MA19ALPJ3Q", "92230112MA19ALPJ3Q", "92230112MA19ALPJ3Q", "92230112MA19ALPJ3Q", "92230112MA19ALPJ3Q", "92230112MA19ALPJ3Q", "92230112MA19ALPJ3Q", "92230112MA19ALPJ3Q", "92230112MA19ALPJ3Q", "92230112MA19ALPJ3Q", "92230112MA19ALPJ3Q", "92230112MA19ALPJ3Q", "92230112MA19ALPJ3Q", "92230112MA19ALPJ3Q", "92230112MA19ALPJ3Q", "92230112MA19ALPJ3Q", "92230112MA19ALPJ3Q", "92230112MA19ALPJ3Q", "92230112MA19ALPJ3Q", "92230112MA19ALPJ3Q", "92230112MA19ALPJ3Q"})), "java.lang.InstantiationException", "ppf001", LocalDate.now()), RoBootAccessTokenEnum.STORE_SELLER_RELATION_AUTO_ROBOOT.getTitle() + "\u6d4b\u8bd5");
        DingTaskReqDto dingTaskReqDto = new DingTaskReqDto();
        dingTaskReqDto.setMsgtype(RoBootAccessTokenEnum.STORE_SELLER_RELATION_AUTO_ROBOOT.getContentModel());
        dingTaskReqDto.setActionCard(actionCard);
        DingTaskUtils dingTaskUtils = new DingTaskUtils();
        dingTaskUtils.dingTalkRobot(RoBootAccessTokenEnum.STORE_SELLER_RELATION_AUTO_ROBOOT.getAccessToken(), com.dtyunxi.huieryun.core.util.JSON.toJsonString((Object)dingTaskReqDto));
    }
}

