package com.dtyunxi.yundt.cube.center.inventory.api.order.adjust;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.dto.TcbjStockChangeDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.adjust.req.*;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.adjust.resp.TcbjAdjustDetailRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.order.adjust.resp.TcbjAdjustRespDto;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author shuidi
 */
@Api(tags = {"调货单接口"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name:ty-cube-center-inventory}", path = "/v1/order-adjust", url = "${yundt.cube.center.inventory.api:}")
public interface ITcbjAdjustApi {

    @PostMapping(value = "/page", produces = "application/json")
    @ApiOperation(value = "前端 分页查询调货单", notes = "分页查询")
    RestResponse<PageInfo<TcbjAdjustRespDto>> page(@Validated @RequestBody TcbjAdjustReqDto queryDto);

    @PostMapping(value = "/gen", produces = "application/json")
    @ApiOperation(value = "前端 添加调货单", notes = "添加调货单")
    RestResponse<String> gen(@Validated @RequestBody TcbjAdjustGenReqDto dto);

    @PostMapping(value = "/update", produces = "application/json")
    @ApiOperation(value = "前端 修改调货单", notes = "修改调货单")
    RestResponse<String> update(@Validated @RequestBody TcbjAdjustUpReqDto dto);

    @PostMapping(value = "/updateNoti", produces = "application/json")
    @ApiOperation(value = "修改通知单", notes = "修改调货单")
    RestResponse<String> updateNoti(@Validated @RequestBody TcbjAdjustUpReqDto dto);

    @PostMapping(value = "/audit", produces = "application/json")
    @ApiOperation(value = "订单中心 审核调货单", notes = "审核调货单")
    RestResponse<String> audit(@Validated @RequestBody TcbjAdjustAuReqDto dto);

    @PostMapping(value = "/addCargo", produces = "application/json")
    @ApiOperation(value = "弃用前端 添加调货单商品", notes = "添加调货单商品")
    RestResponse<String> addCargo(@Validated @RequestBody TcbjAdjustItemReqDto dto);

    @PostMapping(value = "/delCargo", produces = "application/json")
    @ApiOperation(value = "弃用前端 修改调货单商品", notes = "修改调货单商品")
    RestResponse<String> delCargo(@Validated @RequestBody TcbjAdjustItemReqDto dto);

    @PostMapping(value = "/detail", produces = "application/json")
    @ApiOperation(value = "前端 调货单详细", notes = "调货单详细")
    RestResponse<TcbjAdjustDetailRespDto> detail(@Validated @RequestBody String id);
    /**
     * 修改物理库存
     *
     * @return
     */
    @PutMapping("/tcbjPhysicLogicWarehouseOut")
    @ApiOperation(value = "修改物理库存", notes = "修改物理库存")
    RestResponse<Void> tcbjPhysicLogicWarehouseOut(@RequestBody TcbjStockChangeDto reqDto);
}
