package com.dtyunxi.yundt.cube.center.inventory.enums;


public enum BusinessTypeEnum {
    /**
     * 调用中台出库/入库类型定义
     * 101销售出库       201采购入库
     * 102分销出库       202分销入库
     * 103退换货出库      203退换货入库
     * 104一级退货出库    204下级退货入库
     * 105调拨出库       205调拨入库
     * 106其他出库       206其他入库
     * 107物料调整出库       207物料调整入库
     * 109报废出库
     * 110二级退货出库
     */
    INVOKE_CUBE_ORDER_TYPE_SALES_ISSUE("invokeCubeOrderType", "101", "销售出库"),
    INVOKE_CUBE_ORDER_TYPE_RETAILSALE_OUT("invokeCubeOrderType", "102", "分销出库"),
    INVOKE_CUBE_ORDER_TYPE_EXCHANGE_OUT("invokeCubeOrderType", "103", "退换货出库"),
    INVOKE_CUBE_ORDER_TYPE_SUB_SALE_RTN_OUT("invokeCubeOrderType", "104", "一级退货出库"),
    INVOKE_CUBE_ORDER_TYPE_TRANSFER_OUT("invokeCubeOrderType", "105", "调拨出库"),
    INVOKE_CUBE_ORDER_TYPE_OTHER_OUT("invokeCubeOrderType", "106", "其他出库"),
    INVOKE_CUBE_ORDER_MATERIAL_ADJUST_OUT("invokeCubeOrderType", "107", "物料调整出库"),
    INVOKE_CUBE_ORDER_SCRAP_OUT("invokeCubeOrderType", "109", "报废出库"),
    INVOKE_CUBE_ORDER_TYPE_SECOND_SUB_SALE_RTN_OUT("invokeCubeOrderType", "110", "二级退货出库"),

    INVOKE_CUBE_ORDER_TYPE_PURINWAREHS("invokeCubeOrderType", "201", "采购入库"),
    INVOKE_CUBE_ORDER_TYPE_RETAILSALE_IN("invokeCubeOrderType", "202", "分销入库"),
    INVOKE_CUBE_ORDER_TYPE_EXCHANGE_IN("invokeCubeOrderType", "203", "退换货入库"),
    INVOKE_CUBE_ORDER_TYPE_SUB_SALE_RTN_IN("invokeCubeOrderType", "204", "下级退货入库"),
    INVOKE_CUBE_ORDER_TYPE_TRANSFER_IN("invokeCubeOrderType", "205", "调拨入库"),
    INVOKE_CUBE_ORDER_TYPE_OTHER_IN("invokeCubeOrderType", "206", "其他入库"),
    INVOKE_CUBE_ORDER_MATERIAL_ADJUST_IN("invokeCubeOrderType", "207", "物料调整入库"),
    /** 二级采购入库 **/
    SECOND_IN_PURCHASE("invokeCubeOrderType","210","二级采购入库"),

    /**
     * 套装活动预占
     **/
    INVOKE_COMBINATION_ACT_PREEMPT("invokeCubeOrderType", "301", "套装活动预占"),
    /**
     * 套装下单预占
     **/
    INVOKE_COMBINATION_ACT_ORDER_PREEMPT("invokeCubeOrderType", "302", "套装下单预占"),
    /**
     * 套装取消预占
     **/
    INVOKE_COMBINATION_ACT_ORDER_CANCEL("invokeCubeOrderType", "303", "套装取消预占"),
    /**
     * 套装结束归还
     **/
    INVOKE_COMBINATION_ACT_FINISH("invokeCubeOrderType", "304", "套装结束归还"),
    /**
     * 套装发货扣减
     **/
    INVOKE_COMBINATION_ACT_REDUCE("invokeCubeOrderType", "305", "套装发货扣减"),
    /**
     * 套装审批释放
     **/
    INVOKE_COMBINATION_ACT_AUDIT_REDUCE("invokeCubeOrderType", "306", "套装审批释放"),
    /**
     * 套装审批预占
     **/
    INVOKE_COMBINATION_ACT_AUDIT_PREEMPT("invokeCubeOrderType", "307", "套装审批预占");


    private String type;
    private String code;
    private String desc;


    BusinessTypeEnum(String type, String code, String desc) {
        this.type = type;
        this.code = code;
        this.desc = desc;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static String getDescByCode(String code) {
        BusinessTypeEnum[] values = BusinessTypeEnum.values();
        for (BusinessTypeEnum value : values) {
            if (value.code.equals(code)) {
                return value.desc;
            }
        }
        return "";
    }
}

