package com.dtyunxi.yundt.cube.center.inventory.api.inventory;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.MqContentOrderDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.inventory.req.MqMessageReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
* MQ报文（发货/收货通知单）服务接口
*
* @author 杰俊
* @since 2021-09-28
*/
@Api(tags = {"MQ报文（发货/收货通知单）服务"})
@FeignClient(name = "${yundt.cube.center.inventory.api.name:yundt-cube-center-inventory}", path = "/v1/mqMessage", url = "${yundt.cube.center.inventory.api:}")
public interface IMqMessageApi {

    /**
    * 新增MQ报文并发送发货通知单MQ至营销云
    *
    * @param dto 请求对象
    */
    @PostMapping("/sendDeliverOrderInform")
    @ApiOperation(value = "新增MQ报文并发送发货通知单MQ至营销云", notes = "新增MQ报文并发送发货通知单MQ至营销云")
    RestResponse<Void> sendDeliverOrderInform(@RequestBody MqContentOrderDto dto);

    /**
     * 新增MQ报文并发送收货通知单MQ至营销云
     *
     * @param dto 请求对象
     */
    @PostMapping("/sendReceiveOrderInformMq")
    @ApiOperation(value = "新增MQ报文并发送收货通知单MQ至营销云", notes = "新增MQ报文并发送收货通知单MQ至营销云")
    RestResponse<Void> sendReceiveOrderInformMq(@RequestBody MqContentOrderDto dto);

    /**
     * 修复表“in_mq_message”字段"no"的数据数据信息
     *
     * @return 执行结果
     */
    @GetMapping("/repairDataOfNo")
    @ApiOperation(value = "修复表'in_mq_message'字段'no'的数据数据信息", notes = "修复表“in_mq_message”字段'no'的数据数据信息")
    RestResponse<String> repairDataOfNo();
}
