/**
 * @(#)CsActivityInventoryLogRespDto.java 1.0 2022/01/17 10:26
 * <p>
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.log;

import com.dtyunxi.dto.BaseRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
* @Description CsActivityInventoryLogRespDto
*
* @author jingran
* @Date: 2022/01/17 10:26
* @since 1.0.0
*/
@ApiModel(value = "csActivityInventoryLogRespDto", description = "返回信息Dto")
public class CsActivityInventoryLogRespDto extends BaseRespDto {

    /** 活动ID */
    @ApiModelProperty(name="activityId",value = "活动ID")
    private Long activityId;
    /** 活动编码 */
    @ApiModelProperty(name="activityCode",value = "活动编码")
    private String activityCode;
    /** 套装编码 */
    @ApiModelProperty(name="suitCode",value = "套装编码")
    private String suitCode;
    /** 活动名称 */
    @ApiModelProperty(name="activityName",value = "活动名称")
    private String activityName;
    /** 套装名称 */
    @ApiModelProperty(name="suitName",value = "套装名称")
    private String suitName;
    /** 活动类型 */
    @ApiModelProperty(name="activityType",value = "活动类型")
    private String activityType;
    /** 活动套数 */
    @ApiModelProperty(name="activityNum",value = "活动套数")
    private Integer activityNum;
    /** 店铺ID */
    @ApiModelProperty(name="shopId",value = "店铺ID")
    private Long shopId;
    /** 仓库ID */
    @ApiModelProperty(name="warehouseId",value = "仓库ID")
    private Long warehouseId;
    /** 仓库编码 */
    @ApiModelProperty(name="warehouseCode",value = "仓库编码")
    private String warehouseCode;
    /** 仓库名称 */
    @ApiModelProperty(name="warehouseName",value = "仓库名称")
    private String warehouseName;
    /** 批次 */
    @ApiModelProperty(name="batch",value = "批次")
    private String batch;
    /** 货品ID */
    @ApiModelProperty(name="cargoId",value = "货品ID")
    private Long cargoId;
    /** 货品编码 */
    @ApiModelProperty(name="cargoCode",value = "货品编码")
    private String cargoCode;
    /** 货品名称 */
    @ApiModelProperty(name="cargoName",value = "货品名称")
    private String cargoName;
    /** 货品货号 */
    @ApiModelProperty(name="artNo",value = "货品货号")
    private String artNo;
    /** 变动前总库存 */
    @ApiModelProperty(name="beforeBalance",value = "变动前总库存")
    private BigDecimal beforeBalance;
    /** 变动总库存 */
    @ApiModelProperty(name="changeBalance",value = "变动总库存")
    private BigDecimal changeBalance;
    /** 变动后总库存 */
    @ApiModelProperty(name="afterBalance",value = "变动后总库存")
    private BigDecimal afterBalance;
    /** 变动前预占库存 */
    @ApiModelProperty(name="beforePreempt",value = "变动前预占库存")
    private BigDecimal beforePreempt;
    /** 变动预占库存 */
    @ApiModelProperty(name="changePreempt",value = "变动预占库存")
    private BigDecimal changePreempt;
    /** 变动后预占库存 */
    @ApiModelProperty(name="afterPreempt",value = "变动后预占库存")
    private BigDecimal afterPreempt;
    /** 变动前已完成库存 */
    @ApiModelProperty(name="beforeCompleted",value = "变动前已完成库存")
    private BigDecimal beforeCompleted;
    /** 变动已完成库存 */
    @ApiModelProperty(name="changeCompleted",value = "变动已完成库存")
    private BigDecimal changeCompleted;
    /** 变动后已完成库存 */
    @ApiModelProperty(name="afterCompleted",value = "变动后已完成库存")
    private BigDecimal afterCompleted;
    /** 变动前可用库存 */
    @ApiModelProperty(name="beforeAvailable",value = "变动前可用库存")
    private BigDecimal beforeAvailable;
    /** 变动可用库存 */
    @ApiModelProperty(name="changeAvailable",value = "变动可用库存")
    private BigDecimal changeAvailable;
    /** 变动后可用库存 */
    @ApiModelProperty(name="afterAvailable",value = "变动后可用库存")
    private BigDecimal afterAvailable;
    /** 单据类型,待定 */
    @ApiModelProperty(name="sourceType",value = "单据类型,待定")
    private String sourceType;
    /** 关联单据号 */
    @ApiModelProperty(name="sourceNo",value = "关联单据号")
    private String sourceNo;
    /** 出入库标识  in-入库  out-出库 */
    @ApiModelProperty(name="inOutFlag",value = "出入库标识  in-入库  out-出库")
    private String inOutFlag;
    /** 变更时间 */
    @ApiModelProperty(name="changeTime",value = "变更时间")
    private Date changeTime;

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getActivityCode() {
        return activityCode;
    }

    public void setActivityCode(String activityCode) {
        this.activityCode = activityCode;
    }

    public String getSuitCode() {
        return suitCode;
    }

    public void setSuitCode(String suitCode) {
        this.suitCode = suitCode;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public String getSuitName() {
        return suitName;
    }

    public void setSuitName(String suitName) {
        this.suitName = suitName;
    }

    public String getActivityType() {
        return activityType;
    }

    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    public Integer getActivityNum() {
        return activityNum;
    }

    public void setActivityNum(Integer activityNum) {
        this.activityNum = activityNum;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getWarehouseId() {
        return warehouseId;
    }

    public void setWarehouseId(Long warehouseId) {
        this.warehouseId = warehouseId;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public String getWarehouseName() {
        return warehouseName;
    }

    public void setWarehouseName(String warehouseName) {
        this.warehouseName = warehouseName;
    }

    public String getBatch() {
        return batch;
    }

    public void setBatch(String batch) {
        this.batch = batch;
    }

    public Long getCargoId() {
        return cargoId;
    }

    public void setCargoId(Long cargoId) {
        this.cargoId = cargoId;
    }

    public String getCargoCode() {
        return cargoCode;
    }

    public void setCargoCode(String cargoCode) {
        this.cargoCode = cargoCode;
    }

    public String getCargoName() {
        return cargoName;
    }

    public void setCargoName(String cargoName) {
        this.cargoName = cargoName;
    }

    public BigDecimal getBeforeBalance() {
        return beforeBalance;
    }

    public void setBeforeBalance(BigDecimal beforeBalance) {
        this.beforeBalance = beforeBalance;
    }

    public BigDecimal getChangeBalance() {
        return changeBalance;
    }

    public void setChangeBalance(BigDecimal changeBalance) {
        this.changeBalance = changeBalance;
    }

    public BigDecimal getAfterBalance() {
        return afterBalance;
    }

    public void setAfterBalance(BigDecimal afterBalance) {
        this.afterBalance = afterBalance;
    }

    public BigDecimal getBeforePreempt() {
        return beforePreempt;
    }

    public void setBeforePreempt(BigDecimal beforePreempt) {
        this.beforePreempt = beforePreempt;
    }

    public BigDecimal getChangePreempt() {
        return changePreempt;
    }

    public void setChangePreempt(BigDecimal changePreempt) {
        this.changePreempt = changePreempt;
    }

    public BigDecimal getAfterPreempt() {
        return afterPreempt;
    }

    public void setAfterPreempt(BigDecimal afterPreempt) {
        this.afterPreempt = afterPreempt;
    }

    public BigDecimal getBeforeCompleted() {
        return beforeCompleted;
    }

    public void setBeforeCompleted(BigDecimal beforeCompleted) {
        this.beforeCompleted = beforeCompleted;
    }

    public BigDecimal getChangeCompleted() {
        return changeCompleted;
    }

    public void setChangeCompleted(BigDecimal changeCompleted) {
        this.changeCompleted = changeCompleted;
    }

    public BigDecimal getAfterCompleted() {
        return afterCompleted;
    }

    public void setAfterCompleted(BigDecimal afterCompleted) {
        this.afterCompleted = afterCompleted;
    }

    public BigDecimal getBeforeAvailable() {
        return beforeAvailable;
    }

    public void setBeforeAvailable(BigDecimal beforeAvailable) {
        this.beforeAvailable = beforeAvailable;
    }

    public BigDecimal getChangeAvailable() {
        return changeAvailable;
    }

    public void setChangeAvailable(BigDecimal changeAvailable) {
        this.changeAvailable = changeAvailable;
    }

    public BigDecimal getAfterAvailable() {
        return afterAvailable;
    }

    public void setAfterAvailable(BigDecimal afterAvailable) {
        this.afterAvailable = afterAvailable;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public String getSourceNo() {
        return sourceNo;
    }

    public void setSourceNo(String sourceNo) {
        this.sourceNo = sourceNo;
    }

    public String getInOutFlag() {
        return inOutFlag;
    }

    public void setInOutFlag(String inOutFlag) {
        this.inOutFlag = inOutFlag;
    }

    public String getArtNo() {
        return artNo;
    }

    public void setArtNo(String artNo) {
        this.artNo = artNo;
    }

    public Date getChangeTime() {
        return changeTime;
    }

    public void setChangeTime(Date changeTime) {
        this.changeTime = changeTime;
    }
}

